/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.TemplateFileReferenceSet;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GspTemplateAttributeSupport
extends TagAttributeReferenceProvider {
    protected GspTemplateAttributeSupport() {
        super("template", "g", null);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
        }
        PsiFile psiFile = element.getContainingFile();
        String controllerName = psiFile != null && psiFile.getViewProvider() instanceof GspFileViewProvider && (file = psiFile.getOriginalFile().getVirtualFile()) != null ? GrailsUtils.getExistingControllerNameDirByGsp(file, psiFile.getProject()) : null;
        if (!text.startsWith("/") && controllerName == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement pluginAttribute = gspTagWrapper.getAttributeValue("plugin");
        if (pluginAttribute != null) {
            if (gspTagWrapper.getAttributeText(pluginAttribute) == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        } else {
            PsiElement contextPathAttribute = gspTagWrapper.getAttributeValue("contextPath");
            if (contextPathAttribute != null && gspTagWrapper.getAttributeText(contextPathAttribute) == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        }
        TemplateFileReferenceSet set = new TemplateFileReferenceSet(controllerName, PathReference.trimPath((String)text), element, offset, null, true, true, gspTagWrapper);
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspTemplateAttributeSupport", "getReferencesByElement"));
        }
        return fileReferenceArray;
    }
}

