/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.impl.GrailsCommandLineState;
import org.jetbrains.plugins.grails.runner.impl.GrailsTestCommandLineState;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public abstract class GrailsCommandLineExecutor
extends GrailsCommandExecutor {
    @Override
    @Nullable
    public RunProfileState getState(@NotNull GrailsRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "getState"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "getState"));
        }
        String programParameters = configuration.getProgramParameters();
        Version version = configuration.getGrailsApplication().getGrailsVersion();
        if (version.compareTo(Version.GRAILS_1_2) >= 0 && programParameters != null && programParameters.matches("\\s*(-D[^\\s]+\\s+)*test-app(\\s.*)?")) {
            return new GrailsTestCommandLineState(environment, configuration, this);
        }
        return new GrailsCommandLineState(environment, configuration, this);
    }

    @Override
    @Nullable
    public ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, @Nullable Runnable onDone, boolean close, String ... input) throws ExecutionException {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "execute"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "execute"));
        }
        Project project = application.getProject();
        return GrailsConsole.getInstance(project).executeProcess(this.createCommandLine(application, command), onDone, true, close, input);
    }

    public GeneralCommandLine createCommandLine(@NotNull GrailsApplication application, @NotNull MvcCommand command) throws ExecutionException {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "createCommandLine"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "createCommandLine"));
        }
        JavaParameters params = this.createJavaParameters(application, command);
        params.setUseDynamicClasspath(application.getProject());
        return params.toCommandLine();
    }

    @NotNull
    public abstract JavaParameters createJavaParameters(@NotNull GrailsApplication var1, @NotNull MvcCommand var2) throws ExecutionException;

    public void addListener(@NotNull JavaParameters params, @NotNull String listener) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor", "addListener"));
        }
        String listeners = params.getVMParametersList().getPropertyValue("grails.build.listeners");
        listeners = listeners != null ? (listeners.startsWith("\"") && listeners.endsWith("\"") ? "\"" + listeners.substring(1, listeners.length() - 2) + "," + listener + "\"" : "\"" + listeners + "," + listener + "\"") : listener;
        params.getVMParametersList().replaceOrAppend("grails.build.listeners", "-Dgrails.build.listeners=" + listeners);
    }
}

