/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.sdk;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsSDK {
    @NotNull
    private final String myPath;
    @NotNull
    private final Version myVersion;

    public GrailsSDK(@NotNull String path, @NotNull Version version) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/grails/sdk/GrailsSDK", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/plugins/grails/sdk/GrailsSDK", "<init>"));
        }
        this.myPath = path;
        this.myVersion = version;
    }

    @NotNull
    public Version getVersion() {
        Version version = this.myVersion;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/sdk/GrailsSDK", "getVersion"));
        }
        return version;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/sdk/GrailsSDK", "getPath"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrailsSDK sdk = (GrailsSDK)o;
        if (!this.myVersion.equals(sdk.myVersion)) {
            return false;
        }
        return this.myPath.equals(sdk.myPath);
    }

    public int hashCode() {
        int result2 = this.myVersion.hashCode();
        result2 = 31 * result2 + this.myPath.hashCode();
        return result2;
    }

    public String toString() {
        return String.format("GrailsSDK {myPath='%s', myVersion=%s}", this.myPath, this.myVersion);
    }
}

