/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.model.SpringBeanPointer;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.spring.InjectedSpringBeanProvider;
import org.jetbrains.plugins.grails.util.ReferenceGutterIconRenderer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public class SpringInjectionAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/spring/SpringInjectionAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/grails/spring/SpringInjectionAnnotator", "annotate"));
        }
        if (!(element instanceof GrField)) {
            return;
        }
        SpringBeanPointer bean = InjectedSpringBeanProvider.getInjectedBean((PsiVariable)((GrField)element));
        if (bean == null) {
            return;
        }
        PsiElement navigateElement = bean.getPsiElement();
        if (!(navigateElement instanceof Navigatable)) {
            return;
        }
        Annotation annotation = holder.createInfoAnnotation(element, null);
        annotation.setGutterIconRenderer((GutterIconRenderer)new ReferenceGutterIconRenderer((Navigatable)navigateElement, SpringApiIcons.SpringBean, "Injected Spring Bean: " + bean.getName()));
    }
}

