/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SafeReference
implements PsiReference {
    private final PsiReferenceBase myDelegate;
    private final SafeReference myNextReference;

    public SafeReference(PsiReferenceBase delegate, SafeReference nextReference) {
        this.myDelegate = delegate;
        this.myNextReference = nextReference;
    }

    public PsiElement getElement() {
        return this.myDelegate.getElement();
    }

    public TextRange getRangeInElement() {
        return this.myDelegate.getRangeInElement();
    }

    public PsiElement resolve() {
        return this.myDelegate.resolve();
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myDelegate.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/SafeReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        int lengthBefore = this.myDelegate.getRangeInElement().getLength();
        PsiElement res = this.myDelegate.handleElementRename(newElementName);
        int delta = this.myDelegate.getRangeInElement().getLength() - lengthBefore;
        SafeReference ref = this.myNextReference;
        while (ref != null) {
            ref.myDelegate.setRangeInElement(ref.getRangeInElement().shiftRight(delta));
            ref = ref.myNextReference;
        }
        return res;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/SafeReference", "bindToElement"));
        }
        return this.myDelegate.bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myDelegate.isReferenceTo(element);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.myDelegate.getVariants();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/SafeReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return this.myDelegate.isSoft();
    }

    public static void makeReferencesSafe(@NotNull PsiReference[] referencesInSameElement) {
        if (referencesInSameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencesInSameElement", "org/jetbrains/plugins/grails/util/SafeReference", "makeReferencesSafe"));
        }
        if (referencesInSameElement.length < 2) {
            return;
        }
        int last = referencesInSameElement.length - 1;
        referencesInSameElement[last] = new SafeReference((PsiReferenceBase)referencesInSameElement[last], null);
        for (int i = last; i > 0; --i) {
            PsiReference ref1 = referencesInSameElement[i - 1];
            PsiReference ref2 = referencesInSameElement[i];
            assert (ref1.getRangeInElement().getEndOffset() <= ref2.getRangeInElement().getStartOffset());
            assert (ref1.getElement() == ref2.getElement());
            referencesInSameElement[i - 1] = new SafeReference((PsiReferenceBase)ref1, (SafeReference)ref2);
        }
    }
}

