/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettingSynchronizer;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrailsSynchronizeStructureAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator", "annotate"));
        }
        if (!(element instanceof GroovyFile)) {
            return;
        }
        VirtualFile file = ((GroovyFile)element).getVirtualFile();
        if (file == null || !file.getName().equals("BuildConfig.groovy")) {
            return;
        }
        VirtualFile confDir = file.getParent();
        if (confDir == null || !confDir.getName().equals("conf")) {
            return;
        }
        VirtualFile grailsApp = confDir.getParent();
        if (grailsApp == null || !grailsApp.getName().equals("grails-app")) {
            return;
        }
        GrailsApplication application = GrailsApplicationManager.getInstance(element.getProject()).findApplication(grailsApp);
        if (!(application instanceof Grails2Application)) {
            return;
        }
        final Grails2Application grails2Application = (Grails2Application)application;
        if (GrailsSettingSynchronizer.isUpdateSettingRunning(grails2Application.getModule())) {
            return;
        }
        if (!GrailsSettingsService.getGrailsSettings(grails2Application.getModule()).isBuildConfigOutdated(element.getText())) {
            return;
        }
        Annotation annotation = holder.createWarningAnnotation(element, "Grails configuration may be outdated");
        annotation.setFileLevelAnnotation(true);
        annotation.registerFix(new IntentionAction(){

            @NotNull
            public String getText() {
                if ("Apply Grails changes to IDEA project structure" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "getText"));
                }
                return "Apply Grails changes to IDEA project structure";
            }

            @NotNull
            public String getFamilyName() {
                if ("Apply" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "getFamilyName"));
                }
                return "Apply";
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "isAvailable"));
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "invoke"));
                }
                GrailsFramework.forceSynchronizationSetting(grails2Application.getModule());
            }

            public boolean startInWriteAction() {
                return false;
            }
        });
        annotation.registerFix(new IntentionAction(){

            @NotNull
            public String getText() {
                if ("Ignore" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "getText"));
                }
                return "Ignore";
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "getFamilyName"));
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "isAvailable"));
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile f) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "invoke"));
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                GrailsSettingsService.getGrailsSettings(grails2Application.getModule()).updateBuildConfig(f.getText());
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            @Nullable
            public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "getElementToMakeWritable"));
                }
                return null;
            }

            public boolean startInWriteAction() {
                return true;
            }
        });
    }
}

