/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J4\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaTypeAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "findInaccessibleJavaTypes", "", "type", "findInaccessibleJavaTypesRec", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "inaccessibleTypes", "Lcom/intellij/util/SmartList;", "visitedTypeConstructors", "", "kotlin-compiler"})
public final class JavaTypeAccessibilityChecker
implements AdditionalTypeChecker {
    @Override
    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(expressionType, "expressionType");
        Intrinsics.checkParameterIsNotNull(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (c.isDebuggerContext) {
            return;
        }
        List<KotlinType> inaccessibleTypes = this.findInaccessibleJavaTypes(expressionType, c);
        Collection collection = inaccessibleTypes;
        if (!collection.isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression), expressionType, inaccessibleTypes));
            return;
        }
        if (Intrinsics.areEqual(expressionTypeWithSmartCast, expressionType) ^ true) {
            List<KotlinType> inaccessibleTypesWithSmartCast = this.findInaccessibleJavaTypes(expressionTypeWithSmartCast, c);
            Collection collection2 = inaccessibleTypesWithSmartCast;
            if (!collection2.isEmpty()) {
                c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression), expressionType, inaccessibleTypes));
            }
        }
    }

    private final List<KotlinType> findInaccessibleJavaTypes(KotlinType type2, ResolutionContext<?> c) {
        DeclarationDescriptor scopeOwner = c.scope.getOwnerDescriptor();
        SmartList<KotlinType> inaccessibleTypes = new SmartList<KotlinType>();
        this.findInaccessibleJavaTypesRec(type2, scopeOwner, inaccessibleTypes, (Set<DeclarationDescriptor>)SetsKt.hashSetOf(new DeclarationDescriptor[0]));
        return inaccessibleTypes;
    }

    private final void findInaccessibleJavaTypesRec(KotlinType type2, DeclarationDescriptor scopeOwner, SmartList<KotlinType> inaccessibleTypes, Set<DeclarationDescriptor> visitedTypeConstructors) {
        ClassifierDescriptor typeConstructor2 = type2.getConstructor().getDeclarationDescriptor();
        if (typeConstructor2 instanceof ClassDescriptor) {
            if (visitedTypeConstructors.contains(typeConstructor2)) {
                return;
            }
            visitedTypeConstructors.add(typeConstructor2);
            if (typeConstructor2 instanceof JavaClassDescriptor && !Visibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((Object)typeConstructor2), scopeOwner)) {
                inaccessibleTypes.add(type2);
            }
            for (TypeProjection typeProjection : type2.getArguments()) {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeProjection.type");
                this.findInaccessibleJavaTypesRec(kotlinType, scopeOwner, inaccessibleTypes, visitedTypeConstructors);
            }
        }
    }
}

