/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ChangeMethodReturnTypeFix
implements LocalQuickFix {
    PsiType myType;
    String myName;

    public ChangeMethodReturnTypeFix(@NotNull PsiType type, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ws/rest/inspections/fixes/ChangeMethodReturnTypeFix", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/rest/inspections/fixes/ChangeMethodReturnTypeFix", "<init>"));
        }
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/fixes/ChangeMethodReturnTypeFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/inspections/fixes/ChangeMethodReturnTypeFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/rest/inspections/fixes/ChangeMethodReturnTypeFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiTypeElement)) {
            return;
        }
        PsiTypeElement returnType = (PsiTypeElement)element;
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiClassType type = PsiType.getJavaLangString((PsiManager)returnType.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            PsiMethod method = (PsiMethod)returnType.getParent();
            returnType.replace((PsiElement)factory.createTypeElement((PsiType)type));
            PsiStatement returnStatement = factory.createStatementFromText("return null; //TODO replace this stub to something useful", null);
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                body.add((PsiElement)returnStatement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

