/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.utils.RSUtils;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class CreateFieldWithPathParamFix
implements LocalQuickFix {
    private static final String FIELD_TEMPLATE = "private String {0};\n";
    private final String name;
    private final PsiClass context;

    public CreateFieldWithPathParamFix(String name, PsiClass context) {
        this.name = name;
        this.context = context;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("create.field.annotated.path.param", this.name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/fixes/CreateFieldWithPathParamFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiField[] fields;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/inspections/fixes/CreateFieldWithPathParamFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/rest/inspections/fixes/CreateFieldWithPathParamFix", "applyFix"));
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
        if (psiClass == null) {
            return;
        }
        String text = MessageFormat.format(FIELD_TEMPLATE, this.name);
        PsiField field = JavaPsiFacade.getElementFactory((Project)project).createFieldFromText(text, null);
        PsiElement element = this.context.addAfter((PsiElement)field, (PsiElement)((fields = this.context.getFields()).length == 0 ? this.context.getLBrace() : fields[fields.length - 1]));
        if (element instanceof PsiField) {
            RSUtils.annotateFieldWithPathParam(project, (PsiField)element, this.name);
        }
    }
}

