/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.ws.rest.references.RestPathReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestPathReferenceProvider
extends WSReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteralExpression literal;
        Object value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/rest/references/RestPathReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/rest/references/RestPathReferenceProvider", "getReferencesByElement"));
        }
        ArrayList<RestPathReference> refs = new ArrayList<RestPathReference>();
        if (element instanceof PsiLiteralExpression && (value = (literal = (PsiLiteralExpression)element).getValue()) instanceof String) {
            String path = (String)value;
            if (path.length() > 0) {
                List names;
                try {
                    UriTemplateParser parser = new UriTemplateParser(path);
                    names = parser.getNames();
                }
                catch (Exception e) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/RestPathReferenceProvider", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                for (String name : names) {
                    int index = path.indexOf("{" + name + "}");
                    TextRange range = TextRange.from((int)(index + 2), (int)name.length());
                    refs.add(new RestPathReference(literal, range, name));
                }
            }
            PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/RestPathReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/RestPathReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public ElementPattern<? extends PsiElement> getPattern() {
        return PsiJavaPatterns.literalExpression().annotationParam("javax.ws.rs.Path");
    }
}

