/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ClassesWithAnnotatedMembersSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    public static boolean findAllTestClasses(final TestClassFilter testClassFilter, final Set<PsiClass> found) {
        PsiMethod[] suiteMethods;
        PsiManager manager = testClassFilter.getPsiManager();
        final Project project = manager.getProject();
        GlobalSearchScope projectScopeWithoutLibraries = GlobalSearchScope.projectScope((Project)project);
        final GlobalSearchScope scope = projectScopeWithoutLibraries.intersectWith(testClassFilter.getScope());
        PsiClass base = testClassFilter.getBase();
        if (base != null) {
            ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiClass>(){

                public boolean processInReadAction(PsiClass aClass) {
                    if (testClassFilter.isAccepted(aClass)) {
                        found.add(aClass);
                    }
                    return true;
                }
            });
        }
        for (PsiMethod method : suiteMethods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return PsiShortNamesCache.getInstance((Project)project).getMethodsByName("suite", scope);
            }
        })) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                if (containingClass instanceof PsiAnonymousClass) {
                    return;
                }
                if (containingClass.hasModifierProperty("abstract")) {
                    return;
                }
                if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                    return;
                }
                if (JUnitUtil.isSuiteMethod((PsiMethod)method) && testClassFilter.isAccepted(containingClass)) {
                    found.add(containingClass);
                }
            });
        }
        HashSet processed = ContainerUtil.newHashSet();
        boolean hasJunit4 = ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, processed, "org.junit.Test");
        return hasJunit4 |= ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, processed, "org.junit.runner.RunWith");
    }

    private static boolean addAnnotatedMethodsAnSubclasses(final PsiManager manager, GlobalSearchScope scope, final TestClassFilter testClassFilter, final Set<PsiClass> found, final Set<PsiClass> processed, final String annotation) {
        final Ref isJUnit4 = new Ref((Object)Boolean.FALSE);
        PsiClass testAnnotation = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(annotation, GlobalSearchScope.allScope((Project)manager.getProject()));
            }
        });
        if (testAnnotation != null) {
            ClassesWithAnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject())).forEach(annotated -> {
                AccessToken token = ReadAction.start();
                try {
                    if (!processed.add((PsiClass)annotated)) {
                        boolean bl = true;
                        return bl;
                    }
                    VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)annotated);
                    if (file != null && scope.contains(file) && testClassFilter.isAccepted((PsiClass)annotated)) {
                        if (!found.add((PsiClass)annotated)) {
                            boolean bl = true;
                            return bl;
                        }
                        isJUnit4.set((Object)Boolean.TRUE);
                    }
                }
                finally {
                    token.finish();
                }
                ClassInheritorsSearch.search((PsiClass)annotated, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiClass>(){

                    public boolean processInReadAction(PsiClass aClass) {
                        if (testClassFilter.isAccepted(aClass)) {
                            found.add(aClass);
                            processed.add(aClass);
                            isJUnit4.set((Object)Boolean.TRUE);
                        }
                        return true;
                    }
                });
                return true;
            });
        }
        return (Boolean)isJUnit4.get();
    }
}

