/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit4Framework
extends JavaTestFramework {
    @NotNull
    public String getName() {
        if ("JUnit4" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnit4Framework", "getName"));
        }
        return "JUnit4";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.RunConfigurations.Junit;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnit4Framework", "getIcon"));
        }
        return icon;
    }

    protected String getMarkerClassFQName() {
        return "org.junit.Test";
    }

    @Nullable
    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return JUnitExternalLibraryDescriptor.JUNIT4;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (canBePotential) {
            return this.isUnderTestSources(clazz);
        }
        return JUnitUtil.isJUnit4TestClass((PsiClass)clazz);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/execution/junit/JUnit4Framework", "findSetUpMethod"));
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.Before", (boolean)false)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/execution/junit/JUnit4Framework", "findTearDownMethod"));
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.After", (boolean)false)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        String beforeClassAnnotationName = "org.junit.BeforeClass";
        String beforeAnnotationName = "org.junit.Before";
        return this.findOrCreateSetUpMethod(clazz, beforeClassAnnotationName, beforeAnnotationName);
    }

    private PsiMethod findOrCreateSetUpMethod(PsiClass clazz, String beforeClassAnnotationName, String beforeAnnotationName) {
        PsiMethod testMethod;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        method = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod existingMethod = clazz.findMethodBySignature(method, false);
        if (existingMethod != null) {
            int exit;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)existingMethod, (String)beforeClassAnnotationName, (boolean)false)) {
                return existingMethod;
            }
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((String)"Method setUp already exist but is not annotated as @Before. Annotate?", (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                new AddAnnotationFix(beforeAnnotationName, (PsiModifierListOwner)existingMethod, new String[0]).invoke(existingMethod.getProject(), null, existingMethod.getContainingFile());
                return existingMethod;
            }
        }
        method = (testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz)) != null ? (PsiMethod)clazz.addBefore((PsiElement)method, (PsiElement)testMethod) : (PsiMethod)clazz.add((PsiElement)method);
        JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)method);
        return method;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        PsiMethod testMethod = element instanceof PsiMethod ? JUnitUtil.getTestMethod((PsiElement)element) : null;
        return testMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)testMethod, (String)"org.junit.Ignore", (boolean)false);
    }

    public boolean isTestMethod(PsiElement element) {
        return element instanceof PsiMethod && JUnitUtil.getTestMethod((PsiElement)element) != null;
    }

    public boolean isTestMethod(PsiMethod method, PsiClass myClass) {
        return JUnitUtil.isTestMethod((Location)MethodLocation.elementInClass((PsiMethod)method, (PsiClass)myClass));
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 SetUp Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 TearDown Method.java");
    }

    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Test Method.java");
    }

    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Parameters Method.java");
    }

    public char getMnemonic() {
        return '4';
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Test Class.java");
    }

    public boolean isParameterized(PsiClass clazz) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{"org.junit.runner.RunWith"});
        return annotation != null && JUnitUtil.isParameterized((PsiAnnotation)annotation);
    }

    public PsiMethod findParametersMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.getAllMethods()) {
            if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.runners.Parameterized.Parameters", (boolean)false)) continue;
            return method;
        }
        return null;
    }
}

