/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentEditor;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.JavaDeploymentSourceUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFDeploymentConfigurator
extends DeploymentConfigurator<CFDeploymentConfiguration, CFServerConfiguration> {
    private final Project myProject;

    public CFDeploymentConfigurator(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<DeploymentSource> getAvailableDeploymentSources() {
        List list = JavaDeploymentSourceUtil.getInstance().createArtifactDeploymentSources(this.myProject, new ArtifactType[]{WarArtifactType.getInstance(), JarArtifactType.getInstance()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentConfigurator", "getAvailableDeploymentSources"));
        }
        return list;
    }

    @NotNull
    public CFDeploymentConfiguration createDefaultConfiguration(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentConfigurator", "createDefaultConfiguration"));
        }
        CFDeploymentConfiguration cFDeploymentConfiguration = new CFDeploymentConfiguration();
        if (cFDeploymentConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentConfigurator", "createDefaultConfiguration"));
        }
        return cFDeploymentConfiguration;
    }

    @Nullable
    public SettingsEditor<CFDeploymentConfiguration> createEditor(@NotNull DeploymentSource source, @NotNull RemoteServer<CFServerConfiguration> server) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentConfigurator", "createEditor"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentConfigurator", "createEditor"));
        }
        return new CFDeploymentEditor(this.myProject, server, source);
    }
}

