/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.debugger.JavaScriptDebuggerEvaluator;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.debugger.TraceSessionEvaluator;
import com.intellij.javascript.trace.debugger.values.TraceObjectWithLength;
import com.intellij.javascript.trace.debugger.values.TraceValueManager;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.IndexedPsiFile;
import com.intellij.javascript.trace.execution.common.PropertyMetadata;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.HashMap;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueType;

public class ExpressionEvaluator
implements VariableContext,
EvaluateContext,
TraceSessionEvaluator {
    private final String myFilePath;
    private final TraceSession mySession;
    private ExpressionEvaluationResult myCachedResult;
    private final IndexedPsiFile myFile;
    private static final Logger LOG = Logger.getInstance(ExpressionEvaluator.class);

    public ExpressionEvaluator(TraceSession session, IndexedPsiFile file, String url) {
        UsageTrigger.trigger((String)TraceBundle.message("usage.evaluator.create", new Object[0]));
        this.myFile = file;
        this.mySession = session;
        this.myFilePath = url;
    }

    @Nullable
    public Vm getVm() {
        return null;
    }

    @Override
    public void cache(ExpressionEvaluationResult result) {
        this.myCachedResult = result;
    }

    @Override
    public Promise<ExpressionEvaluationResult> evaluateExpression(ExpressionEvaluationRequest request) {
        if (this.myCachedResult != null) {
            LOG.info("Cached evaluation result returned");
            return Promise.resolve((Object)this.myCachedResult);
        }
        Integer function = this.myFile.getFunctionId(request.getContext());
        if (function == null) {
            LOG.info("Trace function id for PSI element not found");
            return Promise.resolve((Object)new ExpressionEvaluationResult(null, new PropertyMetadata[0], false, true));
        }
        request.setFunctionId(function);
        request.setTotalNumberOfFunctions(this.myFile.getFunctionNumber());
        request.setFile(this.myFilePath);
        return ExpressionEvaluator.evaluateExpression(this.mySession, request);
    }

    @NotNull
    private static Promise<ExpressionEvaluationResult> evaluateExpression(final TraceSession session, final ExpressionEvaluationRequest request) {
        final AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){
            final ExpressionEvaluationResult[] value = new ExpressionEvaluationResult[]{new ExpressionEvaluationResult(null, new PropertyMetadata[0], false, false)};
            final Semaphore semaphore = new Semaphore();
            boolean done = false;

            @Override
            public void run() {
                this.semaphore.down();
                session.evaluateExpression(request, (Consumer<ExpressionEvaluationResult>)((Consumer)evaluationResult -> {
                    this.value[0] = evaluationResult;
                    this.done = true;
                    this.semaphore.up();
                }));
                this.semaphore.waitFor(request.getTimeout());
                if (!this.done) {
                    LOG.info("Expression evaluation was not finished in time");
                }
                result.setResult((Object)this.value[0]);
            }
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "evaluateExpression"));
        }
        return asyncPromise;
    }

    @Override
    public ContextMetadata getContextMetadata(String context) {
        return this.mySession.getContextMetadata(context);
    }

    @Override
    public boolean isReadyToEvaluate() {
        return !this.mySession.isLoaded() && this.mySession.isRunning();
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile.getPsiFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "getFile"));
        }
        return psiFile;
    }

    public static XDebuggerEvaluator getDebuggerEvaluator(Project project, PsiFile file) {
        IndexedPsiFile indexedPsiFile = IndexedPsiFile.getIndexedPsiFile(project, file, true);
        if (indexedPsiFile == null) {
            return null;
        }
        ExpressionEvaluator evaluator = indexedPsiFile.getEvaluator();
        return evaluator.isReadyToEvaluate() ? new MyEvaluator(evaluator) : null;
    }

    public static TraceSessionEvaluator getRemoteEvaluator(Project project, PsiFile file) {
        IndexedPsiFile indexedPsiFile = IndexedPsiFile.getIndexedPsiFile(project, file, true);
        if (indexedPsiFile == null) {
            return null;
        }
        return indexedPsiFile.getEvaluator();
    }

    private static PsiElement getFunctionContext(Map<String, ?> additionalContext) {
        return ((FunctionContext)additionalContext.get("function_context")).getPosition();
    }

    @NotNull
    public Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable Map<String, ?> additionalContext, boolean enableBreak) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "evaluate"));
        }
        PsiElement functionContext = ExpressionEvaluator.getFunctionContext(additionalContext);
        Promise promise = this.evaluateExpression(ExpressionEvaluationRequest.createObjectRequest(functionContext, expression)).then(result -> {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "lambda$evaluate$0"));
            }
            return new EvaluateResult(new TraceValueManager(this, functionContext).createValue(expression, result.getValue()), false);
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "evaluate"));
        }
        return promise;
    }

    @NotNull
    public EvaluateContext withValueManager(@NotNull String objectGroup) {
        if (objectGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectGroup", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "withValueManager"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Promise<?> refreshOnDone(@NotNull Promise<?> promise) {
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "refreshOnDone"));
        }
        throw new UnsupportedOperationException();
    }

    public void releaseObjects() {
    }

    @NotNull
    public EvaluateContext getEvaluateContext() {
        ExpressionEvaluator expressionEvaluator = this;
        if (expressionEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "getEvaluateContext"));
        }
        return expressionEvaluator;
    }

    @Nullable
    public String getVariableName() {
        return null;
    }

    @Nullable
    public VariableContext getParent() {
        return null;
    }

    public boolean watchableAsEvaluationExpression() {
        return false;
    }

    @NotNull
    public DebuggerViewSupport getViewSupport() {
        MyDebuggerViewSupport myDebuggerViewSupport = new MyDebuggerViewSupport();
        if (myDebuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator", "getViewSupport"));
        }
        return myDebuggerViewSupport;
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Scope getScope() {
        return null;
    }

    private static class MyDebuggerViewSupport
    extends BasicDebuggerViewSupport {
        private static final List<String> LENGTH_AVAILABLE_TYPES = Collections.singletonList("Buffer");

        private MyDebuggerViewSupport() {
        }

        public void computeObjectPresentation(final @NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (LENGTH_AVAILABLE_TYPES.contains(value.getClassName()) && value instanceof TraceObjectWithLength) {
                node.setPresentation(icon, new XValuePresentation(){

                    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                        if (renderer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport$1", "renderValue"));
                        }
                        renderer.renderSpecialSymbol(value.getClassName() + "[");
                        renderer.renderSpecialSymbol(Integer.toString(((TraceObjectWithLength)value).getLength()));
                        renderer.renderSpecialSymbol("]");
                    }
                }, value.hasProperties() != ThreeState.NO);
            } else {
                super.computeObjectPresentation(value, variable, context, node, value.getType() == ValueType.FUNCTION ? AllIcons.Nodes.Function : icon);
            }
        }
    }

    private static class FunctionContext {
        private final PsiElement myPosition;
        private static final String FUNCTION_CONTEXT = "function_context";

        private FunctionContext(PsiElement position) {
            this.myPosition = position;
        }

        public PsiElement getPosition() {
            return this.myPosition;
        }
    }

    static class MyEvaluator
    extends JavaScriptDebuggerEvaluator {
        private final ExpressionEvaluator expressionEvaluator;

        public MyEvaluator(@NotNull ExpressionEvaluator expressionEvaluator) {
            if (expressionEvaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionEvaluator", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator", "<init>"));
            }
            super((VariableContext)expressionEvaluator);
            this.expressionEvaluator = expressionEvaluator;
        }

        @NotNull
        protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator", "evaluate"));
            }
            if (expressionPosition == null) {
                Promise promise = Promises.rejectedPromise((String)"No source position specified");
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator", "evaluate"));
                }
                return promise;
            }
            PsiElement elementAt = this.expressionEvaluator.myFile.getPsiFile().findElementAt(expressionPosition.getOffset());
            if (elementAt == null) {
                Promise promise = Promises.rejectedPromise((String)"No source position specified");
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator", "evaluate"));
                }
                return promise;
            }
            Promise<EvaluateResult> promise = this.expressionEvaluator.evaluate(expression, MyEvaluator.createFunctionContext(elementAt), false);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator", "evaluate"));
            }
            return promise;
        }

        private static Map<String, Object> createFunctionContext(@NotNull PsiElement position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator", "createFunctionContext"));
            }
            HashMap map = new HashMap();
            map.put("function_context", new FunctionContext(position));
            return map;
        }
    }
}

