/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.javascript.trace.debugger.ExpressionEvaluator;
import com.intellij.javascript.trace.debugger.SourceFileValueHint;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceFileQuickEvaluateHandler
extends QuickEvaluateHandler {
    public boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/SourceFileQuickEvaluateHandler", "isEnabled"));
        }
        return SourceFileQuickEvaluateHandler.getEvaluator(project) != null;
    }

    @Nullable
    public AbstractValueHint createValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, ValueHintType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/SourceFileQuickEvaluateHandler", "createValueHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/debugger/SourceFileQuickEvaluateHandler", "createValueHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/javascript/trace/debugger/SourceFileQuickEvaluateHandler", "createValueHint"));
        }
        XDebuggerEvaluator evaluator = SourceFileQuickEvaluateHandler.getEvaluator(project);
        if (evaluator == null) {
            return null;
        }
        int offset = AbstractValueHint.calculateOffset((Editor)editor, (Point)point);
        ExpressionInfo expressionInfo = SourceFileQuickEvaluateHandler.getExpressionInfo(evaluator, project, type, editor, offset);
        if (expressionInfo == null) {
            return null;
        }
        int textLength = editor.getDocument().getTextLength();
        TextRange range = expressionInfo.getTextRange();
        if (range.getStartOffset() > range.getEndOffset() || range.getStartOffset() < 0 || range.getEndOffset() > textLength) {
            return null;
        }
        return new SourceFileValueHint(project, editor, point, type, range, evaluator, expressionInfo);
    }

    private static XDebuggerEvaluator getEvaluator(Project project) {
        if (project.isDisposed()) {
            return null;
        }
        Editor activeEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (activeEditor == null) {
            return null;
        }
        PsiFile psiFile = null;
        try {
            psiFile = PsiUtilBase.getPsiFileInEditor((Editor)activeEditor, (Project)project);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (psiFile == null) {
            return null;
        }
        XDebuggerEvaluator evaluator = ExpressionEvaluator.getDebuggerEvaluator(project, psiFile);
        if (evaluator == null) {
            return null;
        }
        return evaluator;
    }

    private static ExpressionInfo getExpressionInfo(XDebuggerEvaluator evaluator, Project project, ValueHintType type, Editor editor, int offset) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionModel.hasSelection() && selectionStart <= offset && offset <= selectionEnd) {
            return new ExpressionInfo(new TextRange(selectionStart, selectionEnd));
        }
        return evaluator.getExpressionInfoAtOffset(project, editor.getDocument(), offset, type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT);
    }

    public boolean canShowHint(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/SourceFileQuickEvaluateHandler", "canShowHint"));
        }
        return this.isEnabled(project);
    }

    public int getValueLookupDelay(Project project) {
        return XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay();
    }
}

