/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.trace.execution.TraceLimits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceBrowserRunConfigurationSettings {
    private final String myConfigPath;
    private final int myProxyPort;
    private boolean myHasConfig;
    private boolean myUseSystemProxy;
    private NodeJsInterpreterRef myNodeInterpreterRef;
    private boolean myNeedToOpenBrowser;
    @Nullable
    private String myBrowserId;
    private final String myUrl;
    private TraceLimits myTraceLimits;

    public TraceBrowserRunConfigurationSettings(int proxyPort, boolean hasConfig, boolean useSystemProxy, @NotNull String configPathOrUrl, @NotNull NodeJsInterpreterRef nodeInterpreterRef, boolean needToOpenBrowser, @Nullable String browserId, @Nullable TraceLimits traceLimits) {
        if (configPathOrUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPathOrUrl", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationSettings", "<init>"));
        }
        if (nodeInterpreterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterRef", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationSettings", "<init>"));
        }
        this.myProxyPort = proxyPort;
        this.myHasConfig = hasConfig;
        this.myUseSystemProxy = useSystemProxy;
        this.myNodeInterpreterRef = nodeInterpreterRef;
        this.myNeedToOpenBrowser = needToOpenBrowser;
        this.myBrowserId = browserId;
        this.myTraceLimits = traceLimits;
        if (hasConfig) {
            this.myConfigPath = configPathOrUrl;
            this.myUrl = "";
        } else {
            this.myUrl = configPathOrUrl;
            this.myConfigPath = "";
        }
    }

    @NotNull
    public String getConfigPath() {
        String string = this.myConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationSettings", "getConfigPath"));
        }
        return string;
    }

    public int getProxyPort() {
        return this.myProxyPort;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationSettings", "getUrl"));
        }
        return string;
    }

    public boolean hasConfig() {
        return this.myHasConfig;
    }

    @NotNull
    public NodeJsInterpreterRef getNodeInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myNodeInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationSettings", "getNodeInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    public boolean isSystemProxyUsed() {
        return this.myUseSystemProxy;
    }

    @Nullable
    public String getBrowserId() {
        return this.myBrowserId;
    }

    public boolean needToOpenBrowser() {
        return this.myNeedToOpenBrowser;
    }

    @Nullable
    public TraceLimits getTraceLimits() {
        return this.myTraceLimits;
    }
}

