/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.trace.execution.TraceLimits;
import com.intellij.javascript.trace.execution.TraceNodeRunConfigurationSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceNodeSettingsSerializationUtil {
    private static final String CONFIG = "config";
    private static final String PROXY_PORT = "proxy-port";
    private static final String NODE = "node";
    private static final String NODE_PARAMS = "node-params";
    private static final String APP_PARAMS = "app-params";
    private static final String APP = "app";
    private static final String WORKING_DIR = "working-dir";
    private static final String PASS_PARENT_ENV = "pass-parent-env";

    private TraceNodeSettingsSerializationUtil() {
    }

    public static TraceNodeRunConfigurationSettings readFromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceNodeSettingsSerializationUtil", "readFromXml"));
        }
        NodeJsInterpreterRef interpreterRef = TraceNodeSettingsSerializationUtil.toNodeInterpreterRef(TraceNodeSettingsSerializationUtil.getAttrValue(element, NODE));
        String configPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, CONFIG)));
        String proxyPortAttrValue = TraceNodeSettingsSerializationUtil.getAttrValue(element, PROXY_PORT);
        int proxyPort = proxyPortAttrValue == null ? 3547 : Integer.parseInt(proxyPortAttrValue);
        HashMap env = ContainerUtil.newHashMap();
        EnvironmentVariablesComponent.readExternal((Element)element, (Map)env);
        String nodeParams = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, NODE_PARAMS)));
        String appParams = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, APP_PARAMS)));
        String appPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, APP)));
        String workingDirPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, WORKING_DIR)));
        boolean passParentEnv = Boolean.parseBoolean(StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, PASS_PARENT_ENV), (String)"false"));
        return new TraceNodeRunConfigurationSettings(proxyPort, configPath, TraceLimits.readExternal(element), interpreterRef, nodeParams, workingDirPath, appPath, appParams, env, passParentEnv);
    }

    @NotNull
    private static NodeJsInterpreterRef toNodeInterpreterRef(@Nullable String value) {
        NodeJsInterpreterRef nodeJsInterpreterRef = StringUtil.isEmpty((String)value) ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create((String)value);
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeSettingsSerializationUtil", "toNodeInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @Nullable
    private static String getAttrValue(Element element, String attrKey) {
        Attribute attribute = element.getAttribute(attrKey);
        return attribute != null ? attribute.getValue() : null;
    }

    public static void writeToXml(@NotNull Element element, @NotNull TraceNodeRunConfigurationSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceNodeSettingsSerializationUtil", "writeToXml"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/trace/execution/TraceNodeSettingsSerializationUtil", "writeToXml"));
        }
        element.setAttribute(CONFIG, FileUtil.toSystemIndependentName((String)settings.getConfigPath()));
        element.setAttribute(NODE, settings.getNodeInterpreterRef().getReferenceName());
        element.setAttribute(NODE_PARAMS, FileUtil.toSystemIndependentName((String)settings.getNodeParams()));
        element.setAttribute(APP, FileUtil.toSystemIndependentName((String)settings.getAppPath()));
        element.setAttribute(APP_PARAMS, FileUtil.toSystemIndependentName((String)settings.getAppParams()));
        element.setAttribute(WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDir()));
        element.setAttribute(PROXY_PORT, String.valueOf(settings.getProxyPort()));
        EnvironmentVariablesComponent.writeExternal((Element)element, settings.getEnv());
        element.setAttribute(PASS_PARENT_ENV, String.valueOf(settings.isPassParentEnv()));
        if (settings.getTraceLimits() != null) {
            settings.getTraceLimits().writeExternal(element);
        }
    }
}

