/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.actions;

import com.intellij.javascript.trace.execution.common.IndexedPsiFile;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class SearchFunctionAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/actions/SearchFunctionAction", "actionPerformed"));
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        Caret caret = (Caret)CommonDataKeys.CARET.getData(e.getDataContext());
        Project project = e.getProject();
        if (project == null || psiFile == null || caret == null) {
            return;
        }
        PsiElement elementAtCaret = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)caret.getOffset());
        IndexedPsiFile indexedPsiFile = IndexedPsiFile.getIndexedPsiFile(project, psiFile, false);
        if (indexedPsiFile == null) {
            return;
        }
        Integer functionId = indexedPsiFile.getFunctionId(elementAtCaret);
        if (functionId == null) {
            return;
        }
        TraceContext traceContext = indexedPsiFile.getContext();
        traceContext.activateToolWindow();
        traceContext.getTraceSearch().searchFunction(indexedPsiFile.getPath(), functionId);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/actions/SearchFunctionAction", "update"));
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        Project project = e.getProject();
        if (file == null || project == null || IndexedPsiFile.getIndexedPsiFile(project, file, false) == null) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }
}

