/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.code;

import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeRange {
    public static final CodeRange ZERO_RANGE = new CodeRange(0, 0, 0, 0);
    private int myRowStart;
    private int myRowEnd;
    private int myColStart;
    private int myColEnd;
    private MappedCodePosition mappedCodePosition;

    public CodeRange(int rowStart, int rowEnd, int colStart, int colEnd) {
        this.myRowStart = rowStart;
        this.myRowEnd = rowEnd;
        this.myColStart = colStart;
        this.myColEnd = colEnd;
    }

    public int getRowStart() {
        return this.myRowStart;
    }

    public int getRowEnd() {
        return this.myRowEnd;
    }

    public int getColStart() {
        return this.myColStart;
    }

    public int getColEnd() {
        return this.myColEnd;
    }

    public TextRange convertToTextRange(Document document) {
        int rowStart = this.getRowStart() - 1;
        int rowEnd = this.getRowEnd() - 1;
        if (rowStart < 0 || rowEnd < 0) {
            return new TextRange(0, 0);
        }
        return new TextRange(document.getLineStartOffset(rowStart) + this.getColStart(), document.getLineStartOffset(rowEnd) + this.getColEnd());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeRange range = (CodeRange)o;
        if (this.myColEnd != range.myColEnd) {
            return false;
        }
        if (this.myColStart != range.myColStart) {
            return false;
        }
        if (this.myRowEnd != range.myRowEnd) {
            return false;
        }
        return this.myRowStart == range.myRowStart;
    }

    public int hashCode() {
        int result = this.myRowStart;
        result = 31 * result + this.myRowEnd;
        result = 31 * result + this.myColStart;
        result = 31 * result + this.myColEnd;
        return result;
    }

    @Nullable
    public MappedCodePosition getMappedCodePosition() {
        return this.mappedCodePosition;
    }

    public void setMappedCodePosition(@NotNull MappedCodePosition mappedCodePosition) {
        if (mappedCodePosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappedCodePosition", "com/intellij/javascript/trace/execution/code/CodeRange", "setMappedCodePosition"));
        }
        this.mappedCodePosition = mappedCodePosition;
    }
}

