/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.code;

import com.intellij.javascript.trace.execution.code.CodeRange;
import org.jetbrains.annotations.NotNull;

public class StaticFunctionParameter {
    private final String myName;
    private final CodeRange myCodeRange;

    public StaticFunctionParameter(@NotNull String name, @NotNull CodeRange codeRange) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/trace/execution/code/StaticFunctionParameter", "<init>"));
        }
        if (codeRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeRange", "com/intellij/javascript/trace/execution/code/StaticFunctionParameter", "<init>"));
        }
        this.myName = name;
        this.myCodeRange = codeRange;
    }

    @NotNull
    public CodeRange getRange() {
        CodeRange codeRange = this.myCodeRange;
        if (codeRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/code/StaticFunctionParameter", "getRange"));
        }
        return codeRange;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/code/StaticFunctionParameter", "getName"));
        }
        return string;
    }
}

