/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.context;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.context.SourceFileValue;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import org.jetbrains.annotations.NotNull;

public class EventValue
extends XNamedValue {
    private StackFrameContext myContext;

    public EventValue(StackFrameContext context) {
        super(TraceBundle.message("console.trace.context.event", new Object[0]));
        this.myContext = context;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/context/EventValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/javascript/trace/execution/context/EventValue", "computePresentation"));
        }
        node.setPresentation(this.myContext.getEventIcon(), (XValuePresentation)new XRegularValuePresentation(this.myContext.getEventName(), null), this.myContext.getStackFrame().isProgram() == false);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/context/EventValue", "computeChildren"));
        }
        if (!this.myContext.getStackFrame().isProgram().booleanValue()) {
            XValueChildrenList children = new XValueChildrenList();
            for (String file : this.myContext.getEventFiles()) {
                children.add((XNamedValue)new SourceFileValue(file));
            }
            node.addChildren(children, true);
        }
    }
}

