/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.events.EventMessageNode;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.NodeWithRemovableChildren;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventRootNode
extends EventTreeNode
implements NodeWithRemovableChildren {
    private List<EventStreamNode> myChildren = new ArrayList<EventStreamNode>();
    private SimpleNode[] NO_EVENTS = new SimpleNode[]{new EventMessageNode(this, TraceBundle.message("console.trace.events.noEventsCaptured", new Object[0]))};
    private Map<String, EventStreamNode> myContextMap = new HashMap();
    private Map<String, ContextMetadata> myContextDetailsMap = new HashMap();
    private HashSet<String> myRemovedNodes = new HashSet();
    private List<Consumer<EventTreeNode>> myCappedHandlers = new ArrayList<Consumer<EventTreeNode>>();

    public EventRootNode() {
        super(null);
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    @Override
    public SimpleNode[] getChildren() {
        if (this.myChildren.isEmpty()) {
            return this.NO_EVENTS;
        }
        return this.myChildren.toArray(new EventStreamNode[this.myChildren.size()]);
    }

    public boolean addOrUpdateEvent(@NotNull EventMetadataExtended eventData, @NotNull TraceProjectSettings.EventFilterState activeFilter) {
        if (eventData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventData", "com/intellij/javascript/trace/execution/events/EventRootNode", "addOrUpdateEvent"));
        }
        if (activeFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeFilter", "com/intellij/javascript/trace/execution/events/EventRootNode", "addOrUpdateEvent"));
        }
        String streamId = eventData.getStreamId();
        if (this.myRemovedNodes.contains((Object)streamId)) {
            return false;
        }
        EventStreamNode streamNode = this.getOrCreateEventStream(streamId);
        return streamNode.addOrUpdateEvent(eventData, activeFilter);
    }

    public EventStreamNode getEventStream(String streamId) {
        return this.myContextMap.get(streamId);
    }

    public void addEventStream(ContextMetadata context) {
        if (this.myRemovedNodes.contains((Object)context.getId())) {
            return;
        }
        this.myContextDetailsMap.put(context.getId(), context);
        this.getOrCreateEventStream(context.getId());
    }

    private EventStreamNode getOrCreateEventStream(String streamId) {
        ContextMetadata details;
        EventStreamNode node = this.myContextMap.get(streamId);
        if (node == null) {
            node = new EventStreamNode(this, streamId);
            this.myContextMap.put(streamId, node);
            this.myChildren.add(0, node);
            for (Consumer<EventTreeNode> handler : this.myCappedHandlers) {
                node.addCappedHandler(handler);
            }
        }
        if ((details = this.myContextDetailsMap.get(streamId)) != null) {
            node.setContextData(details.getDocument(), details.getAgent(), details.getReferrer());
        }
        return node;
    }

    public void addCappedHandler(Consumer<EventTreeNode> onBeforeCapped) {
        this.myCappedHandlers.add(onBeforeCapped);
    }

    @Override
    public void removeChild(EventTreeNode nodeToRemove) {
        if (!(nodeToRemove instanceof EventStreamNode)) {
            return;
        }
        EventStreamNode streamNode = (EventStreamNode)nodeToRemove;
        this.removeStreamNode(streamNode);
    }

    private void removeStreamNode(EventStreamNode streamNode) {
        this.myChildren.remove(streamNode);
        this.myContextMap.remove(streamNode.getStreamId());
        this.myRemovedNodes.add((Object)streamNode.getStreamId());
    }

    public EventStreamNode eventStreamInterrupted(String id) {
        if (this.myRemovedNodes.contains((Object)id)) {
            return null;
        }
        EventStreamNode node = this.getOrCreateEventStream(id);
        node.interrupted();
        return node;
    }

    public void eventStreamExpired(String streamId) {
        EventStreamNode node = this.getEventStream(streamId);
        if (node != null) {
            node.expired();
        }
    }

    public void eventStreamActivated(String streamId) {
        EventStreamNode node = this.getEventStream(streamId);
        if (node != null && node.isExpired()) {
            node.activated();
        }
    }

    public void clearRemovedElementsCache() {
        this.myRemovedNodes.clear();
    }

    @NotNull
    public EventNode[] getAllEventNodesOrderedByOccurenceTimeDesc() {
        ArrayList eventNodes = new ArrayList();
        for (EventStreamNode streamNode : this.myChildren) {
            Collections.addAll(eventNodes, streamNode.getAllEventNodesOrderedByOccurenceTimeDesc());
        }
        EventNode[] eventNodeArray = eventNodes.toArray(new EventNode[eventNodes.size()]);
        if (eventNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/events/EventRootNode", "getAllEventNodesOrderedByOccurenceTimeDesc"));
        }
        return eventNodeArray;
    }

    @Nullable
    public EventNode getEventNodeByEventId(@NotNull String streamId, long eventId) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/events/EventRootNode", "getEventNodeByEventId"));
        }
        EventStreamNode streamNode = this.myContextMap.get(streamId);
        if (streamNode == null) {
            return null;
        }
        return streamNode.getEventNodeByEventId(eventId);
    }
}

