/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.session;

import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticUnknownElement;
import com.intellij.javascript.trace.execution.common.EventMetadata;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.common.MappedSourceFile;
import com.intellij.javascript.trace.execution.common.PropertyMetadata;
import com.intellij.javascript.trace.execution.common.SourceFile;
import com.intellij.javascript.trace.execution.common.StackEntry;
import com.intellij.javascript.trace.execution.common.StackEntryBase;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraph;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyRequest;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.FunctionCombination;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.javascript.trace.execution.search.TraceSearchRequest;
import com.intellij.javascript.trace.execution.search.TraceSearchResult;
import com.intellij.javascript.trace.execution.session.TraceSessionCache;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonSerialization {
    private static final Logger LOG = Logger.getInstance(JsonSerialization.class);

    public static EventMetadataExtended deserializeEventMetadataExtended(JSONObject json, TraceSessionCache cache) throws JSONException {
        if (json == null) {
            return null;
        }
        final JSONObject filesObject = json.getJSONObject("files");
        ArrayList<String> fileList = new ArrayList<String>();
        ArrayList<String> fileIdList = new ArrayList<String>();
        for (Object file : new Iterable(){

            public Iterator iterator() {
                return filesObject.keys();
            }
        }) {
            String fileId = file.toString();
            String fileUrl = filesObject.getString(fileId);
            if (!fileIdList.contains(fileId)) {
                fileIdList.add(fileId);
            }
            if (!fileList.contains(fileUrl)) {
                fileList.add(fileUrl);
            }
            cache.putRemoteUrlFileId(fileId, fileUrl);
        }
        String[] files = new String[fileList.size()];
        fileList.toArray(files);
        String[] fileIds = new String[fileIdList.size()];
        fileIdList.toArray(fileIds);
        return new EventMetadataExtended(json.getString("streamId"), json.getLong("eventId"), json.optString("globalScope"), files, fileIds, JsonSerialization.deserializeStackEntry(json.getJSONObject("firstEntry")), JsonSerialization.deserializeStackEntry(json.getJSONObject("lastEntry")));
    }

    public static StackEntry deserializeStackEntry(@NotNull JSONObject json) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/javascript/trace/execution/session/JsonSerialization", "deserializeStackEntry"));
        }
        return new StackEntry(StaticUnknownElement.INSTANCE, json.optJSONObject("pageEvent"), json.getBoolean("isFromSetTimeout"), json.getBoolean("isFromSetInterval"), json.optBoolean("isFromSetImmediate", false), json.optDouble("time"), json.opt("objDump"));
    }

    public static StackEntryBase deserializeStackBaseEntry(JSONObject json, TraceSessionCache cache) throws JSONException {
        String codeElementId;
        if (json == null) {
            return null;
        }
        StaticCodeElement element = null;
        if (cache != null && (element = cache.getCodeElementById(codeElementId = json.getString("callData"))) == null) {
            throw new JSONException(String.format("Can not find static code element by id: %s", codeElementId));
        }
        return new StackEntryBase(element, json.optDouble("time"), json.opt("objDump"));
    }

    public static StackEntryBase[] deserializeStackBaseEntries(JSONObject json, TraceSessionCache cache) throws JSONException {
        if (json == null) {
            return null;
        }
        ArrayList<StackEntryBase> stackEntries = new ArrayList<StackEntryBase>();
        JSONArray entries = json.getJSONArray("data");
        for (int i = 0; i < entries.length(); ++i) {
            Object entry = entries.opt(i);
            if (entry instanceof JSONObject) {
                stackEntries.add(JsonSerialization.deserializeStackBaseEntry((JSONObject)entry, cache));
                continue;
            }
            stackEntries.add(new StackEntryBase(Integer.parseInt(entry.toString())));
        }
        return stackEntries.toArray(new StackEntryBase[stackEntries.size()]);
    }

    public static SourceFile deserializeSourceFile(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        JSONObject code = json.getJSONObject("code");
        JSONArray mapped = code.optJSONArray("mapped");
        ArrayList<MappedSourceFile> mappedFiles = new ArrayList<MappedSourceFile>();
        if (mapped != null) {
            for (int i = 0; i < mapped.length(); ++i) {
                JSONObject mappedFile = mapped.getJSONObject(i);
                mappedFiles.add(new MappedSourceFile(mappedFile.getString("url"), mappedFile.optString("code")));
            }
        }
        SourceFile sourceFile = new SourceFile(json.getString("file"), code.getString("executed"));
        if (!mappedFiles.isEmpty()) {
            sourceFile.setMappedSourceFiles(mappedFiles.toArray(new MappedSourceFile[mappedFiles.size()]));
        }
        return sourceFile;
    }

    public static JSONObject serializeEventMetadata(EventMetadata obj) {
        try {
            return new JSONObject().put("eventId", obj.getEventId()).put("streamId", (Object)obj.getStreamId());
        }
        catch (JSONException e) {
            LOG.warn((Throwable)e);
            return new JSONObject();
        }
    }

    public static JSONObject serializeConfig(TraceSettings config) {
        try {
            TraceProjectSettings.EventFilterState filter = config.getFilter();
            return new JSONObject().put("realtimeEval", config.isRealtimeEvaluationEnabled()).put("sourceMapLookup", config.isSourceMapLookupEnabled()).put("sourceMapGeneration", config.isSourceMapGenerationEnabled()).put("filter", (Object)new JSONObject().put("events", (Object)new JSONArray(filter.getEventNameRegularExpressions())).put("files", (Object)new JSONArray(filter.getFileNameRegularExpressions())));
        }
        catch (JSONException e) {
            LOG.warn((Throwable)e);
            return new JSONObject();
        }
    }

    public static JSONObject serializeEventStreamCommand(EventStreamCommand command) {
        try {
            return new JSONObject().put("command", (Object)command.getCommand()).put("streamId", (Object)command.getStreamId());
        }
        catch (JSONException e) {
            LOG.warn((Throwable)e);
            return new JSONObject();
        }
    }

    public static PropertyMetadata deserializePropertyMetadata(JSONObject json) {
        JSONArray ranges;
        if (json == null) {
            return null;
        }
        JSONArray context = json.optJSONArray("context");
        ArrayList<String> contextIds = new ArrayList<String>();
        if (context != null) {
            for (int i = 0; i < context.length(); ++i) {
                contextIds.add(context.opt(i).toString());
            }
        }
        int[] rangeBorders = new int[(ranges = json.optJSONArray("ranges")) != null ? ranges.length() : 0];
        if (ranges != null) {
            for (int i = 0; i < ranges.length(); ++i) {
                rangeBorders[i] = ranges.optInt(i);
            }
        }
        return new PropertyMetadata(json.optString("name"), json.optString("type"), json.optString("params", null), json.optString("value", null), json.optInt("length", 0), json.optBoolean("empty", true), rangeBorders, ArrayUtil.toStringArray(contextIds));
    }

    public static ExpressionEvaluationResult deserializeExpressionEvaluationResult(JSONObject json) {
        JSONObject value = json.optJSONObject("value");
        JSONArray props = json.optJSONArray("properties");
        ArrayList<PropertyMetadata> list = new ArrayList<PropertyMetadata>();
        if (props != null) {
            for (int i = 0; i < props.length(); ++i) {
                list.add(JsonSerialization.deserializePropertyMetadata(props.optJSONObject(i)));
            }
        }
        return new ExpressionEvaluationResult(JsonSerialization.deserializePropertyMetadata(value), list.toArray(new PropertyMetadata[list.size()]), json.optBoolean("fileNotFound", false), json.optBoolean("functionNotFound", false));
    }

    public static JSONObject serializeExpressionEvaluationRequest(ExpressionEvaluationRequest request) {
        Range<Integer> propRange = request.getPropertyRange();
        Integer threshold = request.getThreshold();
        JSONObject json = new JSONObject();
        try {
            json.put("file", (Object)request.getFile());
            json.put("functionId", request.getFunctionId());
            json.put("expression", (Object)request.getExpression());
            json.put("functionsInFile", request.getTotalNumberOfFunctions());
            json.put("timeout", request.getTimeout());
            if (request.needToIncludeProperties()) {
                json.put("includeProps", true);
            }
            if (request.isForAutocomplete()) {
                json.put("autocomplete", true);
            }
            if (request.includeOnlyValidIdentifierNames()) {
                json.put("onlyValidPropNames", true);
            }
            if (request.needToGetFullString()) {
                json.put("fullString", true);
            }
            if (propRange != null) {
                json.put("from", (Object)propRange.getFrom());
                json.put("to", (Object)propRange.getTo());
            }
            if (threshold != null) {
                json.put("threshold", (Object)threshold);
            }
        }
        catch (JSONException ignored) {
            LOG.warn((Throwable)ignored);
        }
        return json;
    }

    public static JSONObject serializeFunctionSearchRequest(@NotNull TraceSearchRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/JsonSerialization", "serializeFunctionSearchRequest"));
        }
        JSONObject json = new JSONObject();
        try {
            json.put("file", (Object)request.getFile());
            json.put("function", request.getFunctionId());
        }
        catch (JSONException ignored) {
            LOG.warn((Throwable)ignored);
        }
        return json;
    }

    @Nullable
    public static TraceSearchResult deserializeFunctionSearchResult(final JSONObject json) {
        if (json == null) {
            return null;
        }
        HashMap<String, HashSet<Long>> result = new HashMap<String, HashSet<Long>>();
        int total = 0;
        try {
            for (Object stream : new Iterable(){

                public Iterator iterator() {
                    return json.keys();
                }
            }) {
                String streamId = stream.toString();
                final JSONObject streamData = json.getJSONObject(streamId);
                HashSet<Long> events = new HashSet<Long>();
                result.put(streamId, events);
                for (Object event : new Iterable(){

                    public Iterator iterator() {
                        return streamData.keys();
                    }
                }) {
                    String eventId = event.toString();
                    events.add(Long.parseLong(eventId));
                    total += streamData.getInt(eventId);
                }
            }
        }
        catch (JSONException ignored) {
            LOG.warn((Throwable)ignored);
            return null;
        }
        return new TraceSearchResult(result, total);
    }

    public static JSONObject serializeFileDependencyRequest(@NotNull FileDependencyRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/JsonSerialization", "serializeFileDependencyRequest"));
        }
        JSONObject json = new JSONObject();
        try {
            json.put("streamId", (Object)request.getStreamId());
        }
        catch (JSONException ignored) {
            LOG.warn((Throwable)ignored);
        }
        return json;
    }

    @Nullable
    public static FileDependencyGraph deserializeFileDependencyGraph(final @Nullable JSONObject json, @NotNull TraceSessionCache cache, @NotNull String streamId) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/javascript/trace/execution/session/JsonSerialization", "deserializeFileDependencyGraph"));
        }
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/session/JsonSerialization", "deserializeFileDependencyGraph"));
        }
        if (json == null) {
            return null;
        }
        FileDependencyGraph fileDependencyGraph = new FileDependencyGraph(streamId);
        try {
            for (Object fromFile : new Iterable(){

                public Iterator iterator() {
                    return json.keys();
                }
            }) {
                String fromFileId = fromFile.toString();
                String fromFileUrl = cache.getRemoteUrlByFileId(fromFileId);
                if (StringUtil.isEmpty((String)fromFileUrl)) continue;
                FileNode fromNode = fileDependencyGraph.getNode(fromFileId);
                if (fromNode == null) {
                    fromNode = new FileNode(fromFileId, fromFileUrl);
                }
                final JSONObject toFiles = json.getJSONObject(fromFileId);
                for (Object toFile : new Iterable(){

                    public Iterator iterator() {
                        return toFiles.keys();
                    }
                }) {
                    RuntimeDependencyEdge edge;
                    String toFileId = toFile.toString();
                    String toFileUrl = cache.getRemoteUrlByFileId(toFileId);
                    FileNode toNode = fileDependencyGraph.getNode(toFileId);
                    if (toNode == null) {
                        toNode = new FileNode(toFileId, toFileUrl);
                    }
                    if ((edge = fileDependencyGraph.createEdge(fromNode, toNode)) == null) continue;
                    final JSONObject functions = toFiles.getJSONObject(toFileId);
                    for (Object keyPair : new Iterable(){

                        public Iterator iterator() {
                            return functions.keys();
                        }
                    }) {
                        String functionKey = keyPair.toString();
                        String[] functionKeys = functionKey.split(":");
                        String codeElementFromId = functionKeys[0];
                        String codeElementToId = functionKeys[1];
                        FunctionCombination functionCombination = new FunctionCombination(fromNode, codeElementFromId, toNode, codeElementToId);
                        edge.addFunctionCombination(functionCombination);
                        final JSONObject events = functions.getJSONObject(functionKey);
                        for (Object eventKey : new Iterable(){

                            public Iterator iterator() {
                                return events.keys();
                            }
                        }) {
                            String eventKeyString = eventKey.toString();
                            long eventId = Long.valueOf(eventKeyString);
                            long hitCount = events.getLong(eventKeyString);
                            functionCombination.addEvent(eventId, hitCount);
                            fromNode.usedInEvent(eventId);
                            toNode.usedInEvent(eventId);
                        }
                    }
                }
            }
        }
        catch (JSONException ignored) {
            LOG.warn((Throwable)ignored);
            return null;
        }
        return fileDependencyGraph;
    }
}

