/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.cloudbees.CBBundle;
import com.intellij.javaee.cloudbees.CBDeploymentModel;
import com.intellij.javaee.cloudbees.CBDeploymentProvider;
import com.intellij.javaee.cloudbees.CBServerHelper;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.cloud.server.CloudIntegration;
import com.intellij.javaee.oss.cloud.server.CloudUrlMappingBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CBIntegration
extends CloudIntegration {
    private CBServerHelper myServerHelper;

    public static CBIntegration getInstance() {
        return (CBIntegration)AppServerIntegrationsManager.getInstance().getIntegration(CBIntegration.class);
    }

    @NotNull
    public String getName() {
        String string = CBBundle.getText("CBIntegration.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/CBIntegration", "getName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.General.Balloon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/CBIntegration", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = AllIcons.General.Balloon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/CBIntegration", "getBigIcon"));
        }
        return icon;
    }

    protected ApplicationServerUrlMapping createDeployedFileUrlProvider() {
        return new CloudUrlMappingBase(this){

            protected String doCreateUrl(@NotNull CommonModel serverConfig, @Nullable String context) {
                if (serverConfig == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/intellij/javaee/cloudbees/CBIntegration$1", "doCreateUrl"));
                }
                return 1.createUrl((CommonModel)serverConfig, null, null);
            }
        };
    }

    public String createDeploymentName(DeploymentModel deployment) {
        return super.createDeploymentName(deployment).replace('_', '-');
    }

    public boolean isDebugAllowed(boolean isLocal) {
        return isLocal;
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new CBDeploymentModel(commonModel, source);
    }

    @Nullable
    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return null;
    }

    @NotNull
    public ApplicationServerHelper getApplicationServerHelper() {
        if (this.myServerHelper == null) {
            this.myServerHelper = new CBServerHelper();
        }
        CBServerHelper cBServerHelper = this.myServerHelper;
        if (cBServerHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/CBIntegration", "getApplicationServerHelper"));
        }
        return cBServerHelper;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new CBDeploymentProvider();
    }
}

