/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringInitializrDownloader {
    private static final Escaper URI_PARAM_ESCAPER = UrlEscapers.urlFormParameterEscaper();
    private final SpringInitializrModuleBuilder myBuilder;
    private static final String FILENAME = "filename=";

    public SpringInitializrDownloader(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
    }

    static String userAgent() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
    }

    void execute(final ProgressIndicator indicator) throws IOException {
        final File tempFile = FileUtil.createTempFile((String)"spring-initializr", (String)".tmp", (boolean)true);
        DownloadResult result = (DownloadResult)HttpRequests.request((String)this.buildUrl()).userAgent(SpringInitializrDownloader.userAgent()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<DownloadResult>(){

            public DownloadResult process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/spring/initializr/SpringInitializrDownloader$1", "process"));
                }
                String contentType = request.getConnection().getContentType();
                boolean isZip = StringUtil.isNotEmpty((String)contentType) && contentType.startsWith("application/zip");
                String contentDisposition = request.getConnection().getHeaderField("Content-Disposition");
                String filename = SpringInitializrDownloader.getFilename(contentDisposition);
                indicator.setText(filename);
                request.saveToFile(tempFile, indicator);
                return new DownloadResult(isZip, filename);
            }
        });
        indicator.setText("Preparing Template...");
        String path = this.myBuilder.getContentEntryPath();
        assert (path != null);
        File contentEntryDir = new File(path);
        if (result.myUnzip) {
            ZipUtil.extract((File)tempFile, (File)contentEntryDir, null);
            SpringInitializrDownloader.fixExecutableFlag(contentEntryDir, "gradlew");
            SpringInitializrDownloader.fixExecutableFlag(contentEntryDir, "mvnw");
        } else {
            File targetFile = new File(contentEntryDir, result.myFilename);
            FileUtil.copy((File)tempFile, (File)targetFile);
        }
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentEntryDir);
        RefreshQueue.getInstance().refresh(false, true, null, new VirtualFile[]{vf});
    }

    private static void fixExecutableFlag(File containingDir, String relativePath) {
        File toFix = new File(containingDir, relativePath);
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }

    @NotNull
    private static String getFilename(@Nullable String contentDisposition) {
        if (StringUtil.isEmpty((String)contentDisposition)) {
            if ("unknown" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/SpringInitializrDownloader", "getFilename"));
            }
            return "unknown";
        }
        int startIdx = contentDisposition.indexOf(FILENAME);
        int endIdx = contentDisposition.indexOf(59, startIdx);
        String fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
        if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
            fileName = fileName.substring(1, fileName.length() - 1);
        }
        String string = fileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/SpringInitializrDownloader", "getFilename"));
        }
        return string;
    }

    private String buildUrl() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        Object selected = options.type.getSelected();
        assert (selected != null);
        String action = options.typeToAction.get(((SpringInitializrOptions.Option)((Object)selected)).id);
        return this.myBuilder.getServiceUrl() + action + "?" + SpringInitializrDownloader.getDependenciesParameter(options) + SpringInitializrDownloader.getParameter("type", options.type) + SpringInitializrDownloader.getParameter("packaging", options.packaging) + SpringInitializrDownloader.getParameter("javaVersion", options.javaVersion) + SpringInitializrDownloader.getParameter("language", options.language) + SpringInitializrDownloader.getParameter("bootVersion", options.bootVersion) + "&groupId=" + SpringInitializrDownloader.getEscapedString(options.group) + "&artifactId=" + SpringInitializrDownloader.getEscapedString(options.artifact) + "&name=" + SpringInitializrDownloader.getEscapedString(options.name) + "&description=" + SpringInitializrDownloader.getEscapedString(options.description) + "&packageName=" + SpringInitializrDownloader.getEscapedString(options.packageName);
    }

    private static String getDependenciesParameter(SpringInitializrOptions options) {
        String dependencies = "";
        for (String id : options.selectedDependenciesIds) {
            dependencies = dependencies + "&dependencies=" + id;
        }
        return dependencies;
    }

    private static String getEscapedString(String string) {
        return URI_PARAM_ESCAPER.escape(string);
    }

    private static String getParameter(String parameterName, CollectionComboBoxModel model) {
        SpringInitializrOptions.Option item = (SpringInitializrOptions.Option)((Object)model.getSelectedItem());
        assert (item != null) : parameterName;
        String value = item.id;
        return "&" + parameterName + "=" + SpringInitializrDownloader.getEscapedString(value);
    }

    private static class DownloadResult {
        private final boolean myUnzip;
        private final String myFilename;

        DownloadResult(boolean unzip, String filename) {
            this.myUnzip = unzip;
            this.myFilename = filename;
        }
    }
}

