/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

class SpringInitializrFormBuilder
extends FormBuilder {
    private static final ColoredListCellRenderer<SpringInitializrOptions.Option> COMBO_RENDERER = new ColoredListCellRenderer<SpringInitializrOptions.Option>(){

        protected void customizeCellRenderer(@NotNull JList list, SpringInitializrOptions.Option option, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/initializr/SpringInitializrFormBuilder$1", "customizeCellRenderer"));
            }
            this.append(option.display);
            String description = option.description;
            if (StringUtil.isNotEmpty((String)description)) {
                this.append(" (" + description + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    };

    SpringInitializrFormBuilder() {
        this.setFormLeftIndent(10);
    }

    ComboBox addComboBox(String label, CollectionComboBoxModel<SpringInitializrOptions.Option> model) {
        ComboBox comboBox = new ComboBox(model);
        comboBox.setRenderer(COMBO_RENDERER);
        this.addLabeledComponent(label + ":", (JComponent)comboBox);
        return comboBox;
    }

    JBTextField addTextField(String label, String value) {
        JBTextField field = new JBTextField(value);
        field.setColumns(50);
        this.addLabeledComponent(label + ":", (JComponent)field);
        return field;
    }

    void addVerticalSpacing() {
        this.addVerticalGap(4);
    }
}

