/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.descriptor.JavaeeFileDescription;
import com.intellij.javaee.oss.geronimo.server.GeronimoIntegration;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomService;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class GeronimoFileDescription<T extends JavaeeDomModelElement>
extends JavaeeFileDescription<T> {
    protected GeronimoFileDescription(Class<T> type, @NonNls String root) {
        super(type, root, GeronimoIntegration.getInstance());
    }

    @NotNull
    public List<String> getAllowedNamespaces(@NotNull String namespaceKey, @NotNull XmlFile file) {
        String namespace;
        if (namespaceKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceKey", "com/intellij/javaee/oss/geronimo/server/GeronimoFileDescription", "getAllowedNamespaces"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/geronimo/server/GeronimoFileDescription", "getAllowedNamespaces"));
        }
        if ("sys".equals(namespaceKey) && (namespace = DomService.getInstance().getXmlFileHeader(file).getRootTagNamespace()).startsWith("http://geronimo.apache.org/xml/ns/deployment")) {
            List<String> list = Collections.singletonList(namespace);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/server/GeronimoFileDescription", "getAllowedNamespaces"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/server/GeronimoFileDescription", "getAllowedNamespaces"));
        }
        return list;
    }
}

