/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdCamera;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdNameVerifier;
import com.android.tools.idea.avdmanager.AvdNetworkLatency;
import com.android.tools.idea.avdmanager.AvdNetworkSpeed;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.ChooseDeviceDefinitionStep;
import com.android.tools.idea.avdmanager.ChooseSystemImageStep;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.ddms.screenshot.DeviceArtDescriptor;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdWizardUtils {
    public static final String WIZARD_ONLY = "AvdManager.WizardOnly.";
    public static final String DEVICE_DEFINITION_KEY = "AvdManager.WizardOnly.DeviceDefinition";
    public static final String SYSTEM_IMAGE_KEY = "AvdManager.WizardOnly.SystemImage";
    public static final String RAM_STORAGE_KEY = "hw.ramSize";
    public static final String VM_HEAP_STORAGE_KEY = "vm.heapSize";
    public static final String INTERNAL_STORAGE_KEY = "disk.dataPartition.size";
    public static final String SD_CARD_STORAGE_KEY = "sdcard.size";
    public static final String EXISTING_SD_LOCATION = "sdcard.path";
    public static final String DISPLAY_SD_SIZE_KEY = "AvdManager.WizardOnly.displaySdCardSize";
    public static final String DISPLAY_SD_LOCATION_KEY = "AvdManager.WizardOnly.displaySdLocation";
    public static final String DISPLAY_USE_EXTERNAL_SD_KEY = "AvdManager.WizardOnly.displayUseExistingSd";
    public static final String DEFAULT_ORIENTATION_KEY = "AvdManager.WizardOnly.DefaultOrientation";
    public static final String AVD_INI_NETWORK_SPEED = "runtime.network.speed";
    public static final String NETWORK_SPEED_KEY = "runtime.network.speed";
    public static final String AVD_INI_NETWORK_LATENCY = "runtime.network.latency";
    public static final String NETWORK_LATENCY_KEY = "runtime.network.latency";
    public static final String FRONT_CAMERA_KEY = "hw.camera.front";
    public static final String BACK_CAMERA_KEY = "hw.camera.back";
    public static final String USE_HOST_GPU_KEY = "hw.gpu.enabled";
    public static final String HOST_GPU_MODE_KEY = "hw.gpu.mode";
    public static final String IS_IN_EDIT_MODE_KEY = "AvdManager.WizardOnly.isInEditMode";
    public static final String CUSTOM_SKIN_FILE_KEY = "skin.path";
    public static final String BACKUP_SKIN_FILE_KEY = "skin.path.backup";
    public static final String DEVICE_FRAME_KEY = "showDeviceFrame";
    public static final String DISPLAY_NAME_KEY = "avd.ini.displayname";
    public static final String AVD_INI_AVD_ID = "AvdId";
    public static final String AVD_ID_KEY = "AvdId";
    public static final String CPU_CORES_KEY = "hw.cpu.ncore";
    public static final String HAS_HARDWARE_KEYBOARD_KEY = "hw.keyboard";
    public static final AvdNetworkSpeed DEFAULT_NETWORK_SPEED = AvdNetworkSpeed.FULL;
    public static final AvdNetworkLatency DEFAULT_NETWORK_LATENCY = AvdNetworkLatency.NONE;
    public static final AvdCamera DEFAULT_CAMERA = AvdCamera.EMULATED;
    public static final Storage DEFAULT_INTERNAL_STORAGE = new Storage(800L, Storage.Unit.MiB);
    public static final Font STANDARD_FONT = JBFont.create((Font)new Font("Sans", 0, 12));
    public static final Font FIGURE_FONT = JBFont.create((Font)new Font("Sans", 0, 10));
    public static final Font TITLE_FONT = JBFont.create((Font)new Font("Sans", 1, 16));
    public static final List<IdDisplay> ALL_DEVICE_TAGS = ImmutableList.of((Object)SystemImage.DEFAULT_TAG, (Object)SystemImage.WEAR_TAG, (Object)SystemImage.TV_TAG);
    public static final List<IdDisplay> TAGS_WITH_GOOGLE_API = ImmutableList.of((Object)SystemImage.GOOGLE_APIS_TAG, (Object)SystemImage.GOOGLE_APIS_X86_TAG, (Object)SystemImage.WEAR_TAG, (Object)SystemImage.TV_TAG);
    public static final String CREATE_SKIN_HELP_LINK = "http://developer.android.com/tools/devices/managing-avds.html#skins";
    public static final File NO_SKIN = new File("_no_skin");
    private static final Dimension AVD_WIZARD_SIZE = new Dimension(1000, 650);
    private static final String AVD_WIZARD_HELP_URL = "https://developer.android.com/r/studio-ui/avd-manager.html";
    private static final int MAX_RAM_MB = 1536;

    private static Logger getLog() {
        return Logger.getInstance(AvdWizardUtils.class);
    }

    @NotNull
    public static Storage getDefaultRam(@NotNull Hardware hardware) {
        if (hardware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardware", "com/android/tools/idea/avdmanager/AvdWizardUtils", "getDefaultRam"));
        }
        Storage storage = AvdWizardUtils.getMaxPossibleRam(hardware.getRam());
        if (storage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdWizardUtils", "getDefaultRam"));
        }
        return storage;
    }

    @NotNull
    public static Storage getMaxPossibleRam() {
        Storage storage = new Storage(1536L, Storage.Unit.MiB);
        if (storage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdWizardUtils", "getMaxPossibleRam"));
        }
        return storage;
    }

    @NotNull
    private static Storage getMaxPossibleRam(Storage ram) {
        if (ram.getSizeAsUnit(Storage.Unit.MiB) >= 1536L) {
            Storage storage = new Storage(1536L, Storage.Unit.MiB);
            if (storage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdWizardUtils", "getMaxPossibleRam"));
            }
            return storage;
        }
        Storage storage = ram;
        if (storage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdWizardUtils", "getMaxPossibleRam"));
        }
        return storage;
    }

    public static int getMaxCpuCores() {
        return Runtime.getRuntime().availableProcessors() / 2;
    }

    public static String cleanAvdName(@NotNull AvdManagerConnection connection, @NotNull String candidateBase, boolean uniquify) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/idea/avdmanager/AvdWizardUtils", "cleanAvdName"));
        }
        if (candidateBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBase", "com/android/tools/idea/avdmanager/AvdWizardUtils", "cleanAvdName"));
        }
        if ((candidateBase = AvdNameVerifier.stripBadCharactersAndCollapse(candidateBase)).isEmpty()) {
            candidateBase = "myavd";
        }
        String candidate = candidateBase;
        if (uniquify) {
            int i = 1;
            while (connection.avdExists(candidate)) {
                candidate = String.format("%1$s_%2$d", candidateBase, i++);
            }
        }
        return candidate;
    }

    @Nullable
    public static File resolveSkinPath(@Nullable File path, @Nullable SystemImageDescription image, @NotNull FileOp fop) {
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/avdmanager/AvdWizardUtils", "resolveSkinPath"));
        }
        if (path == null || path.getPath().isEmpty()) {
            return path;
        }
        if (FileUtil.filesEqual((File)path, (File)NO_SKIN)) {
            return NO_SKIN;
        }
        if (!path.isAbsolute()) {
            File resourcePath;
            File sdkDir;
            File sdkSkinDir;
            if (image != null) {
                File[] skins;
                for (File skin : skins = image.getSkins()) {
                    if (!skin.getPath().endsWith(File.separator + path.getPath())) continue;
                    return skin;
                }
            }
            AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            File dest = null;
            if (sdkData != null && fop.exists(dest = new File(sdkSkinDir = new File(sdkDir = sdkData.getLocation(), "skins"), path.getPath()))) {
                return dest;
            }
            File resourceDir = DeviceArtDescriptor.getBundledDescriptorsFolder();
            if (resourceDir != null && fop.exists(resourcePath = new File(resourceDir, path.getPath()))) {
                if (dest != null) {
                    try {
                        FileOpUtils.recursiveCopy((File)resourcePath, (File)dest, (FileOp)fop, (ProgressIndicator)new StudioLoggerProgressIndicator(AvdWizardUtils.class));
                        return dest;
                    }
                    catch (IOException e) {
                        AvdWizardUtils.getLog().warn(String.format("Failed to copy skin directory to %1$s, using studio-relative path %2$s", dest, resourcePath));
                    }
                }
                return resourcePath;
            }
        }
        return path;
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent, @Nullable Project project) {
        return AvdWizardUtils.createAvdWizard(parent, project, new AvdOptionsModel(null));
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent, @Nullable Project project, @Nullable AvdInfo avdInfo) {
        return AvdWizardUtils.createAvdWizard(parent, project, new AvdOptionsModel(avdInfo));
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent, @Nullable Project project, @NotNull AvdOptionsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/avdmanager/AvdWizardUtils", "createAvdWizard"));
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        if (!((Boolean)model.isInEditMode().get()).booleanValue()) {
            wizardBuilder.addStep(new ChooseDeviceDefinitionStep(model));
            wizardBuilder.addStep(new ChooseSystemImageStep(model, project));
        }
        wizardBuilder.addStep(new ConfigureAvdOptionsStep(project, model));
        ModelWizard wizard = wizardBuilder.build();
        StudioWizardDialogBuilder builder = new StudioWizardDialogBuilder(wizard, "Virtual Device Configuration", parent);
        builder.setMinimumSize(AVD_WIZARD_SIZE);
        return builder.setHelpUrl(WizardUtils.toUrl(AVD_WIZARD_HELP_URL)).build();
    }
}

