/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileOpUtils;
import com.android.resources.Keyboard;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdCamera;
import com.android.tools.idea.avdmanager.AvdConfigurationOptionHelpPanel;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdNameVerifier;
import com.android.tools.idea.avdmanager.AvdNetworkLatency;
import com.android.tools.idea.avdmanager.AvdNetworkSpeed;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.ChooseDeviceDefinitionPanel;
import com.android.tools.idea.avdmanager.ChooseSystemImagePanel;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.adapters.OptionalToValuePropertyAdapter;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.string.StringExpression;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAvdOptionsStep
extends ModelWizardStep<AvdOptionsModel> {
    private static final String ADVANCED_SETTINGS = "Advanced Settings";
    private static final String SHOW = "Show Advanced Settings";
    private static final String HIDE = "Hide Advanced Settings";
    private static final String FOCUS_OWNER = "focusOwner";
    private static final Map<ScreenOrientation, NamedIcon> ORIENTATIONS = ImmutableMap.of((Object)ScreenOrientation.PORTRAIT, (Object)new NamedIcon("Portrait", AndroidIcons.Portrait), (Object)ScreenOrientation.LANDSCAPE, (Object)new NamedIcon("Landscape", AndroidIcons.Landscape));
    final AvdManagerConnection connection;
    private JPanel myRoot;
    private ValidatorPanel myValidatorPanel;
    private StudioWizardStepPanel myStudioWizardStepPanel;
    private AvdConfigurationOptionHelpPanel myAvdConfigurationOptionHelpPanel;
    private JBScrollPane myScrollPane;
    private JBLabel myAvdId;
    private JBLabel myRamLabel;
    private JLabel myAvdIdLabel;
    private JBLabel mySpeedLabel;
    private JBLabel myDeviceName;
    private JBLabel myVmHeapLabel;
    private JBLabel mySdCardLabel;
    private JBLabel myCameraLabel;
    private JBLabel myNetworkLabel;
    private JBLabel myLatencyLabel;
    private JBLabel myKeyboardLabel;
    private JBLabel myDeviceDetails;
    private JBLabel myBackCameraLabel;
    private JBLabel mySystemImageName;
    private JBLabel myFrontCameraLabel;
    private JBLabel mySystemImageDetails;
    private JBLabel mySkinDefinitionLabel;
    private JBLabel myInternalStorageLabel;
    private JBLabel myMemoryAndStorageLabel;
    private JLabel myMultiCoreExperimentalLabel;
    private HyperlinkLabel myHardwareSkinHelpLabel;
    private JComboBox myCoreCount;
    private JComboBox mySpeedCombo;
    private JComboBox myLatencyCombo;
    private SkinChooser mySkinComboBox;
    private JComboBox myBackCameraCombo;
    private JComboBox myFrontCameraCombo;
    private JCheckBox myQemu2CheckBox;
    private JCheckBox myDeviceFrameCheckbox;
    private JCheckBox myEnableComputerKeyboard;
    private StorageField myRamStorage;
    private StorageField myVmHeapStorage;
    private StorageField myInternalStorage;
    private StorageField myBuiltInSdCardStorage;
    private JRadioButton myBuiltInRadioButton;
    private JRadioButton myExternalRadioButton;
    private ASGallery<ScreenOrientation> myOrientationToggle;
    private JButton myChangeDeviceButton;
    private JButton myChangeSystemImageButton;
    private JButton myShowAdvancedSettingsButton;
    private TextFieldWithBrowseButton myExternalSdCard;
    private JTextField myAvdDisplayName;
    private JBLabel myOrientationLabel;
    private JBLabel myHostGraphicProblem;
    private JComboBox myHostGraphics;
    private JPanel myDevicePanel;
    private JPanel myAvdNamePanel;
    private JPanel myImagePanel;
    private JPanel myOrientationPanel;
    private JPanel myCameraPanel;
    private JPanel myNetworkPanel;
    private JPanel myPerformancePanel;
    private JPanel myStoragePanel;
    private JPanel myFramePanel;
    private JPanel myKeyboardPanel;
    private JPanel myQemu2Panel;
    private JPanel myAvdIdRow;
    private JPanel myCustomSkinPanel;
    private JPanel myScrollRootPane;
    private Iterable<JComponent> myAdvancedOptionsComponents;
    private Project myProject;
    private BindingsManager myBindings;
    private ListenerManager myListeners;
    private String myOriginalName;
    private boolean myCheckSdForChanges;
    private Storage myOriginalSdCard;
    private int mySelectedCoreCount;
    private final ActionListener myToggleAdvancedSettingsListener;
    private ActionListener myChangeSystemImageButtonListener;
    private ActionListener myChangeDeviceButtonListener;
    private PropertyChangeListener myPropertyChangeListener;

    public ConfigureAvdOptionsStep(@Nullable Project project, @NotNull AvdOptionsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "<init>"));
        }
        super(model, "Android Virtual Device (AVD)");
        this.$$$setupUI$$$();
        this.connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myToggleAdvancedSettingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureAvdOptionsStep.this.isAdvancedPanel()) {
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.SHOW);
                    ConfigureAvdOptionsStep.this.setAdvanceSettingsVisible(false);
                } else {
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.HIDE);
                    ConfigureAvdOptionsStep.this.setAdvanceSettingsVisible(true);
                }
            }
        };
        this.myChangeSystemImageButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageDescription image;
                final ChooseSystemImagePanel chooseImagePanel = new ChooseSystemImagePanel(ConfigureAvdOptionsStep.this.myProject, ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().getValueOrNull(), ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().getValueOrNull());
                DialogWrapper dialog = new DialogWrapper(ConfigureAvdOptionsStep.this.myProject){
                    {
                        super(arg0);
                        this.setTitle("Select a System Image");
                        this.init();
                        chooseImagePanel.addSystemImageListener(new Consumer<SystemImageDescription>(){

                            public void consume(SystemImageDescription systemImage) {
                                this.setOKActionEnabled(systemImage != null);
                            }
                        });
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        return chooseImagePanel;
                    }
                };
                if (dialog.showAndGet() && (image = chooseImagePanel.getSystemImage()) != null) {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().setValue(image);
                }
            }
        };
        this.myChangeDeviceButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ChooseDeviceDefinitionPanel chooseDevicePanel = new ChooseDeviceDefinitionPanel(((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().getValueOrNull());
                DialogWrapper dialog = new DialogWrapper(ConfigureAvdOptionsStep.this.myProject){
                    {
                        super(arg0);
                        this.setTitle("Select a Device");
                        this.init();
                        chooseDevicePanel.addDeviceListener(new Consumer<Device>(){

                            public void consume(Device device) {
                                this.setOKActionEnabled(device != null);
                            }
                        });
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        return chooseDevicePanel;
                    }
                };
                if (dialog.showAndGet()) {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().setNullableValue(chooseDevicePanel.getDevice());
                }
            }
        };
        this.myPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (evt.getNewValue() instanceof JComponent) {
                    JComponent parent;
                    JComponent component = (JComponent)value;
                    if (component.getToolTipText() != null) {
                        ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.setValues(component);
                    } else if (component.getParent() instanceof JComponent) {
                        parent = (JComponent)component.getParent();
                        if (parent.getToolTipText() != null) {
                            ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.setValues(parent);
                        } else {
                            ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.clearValues();
                        }
                    }
                    if (component.getParent() instanceof JComponent) {
                        parent = (JComponent)component.getParent();
                        parent.scrollRectToVisible(component.getBounds());
                    }
                }
            }
        };
        this.myValidatorPanel = new ValidatorPanel(this, this.myRoot);
        this.myStudioWizardStepPanel = new StudioWizardStepPanel(this.myValidatorPanel, "Verify Configuration");
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myStudioWizardStepPanel);
        this.myOrientationToggle.setOpaque(false);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myProject = project;
        this.registerAdvancedOptionsVisibility();
        this.myShowAdvancedSettingsButton.setText(SHOW);
        this.setAdvanceSettingsVisible(false);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.initCpuCoreDropDown();
        this.myFrontCameraCombo.setModel(new DefaultComboBoxModel<AvdCamera>(AvdCamera.values()));
        this.myBackCameraCombo.setModel(new DefaultComboBoxModel<AvdCamera>(AvdCamera.values()));
        this.mySpeedCombo.setModel(new DefaultComboBoxModel<AvdNetworkSpeed>(AvdNetworkSpeed.values()));
        this.myLatencyCombo.setModel(new DefaultComboBoxModel<AvdNetworkLatency>(AvdNetworkLatency.values()));
    }

    private void initCpuCoreDropDown() {
        for (int core = 1; core <= AvdOptionsModel.MAX_NUMBER_OF_CORES; ++core) {
            this.myCoreCount.addItem(core);
        }
    }

    private void populateHostGraphicsDropDown() {
        this.myHostGraphics.removeAllItems();
        boolean supportGuest = this.getSelectedApiLevel() >= 23 && this.isIntel() && this.isGoogleApiSelected();
        GpuMode otherMode = GpuMode.OFF;
        if (supportGuest) {
            otherMode = GpuMode.SWIFT;
        } else if (!SystemInfo.isMac) {
            otherMode = GpuMode.MESA;
        }
        this.myHostGraphics.addItem(GpuMode.AUTO);
        this.myHostGraphics.addItem(GpuMode.HOST);
        this.myHostGraphics.addItem(otherMode);
        boolean atLeastVersion16 = this.getSelectedApiLevel() >= 16;
        this.myHostGraphics.setEnabled(atLeastVersion16);
        this.myHostGraphicProblem.setVisible(!atLeastVersion16);
    }

    private void updateGpuControlsAfterSystemImageChange() {
        GpuMode mode = ((AvdOptionsModel)this.getModel()).hostGpuMode().getValueOr(GpuMode.AUTO);
        this.populateHostGraphicsDropDown();
        switch (mode) {
            case AUTO: {
                this.myHostGraphics.setSelectedIndex(0);
                break;
            }
            case HOST: {
                this.myHostGraphics.setSelectedIndex(1);
                break;
            }
            default: {
                this.myHostGraphics.setSelectedIndex(2);
            }
        }
    }

    private boolean isGoogleApiSelected() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        SystemImageDescription systemImage = ((AvdOptionsModel)this.getModel()).systemImage().getValue();
        IdDisplay tag = systemImage.getTag();
        return SystemImage.WEAR_TAG.equals((Object)tag) || SystemImage.TV_TAG.equals((Object)tag) || SystemImage.GOOGLE_APIS_TAG.equals((Object)tag);
    }

    private boolean isIntel() {
        return this.supportsMultipleCpuCores();
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "onWizardStarting"));
        }
        this.addTitles();
        this.addListeners();
        this.addValidators();
        this.bindComponents();
        this.initComponents();
    }

    @Override
    protected void onEntering() {
        this.updateComponents();
        this.myShowAdvancedSettingsButton.setText(SHOW);
        this.setAdvanceSettingsVisible(false);
        this.toggleOptionals((Optional<Device>)((Optional)((AvdOptionsModel)this.getModel()).device().get()), false);
        if (((Boolean)((AvdOptionsModel)this.getModel()).useExternalSdCard().get()).booleanValue()) {
            this.myBuiltInSdCardStorage.setEnabled(false);
            this.myExternalSdCard.setEnabled(true);
        } else {
            this.myBuiltInSdCardStorage.setEnabled(true);
            this.myExternalSdCard.setEnabled(false);
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "canGoForward"));
        }
        return observableBool;
    }

    private void addTitles() {
        this.myAvdId.putClientProperty((Object)"TITLE", (Object)"AVD Id");
        this.myRamStorage.putClientProperty("TITLE", "Device RAM");
        this.myAvdDisplayName.putClientProperty("TITLE", "AVD Name");
        this.myCoreCount.putClientProperty("TITLE", "Number of cores");
        this.mySpeedCombo.putClientProperty("TITLE", "Network Speed");
        this.myBackCameraCombo.putClientProperty("TITLE", "Back Camera");
        this.myLatencyCombo.putClientProperty("TITLE", "Network Latency");
        this.myFrontCameraCombo.putClientProperty("TITLE", "Front Camera");
        this.myQemu2CheckBox.putClientProperty("TITLE", "Number of cores");
        this.myInternalStorage.putClientProperty("TITLE", "Internal Flash");
        this.myHostGraphics.putClientProperty("TITLE", "Graphics Rendering");
        this.mySkinComboBox.putClientProperty("TITLE", "Custom Device Frame");
        this.myVmHeapStorage.putClientProperty("TITLE", "Virtual Machine Heap");
        this.myOrientationToggle.putClientProperty("TITLE", "Default Orientation");
        this.myBuiltInSdCardStorage.putClientProperty("TITLE", "Built-in SD Card Size");
        this.myDeviceFrameCheckbox.putClientProperty("TITLE", "Enable device frame");
        this.myBuiltInRadioButton.putClientProperty("TITLE", "Built-in SD Card Size");
        this.myEnableComputerKeyboard.putClientProperty("TITLE", "Enable keyboard input");
        this.myExternalSdCard.putClientProperty((Object)"TITLE", (Object)"Location of external SD card image");
        this.myExternalRadioButton.putClientProperty("TITLE", "Location of external SD card image");
    }

    private void initComponents() {
        this.myCoreCount.setPreferredSize(this.myRamStorage.getPreferredSizeOfUnitsDropdown());
        this.setAdvanceSettingsVisible(false);
        this.myAvdIdLabel.setLabelFor((Component)this.myAvdId);
        this.myDeviceDetails.setLabelFor((Component)this.myDeviceName);
        this.mySystemImageDetails.setLabelFor((Component)this.mySystemImageName);
        this.myOrientationLabel.setLabelFor(this.myOrientationToggle);
        this.myRamLabel.setLabelFor((Component)this.myRamStorage);
    }

    private void updateComponents() {
        this.myAvdConfigurationOptionHelpPanel.setSystemImageDescription(((AvdOptionsModel)this.getModel()).systemImage().getValueOrNull());
        this.myOrientationToggle.setSelectedElement((ScreenOrientation)((AvdOptionsModel)this.getModel()).selectedAvdOrientation().get());
        if (!((Boolean)((AvdOptionsModel)this.getModel()).isInEditMode().get()).booleanValue() && ((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent() && ((Optional)((AvdOptionsModel)this.getModel()).device().get()).isPresent()) {
            String avdDisplayName = AvdNameVerifier.stripBadCharacters(((AvdOptionsModel)this.getModel()).device().getValue().getDisplayName());
            ((AvdOptionsModel)this.getModel()).avdDisplayName().set(this.connection.uniquifyDisplayName(String.format(Locale.getDefault(), "%1$s API %2$s", avdDisplayName, this.getSelectedApiString())));
        }
        this.myOriginalName = (Boolean)((AvdOptionsModel)this.getModel()).isInEditMode().get() != false ? (String)((AvdOptionsModel)this.getModel()).avdDisplayName().get() : "";
        this.updateSystemImageData();
        this.myOriginalSdCard = ((AvdOptionsModel)this.getModel()).sdCardStorage().getValue();
        this.mySelectedCoreCount = (Boolean)((AvdOptionsModel)this.getModel()).useQemu2().get() != false ? ((AvdOptionsModel)this.getModel()).cpuCoreCount().getValueOr(1) : AvdOptionsModel.MAX_NUMBER_OF_CORES;
    }

    private void addListeners() {
        this.myAvdId.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigureAvdOptionsStep.this.myAvdId.requestFocusInWindow();
            }
        });
        this.myShowAdvancedSettingsButton.addActionListener(this.myToggleAdvancedSettingsListener);
        this.myChangeDeviceButton.addActionListener(this.myChangeDeviceButtonListener);
        this.myChangeSystemImageButton.addActionListener(this.myChangeSystemImageButtonListener);
        this.myExternalRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAvdOptionsStep.this.myExternalSdCard.setEnabled(true);
                ConfigureAvdOptionsStep.this.myBuiltInSdCardStorage.setEnabled(false);
            }
        });
        this.myBuiltInRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAvdOptionsStep.this.myExternalSdCard.setEnabled(false);
                ConfigureAvdOptionsStep.this.myBuiltInSdCardStorage.setEnabled(true);
            }
        });
        this.myOrientationToggle.setOpaque(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUS_OWNER, this.myPropertyChangeListener);
        this.myListeners.receive(((AvdOptionsModel)this.getModel()).device(), device -> {
            this.toggleOptionals((Optional<Device>)device, true);
            if (device.isPresent()) {
                this.myDeviceName.setIcon(DeviceDefinitionPreview.getIcon(((AvdOptionsModel)this.getModel()).getAvdDeviceData()));
                this.myDeviceName.setText(((AvdOptionsModel)this.getModel()).device().getValue().getDisplayName());
                this.updateDeviceDetails();
            }
        });
        List<AbstractProperty<?>> deviceProperties = AbstractProperty.getAll(((AvdOptionsModel)this.getModel()).getAvdDeviceData());
        deviceProperties.add(((AvdOptionsModel)this.getModel()).systemImage());
        this.myListeners.listenAll(deviceProperties).with(new Runnable(){

            @Override
            public void run() {
                if (((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().get()).isPresent() && ((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().get()).isPresent()) {
                    File skin = AvdWizardUtils.resolveSkinPath(((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().getValue(), ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().getValue(), FileOpUtils.create());
                    if (skin != null) {
                        ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().setValue(skin);
                        if (FileUtil.filesEqual((File)skin, (File)AvdWizardUtils.NO_SKIN)) {
                            ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setSelected(false);
                        }
                    } else {
                        ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().setValue(AvdWizardUtils.NO_SKIN);
                    }
                }
            }
        });
        this.myListeners.listen(((AvdOptionsModel)this.getModel()).systemImage(), new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$5", "onInvalidated"));
                }
                ConfigureAvdOptionsStep.this.updateSystemImageData();
            }
        });
        this.myListeners.receive(((AvdOptionsModel)this.getModel()).sdCardStorage(), storage -> {
            if (this.myCheckSdForChanges && storage.isPresent() && !((Storage)storage.get()).equals((Object)this.myOriginalSdCard)) {
                int result = Messages.showYesNoDialog((Project)null, (String)"Changing the size of the built-in SD card will erase the current contents of the card. Continue?", (String)"Confirm Data Wipe", (Icon)AllIcons.General.QuestionDialog);
                if (result == 0) {
                    this.myCheckSdForChanges = false;
                } else {
                    ((AvdOptionsModel)this.getModel()).sdCardStorage().setValue(this.myOriginalSdCard);
                }
            }
        });
        this.myListeners.listen(((AvdOptionsModel)this.getModel()).useQemu2(), new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$6", "onInvalidated"));
                }
                ConfigureAvdOptionsStep.this.toggleSystemOptionals(true);
            }
        });
        this.myListeners.receive(((AvdOptionsModel)this.getModel()).selectedAvdOrientation(), screenOrientation -> this.myOrientationToggle.setSelectedElement((ScreenOrientation)screenOrientation));
    }

    private void updateSystemImageData() {
        if (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent()) {
            SystemImageDescription image = ((AvdOptionsModel)this.getModel()).systemImage().getValue();
            String codeName = SdkVersionInfo.getCodeName((int)image.getVersion().getApiLevel());
            if (codeName != null) {
                ((AvdOptionsModel)this.getModel()).systemImageName().set(codeName);
            }
            try {
                Icon icon = IconLoader.findIcon((String)String.format("/icons/versions/%s_32.png", codeName), AndroidIcons.class);
                this.mySystemImageName.setIcon(icon);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ((AvdOptionsModel)this.getModel()).systemImageDetails().set(image.getName() + " " + image.getAbiType());
            this.myAvdConfigurationOptionHelpPanel.setSystemImageDescription(image);
            this.updateGpuControlsAfterSystemImageChange();
            this.toggleSystemOptionals(false);
        }
    }

    private void bindComponents() {
        this.myBindings.bindTwoWay(new TextProperty(this.myAvdDisplayName), ((AvdOptionsModel)this.getModel()).avdDisplayName());
        this.myBindings.bind(new TextProperty((JLabel)this.myAvdId), new StringExpression(new ObservableValue[]{((AvdOptionsModel)this.getModel()).avdDisplayName()}){

            @Override
            @NotNull
            public String get() {
                String displayName = (String)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdDisplayName().get();
                ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdId().set(StringUtil.isNotEmpty((String)displayName) ? AvdWizardUtils.cleanAvdName(ConfigureAvdOptionsStep.this.connection, displayName, !displayName.equals(ConfigureAvdOptionsStep.this.myOriginalName)) : "");
                String string = (String)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdId().get();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$8", "get"));
                }
                return string;
            }
        });
        this.myBindings.bindTwoWay(new TextProperty((JLabel)this.mySystemImageName), ((AvdOptionsModel)this.getModel()).systemImageName());
        this.myBindings.bindTwoWay(new TextProperty((JLabel)this.mySystemImageDetails), ((AvdOptionsModel)this.getModel()).systemImageDetails());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myQemu2CheckBox), ((AvdOptionsModel)this.getModel()).useQemu2());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myCoreCount), ((AvdOptionsModel)this.getModel()).cpuCoreCount());
        this.myBindings.bindTwoWay(this.myRamStorage.storage(), ((AvdOptionsModel)this.getModel()).getAvdDeviceData().ramStorage());
        this.myBindings.bindTwoWay(this.myVmHeapStorage.storage(), ((AvdOptionsModel)this.getModel()).vmHeapStorage());
        this.myBindings.bindTwoWay(this.myInternalStorage.storage(), ((AvdOptionsModel)this.getModel()).internalStorage());
        this.myBindings.bindTwoWay(this.myBuiltInSdCardStorage.storage(), new OptionalToValuePropertyAdapter(((AvdOptionsModel)this.getModel()).sdCardStorage()));
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myHostGraphics), ((AvdOptionsModel)this.getModel()).hostGpuMode());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myDeviceFrameCheckbox), ((AvdOptionsModel)this.getModel()).hasDeviceFrame());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.mySkinComboBox.getComboBox()), ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile());
        this.myOrientationToggle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ScreenOrientation orientation = (ScreenOrientation)ConfigureAvdOptionsStep.this.myOrientationToggle.getSelectedElement();
                if (orientation == null) {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).selectedAvdOrientation().set(ScreenOrientation.PORTRAIT);
                } else {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).selectedAvdOrientation().set(orientation);
                }
            }
        });
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, true);
            }
        };
        fileChooserDescriptor.setHideIgnored(false);
        this.myExternalSdCard.addBrowseFolderListener("Select SD Card", "Select an existing SD card image", this.myProject, fileChooserDescriptor);
        this.myBindings.bindTwoWay(new TextProperty(this.myExternalSdCard.getTextField()), ((AvdOptionsModel)this.getModel()).externalSdCardLocation());
        this.myBindings.bindTwoWay(new OptionalToValuePropertyAdapter(new SelectedItemProperty(this.myFrontCameraCombo)), ((AvdOptionsModel)this.getModel()).selectedFrontCamera());
        this.myBindings.bindTwoWay(new OptionalToValuePropertyAdapter(new SelectedItemProperty(this.myBackCameraCombo)), ((AvdOptionsModel)this.getModel()).selectedBackCamera());
        this.myBindings.bindTwoWay(new OptionalToValuePropertyAdapter(new SelectedItemProperty(this.mySpeedCombo)), ((AvdOptionsModel)this.getModel()).selectedNetworkSpeed());
        this.myBindings.bindTwoWay(new OptionalToValuePropertyAdapter(new SelectedItemProperty(this.myLatencyCombo)), ((AvdOptionsModel)this.getModel()).selectedNetworkLatency());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myEnableComputerKeyboard), ((AvdOptionsModel)this.getModel()).enableHardwareKeyboard());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myExternalRadioButton), ((AvdOptionsModel)this.getModel()).useExternalSdCard());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myBuiltInRadioButton), ((AvdOptionsModel)this.getModel()).useBuiltInSdCard());
        this.myCheckSdForChanges = true;
    }

    private void addValidators() {
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).getAvdDeviceData().ramStorage(), new Validator<Storage>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Storage ram) {
                if (ram == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ram", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$11", "validate"));
                }
                Validator.Result result = ram.getSizeAsUnit(Storage.Unit.MiB) < 128L ? new Validator.Result(Validator.Severity.ERROR, "RAM must be a numeric (integer) value of at least 128MB. Recommendation is 1GB.") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$11", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).vmHeapStorage(), new Validator<Storage>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Storage heap) {
                if (heap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$12", "validate"));
                }
                Validator.Result result = heap.getSizeAsUnit(Storage.Unit.MiB) < 16L ? new Validator.Result(Validator.Severity.ERROR, "VM Heap must be a numeric (integer) value of at least 16MB.") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$12", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).internalStorage(), new Validator<Storage>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Storage heap) {
                if (heap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$13", "validate"));
                }
                Validator.Result result = heap.getSizeAsUnit(Storage.Unit.MiB) < 200L ? new Validator.Result(Validator.Severity.ERROR, "Internal storage must be a numeric (integer) value of at least 200MB.") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$13", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).externalSdCardLocation(), new Validator<String>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull String path) {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$14", "validate"));
                }
                Validator.Result result = (Boolean)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).useExternalSdCard().get() != false && !new File(path).isFile() ? new Validator.Result(Validator.Severity.ERROR, "The specified SD image file must be a valid image file") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$14", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).sdCardStorage(), new Validator<Optional<Storage>>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Optional<Storage> value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$15", "validate"));
                }
                Validator.Result result = (Boolean)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).useExternalSdCard().get() == false && ((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).sdCardStorage().get()).isPresent() && ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).sdCardStorage().getValue().getSizeAsUnit(Storage.Unit.MiB) < 10L ? new Validator.Result(Validator.Severity.ERROR, "The SD card must be larger than 10MB") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$15", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile(), new Validator<Optional<File>>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Optional<File> value) {
                File layoutFile;
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$16", "validate"));
                }
                Validator.Result result = Validator.Result.OK;
                if (value.isPresent() && !FileUtil.filesEqual((File)((File)value.get()), (File)AvdWizardUtils.NO_SKIN) && !(layoutFile = new File((File)value.get(), "layout")).isFile()) {
                    result = new Validator.Result(Validator.Severity.ERROR, "The skin directory does not point to a valid skin.");
                }
                Validator.Result result2 = result;
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$16", "validate"));
                }
                return result2;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).avdDisplayName(), new Validator<String>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull String value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$17", "validate"));
                }
                value = value.trim();
                Validator.Severity severity = Validator.Severity.OK;
                String errorMessage = "";
                if (value.isEmpty()) {
                    severity = Validator.Severity.ERROR;
                    errorMessage = "The AVD name cannot be empty.";
                } else if (!AvdNameVerifier.isValid(value)) {
                    severity = Validator.Severity.ERROR;
                    errorMessage = "The AVD name can contain only the characters " + AvdNameVerifier.humanReadableAllowedCharacters();
                } else if (!((Boolean)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).isInEditMode().get()).booleanValue() && AvdManagerConnection.getDefaultAvdManagerConnection().findAvdWithName(value)) {
                    severity = Validator.Severity.ERROR;
                    errorMessage = String.format("An AVD with the name \"%1$s\" already exists.", ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdDisplayName());
                }
                Validator.Result result = new Validator.Result(severity, errorMessage);
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$17", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).device().isPresent().and(((AvdOptionsModel)this.getModel()).systemImage().isPresent()), new Validator<Boolean>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Boolean deviceAndImageArePresent) {
                if (deviceAndImageArePresent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceAndImageArePresent", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "validate"));
                }
                if (deviceAndImageArePresent.booleanValue()) {
                    Optional device = (Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().get();
                    Optional systemImage = (Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().get();
                    if (!ChooseSystemImagePanel.systemImageMatchesDevice((SystemImageDescription)systemImage.get(), (Device)device.get())) {
                        Validator.Result result = new Validator.Result(Validator.Severity.ERROR, "The selected system image is incompatible with the selected device.");
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "validate"));
                        }
                        return result;
                    }
                } else {
                    if (!((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().get()).isPresent()) {
                        Validator.Result result = new Validator.Result(Validator.Severity.ERROR, "You must select a Device to create an AVD.");
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "validate"));
                        }
                        return result;
                    }
                    if (!((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().get()).isPresent()) {
                        Validator.Result result = new Validator.Result(Validator.Severity.ERROR, "You must select a System Image to create an AVD.");
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "validate"));
                        }
                        return result;
                    }
                }
                Validator.Result result = Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).getAvdDeviceData().compatibleSkinSize(), Validator.Severity.WARNING, "The selected skin is not large enough to view the entire screen.");
    }

    @Override
    protected void onProceeding() {
        boolean hasFrame = (Boolean)((AvdOptionsModel)this.getModel()).hasDeviceFrame().get();
        if (hasFrame && ((Optional)((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().get()).isPresent()) {
            ((AvdOptionsModel)this.getModel()).backupSkinFile().clear();
        } else {
            ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().setValue(AvdWizardUtils.NO_SKIN);
            ((AvdOptionsModel)this.getModel()).backupSkinFile().set(((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile());
        }
        if (this.getSelectedApiLevel() < 16 || ((AvdOptionsModel)this.getModel()).hostGpuMode().getValueOrNull() == GpuMode.OFF) {
            ((AvdOptionsModel)this.getModel()).useHostGpu().set(false);
            ((AvdOptionsModel)this.getModel()).hostGpuMode().setValue(GpuMode.OFF);
        } else {
            ((AvdOptionsModel)this.getModel()).useHostGpu().set(true);
        }
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioWizardStepPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAvdDisplayName;
    }

    private void setAdvanceSettingsVisible(boolean show) {
        for (JComponent c : this.myAdvancedOptionsComponents) {
            c.setVisible(show);
        }
        this.toggleSystemOptionals(false);
        this.myScrollRootPane.setPreferredSize(this.myScrollRootPane.getLayout().preferredLayoutSize(this.myScrollRootPane));
    }

    private boolean isAdvancedPanel() {
        return this.myShowAdvancedSettingsButton.getText().equals(HIDE);
    }

    private void toggleSystemOptionals(boolean useQemu2Changed) {
        boolean showMultiCoreOption = this.isAdvancedPanel() && this.doesSystemImageSupportQemu2();
        this.myQemu2Panel.setVisible(showMultiCoreOption);
        if (showMultiCoreOption) {
            boolean showCores;
            boolean bl = showCores = this.supportsMultipleCpuCores() && (Boolean)((AvdOptionsModel)this.getModel()).useQemu2().get() != false && AvdOptionsModel.MAX_NUMBER_OF_CORES > 1;
            if (useQemu2Changed) {
                if (showCores) {
                    ((AvdOptionsModel)this.getModel()).cpuCoreCount().setValue(this.mySelectedCoreCount);
                } else {
                    this.mySelectedCoreCount = ((AvdOptionsModel)this.getModel()).cpuCoreCount().getValueOr(AvdOptionsModel.MAX_NUMBER_OF_CORES);
                    ((AvdOptionsModel)this.getModel()).cpuCoreCount().setValue(1);
                }
            }
            this.myCoreCount.setEnabled(showCores);
        }
    }

    private boolean doesSystemImageSupportQemu2() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        return AvdManagerConnection.doesSystemImageSupportQemu2(((AvdOptionsModel)this.getModel()).systemImage().getValue(), FileOpUtils.create());
    }

    private int getSelectedApiLevel() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        AndroidVersion version = ((AvdOptionsModel)this.getModel()).systemImage().getValue().getVersion();
        return version.getApiLevel();
    }

    private void updateDeviceDetails() {
        Dimension dimension = ((AvdOptionsModel)this.getModel()).getAvdDeviceData().getDeviceScreenDimension();
        String dimensionString = String.format(Locale.getDefault(), "%dx%d", dimension.width, dimension.height);
        AvdDeviceData deviceData = ((AvdOptionsModel)this.getModel()).getAvdDeviceData();
        String densityString = AvdScreenData.getScreenDensity((Boolean)deviceData.isTv().get(), (Double)deviceData.screenDpi().get(), dimension.height).getResourceValue();
        String result = Joiner.on((char)' ').join((Object)((AvdOptionsModel)this.getModel()).device().getValue().getDefaultHardware().getScreen().getDiagonalLength(), (Object)dimensionString, new Object[]{densityString});
        this.myDeviceDetails.setText(result);
    }

    private String getSelectedApiString() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        AndroidVersion version = ((AvdOptionsModel)this.getModel()).systemImage().getValue().getVersion();
        return version.getApiString();
    }

    private void registerAdvancedOptionsVisibility() {
        this.myAdvancedOptionsComponents = Lists.newArrayList((Object[])new JComponent[]{this.myStoragePanel, this.myCameraPanel, this.myNetworkPanel, this.myQemu2Panel, this.myKeyboardPanel, this.myCustomSkinPanel, this.myAvdIdRow});
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myPropertyChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FOCUS_OWNER, this.myPropertyChangeListener);
        }
    }

    private void createUIComponents() {
        Function<ScreenOrientation, Image> orientationIconFunction = new Function<ScreenOrientation, Image>(){

            public Image apply(ScreenOrientation input) {
                return IconUtil.toImage((Icon)((NamedIcon)ORIENTATIONS.get(input)).myIcon);
            }
        };
        Function<ScreenOrientation, String> orientationNameFunction = new Function<ScreenOrientation, String>(){

            public String apply(ScreenOrientation input) {
                return ((NamedIcon)ORIENTATIONS.get(input)).myName;
            }
        };
        this.myOrientationToggle = new ASGallery<ScreenOrientation>(JBList.createDefaultListModel((Object[])new Object[]{ScreenOrientation.PORTRAIT, ScreenOrientation.LANDSCAPE}), orientationIconFunction, orientationNameFunction, (Dimension)JBUI.size((int)50, (int)50), null);
        this.myOrientationToggle.setCellMargin((Insets)JBUI.insets((int)5, (int)20, (int)4, (int)20));
        this.myOrientationToggle.setBackground(JBColor.background());
        this.myOrientationToggle.setForeground(JBColor.foreground());
        this.myHardwareSkinHelpLabel = new HyperlinkLabel("How do I create a custom hardware skin?");
        this.myHardwareSkinHelpLabel.setHyperlinkTarget("http://developer.android.com/tools/devices/managing-avds.html#skins");
        this.mySkinComboBox = new SkinChooser(this.myProject, true);
    }

    private boolean supportsMultipleCpuCores() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        Abi abi = Abi.getEnum((String)((AvdOptionsModel)this.getModel()).systemImage().getValue().getAbiType());
        return abi != null && abi.supportsMultipleCpuCores();
    }

    private void toggleOptionals(@NotNull Optional<Device> device, boolean deviceChange) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "toggleOptionals"));
        }
        boolean IsDevicePresent = device.isPresent();
        Hardware deviceDefaultHardware = IsDevicePresent ? ((Device)device.get()).getDefaultHardware() : null;
        this.myChangeSystemImageButton.setEnabled(IsDevicePresent);
        this.myFrontCameraCombo.setEnabled(IsDevicePresent && deviceDefaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myBackCameraCombo.setEnabled(IsDevicePresent && deviceDefaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myOrientationToggle.setEnabled(IsDevicePresent && ((Device)device.get()).getDefaultState().getOrientation() != ScreenOrientation.SQUARE);
        this.myEnableComputerKeyboard.setEnabled(IsDevicePresent && !deviceDefaultHardware.getKeyboard().equals((Object)Keyboard.QWERTY));
        if (deviceChange) {
            ScreenOrientation orientation = IsDevicePresent ? ((Device)device.get()).getDefaultState().getOrientation() : ScreenOrientation.PORTRAIT;
            this.myOrientationToggle.setSelectedElement(orientation);
        }
        File customSkin = ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().getValueOrNull();
        File backupSkin = ((AvdOptionsModel)this.getModel()).backupSkinFile().getValueOrNull();
        if (backupSkin != null && customSkin == null) {
            ((AvdOptionsModel)this.getModel()).hasDeviceFrame().set(false);
        }
        File hardwareSkin = null;
        if (IsDevicePresent && ((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent()) {
            hardwareSkin = AvdWizardUtils.resolveSkinPath(deviceDefaultHardware.getSkinFile(), ((AvdOptionsModel)this.getModel()).systemImage().getValue(), FileOpUtils.create());
            this.myDeviceName.setIcon(DeviceDefinitionPreview.getIcon(((AvdOptionsModel)this.getModel()).getAvdDeviceData()));
            this.myDeviceName.setText(((AvdOptionsModel)this.getModel()).device().getValue().getDisplayName());
            this.updateDeviceDetails();
        }
        if (customSkin == null) {
            customSkin = backupSkin != null ? backupSkin : hardwareSkin;
        }
        if (customSkin != null) {
            this.mySkinComboBox.getComboBox().setSelectedItem(customSkin);
            ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().setValue(customSkin);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        AvdConfigurationOptionHelpPanel avdConfigurationOptionHelpPanel;
        JButton jButton;
        JButton jButton2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JBLabel jBLabel3;
        JPanel jPanel2;
        JBLabel jBLabel4;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        StorageField storageField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        StorageField storageField2;
        StorageField storageField3;
        StorageField storageField4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JBLabel jBLabel7;
        JBLabel jBLabel8;
        JBLabel jBLabel9;
        JPanel jPanel5;
        JBLabel jBLabel10;
        JComboBox jComboBox;
        JLabel jLabel;
        JComboBox jComboBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel6;
        JPanel jPanel7;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JBLabel jBLabel11;
        JBLabel jBLabel12;
        JBLabel jBLabel13;
        JPanel jPanel8;
        JComboBox jComboBox5;
        JComboBox jComboBox6;
        JBLabel jBLabel14;
        JBLabel jBLabel15;
        JBLabel jBLabel16;
        JPanel jPanel9;
        JBLabel jBLabel17;
        JPanel jPanel10;
        JButton jButton3;
        JBLabel jBLabel18;
        JBLabel jBLabel19;
        JPanel jPanel11;
        JBLabel jBLabel20;
        JPanel jPanel12;
        JTextField jTextField;
        JPanel jPanel13;
        JPanel jPanel14;
        JBScrollPane jBScrollPane;
        JPanel jPanel15;
        this.createUIComponents();
        this.myRoot = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.setMinimumSize(new Dimension(-1, -1));
        jPanel15.setPreferredSize(new Dimension(-1, -1));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jBScrollPane.setAutoscrolls(true);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jPanel15.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myScrollRootPane = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(11, 1, new Insets(3, 3, 3, 10), -1, -1, false, false));
        jPanel14.setMaximumSize(new Dimension(-1, -1));
        jPanel14.setMinimumSize(new Dimension(-1, -1));
        jPanel14.setPreferredSize(new Dimension(-1, -1));
        jBScrollPane.setViewportView(jPanel14);
        this.myAvdNamePanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel21 = new JBLabel();
        jBLabel21.setText("AVD Name");
        jPanel13.add((Component)jBLabel21, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAvdDisplayName = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setToolTipText("<html>The name of this AVD.</html>");
        jPanel13.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myAvdIdRow = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel12, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel22 = new JBLabel();
        this.myAvdIdLabel = jBLabel22;
        jBLabel22.setText("AVD Id");
        jPanel12.add((Component)jBLabel22, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAvdId = jBLabel20 = new JBLabel();
        jBLabel20.setToolTipText("<html>Identification name used to save an AVD on disk. This AVD name can also be used with Android command line tools.</html>");
        jPanel12.add((Component)jBLabel20, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myDevicePanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myDeviceName = jBLabel19 = new JBLabel();
        jBLabel19.setText("(Device Name)");
        jPanel11.add((Component)jBLabel19, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel11.add((Component)jSeparator, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel16, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeviceDetails = jBLabel18 = new JBLabel();
        jBLabel18.setText("No Hardware Profile Selected");
        jPanel16.add((Component)jBLabel18, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myChangeDeviceButton = jButton3 = new JButton();
        jButton3.setText("Change...");
        jPanel16.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myOrientationPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel10, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myOrientationLabel = jBLabel17 = new JBLabel();
        jBLabel17.setEnabled(true);
        jBLabel17.setText("<html>Startup orientation</html>");
        jBLabel17.setHorizontalTextPosition(10);
        jPanel10.add((Component)jBLabel17, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel10.add((Component)jSeparator2, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        ASGallery<ScreenOrientation> aSGallery = this.myOrientationToggle;
        ((JComponent)((Object)aSGallery)).setToolTipText("<html>Sets the initial orientation of the device. During AVD emulation you can also rotate the device screen. </html>");
        jPanel10.add((Component)((Object)aSGallery), new GridConstraints(1, 1, 1, 1, 1, 1, 7, 7, null, null, null));
        this.myCameraPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel9, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myCameraLabel = jBLabel16 = new JBLabel();
        jBLabel16.setEnabled(true);
        jBLabel16.setText("Camera");
        jBLabel16.setHorizontalTextPosition(10);
        jPanel9.add((Component)jBLabel16, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel17, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFrontCameraLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("Front:");
        jPanel17.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackCameraLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("Back:");
        jPanel17.add((Component)jBLabel14, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackCameraCombo = jComboBox6 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("None");
        jComboBox6.setModel(defaultComboBoxModel);
        jComboBox6.setToolTipText("<html>None - no camera installed for AVD<br>Emulated - use a simulated camera<br>Device -  use host computer webcam or built-in camera</html>");
        jPanel17.add(jComboBox6, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myFrontCameraCombo = jComboBox5 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("None");
        jComboBox5.setModel(defaultComboBoxModel2);
        jComboBox5.setToolTipText("<html>None - no camera installed for AVD<br>Emulated - use a simulated camera<br>Device -  use host computer webcam or built-in camera</html>");
        jPanel17.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel9.add((Component)jSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myNetworkPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel8, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myNetworkLabel = jBLabel13 = new JBLabel();
        jBLabel13.setEnabled(true);
        jBLabel13.setText("Network");
        jBLabel13.setHorizontalTextPosition(10);
        jPanel8.add((Component)jBLabel13, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel18, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySpeedLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Speed:");
        jPanel18.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLatencyLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Latency:");
        jPanel18.add((Component)jBLabel11, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLatencyCombo = jComboBox4 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("None");
        jComboBox4.setModel(defaultComboBoxModel3);
        jComboBox4.setToolTipText("<html>Sets the initial state of the simulated network transfer latency used by AVD. Latency is the delay in processing data across the network. The latency speed can also be adjusted in the emulator.</html>");
        jPanel18.add(jComboBox4, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.mySpeedCombo = jComboBox3 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel4.addElement("Full");
        jComboBox3.setModel(defaultComboBoxModel4);
        jComboBox3.setToolTipText("<html>Sets the initial state of the simulated network transfer rate used by AVD. The network speed can also be adjusted in the emulator.</html>");
        jPanel18.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel8.add((Component)jSeparator4, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myPerformancePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel7, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel23 = new JBLabel();
        jBLabel23.setEnabled(true);
        jBLabel23.setText("<html>Emulated<br>Performance</html>");
        jBLabel23.setHorizontalTextPosition(10);
        jPanel7.add((Component)jBLabel23, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel7.add((Component)jSeparator5, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel19, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myQemu2Panel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel6.add((Component)jSeparator6, new GridConstraints(0, 0, 1, 3, 1, 1, 3, 0, null, null, null));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel20, new GridConstraints(1, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        this.myQemu2CheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Multi-Core CPU");
        jCheckBox3.setToolTipText("<html>Select the number of CPU cores for the emulator to use.</html>");
        jPanel20.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCoreCount = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel5 = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel5);
        jComboBox2.setToolTipText("<html>Select the number of CPU cores for the emulator to use.</html>");
        jPanel20.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMultiCoreExperimentalLabel = jLabel = new JLabel();
        jLabel.setText("(Experimental)");
        jPanel20.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel21, new GridConstraints(0, 0, 2, 2, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel24 = new JBLabel();
        jBLabel24.setText("Graphics:");
        jPanel21.add((Component)jBLabel24, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHostGraphics = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel6 = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel6);
        jComboBox.setToolTipText("<html>Choose how the graphics should be rendered in the emulator.<br><br><b>Hardware</b><br>Use your computer's graphics card for faster rendering.<br><br><b>Software</b><br>Emulate the graphics in software, use this to work around issues with your computer's graphics card.</html>");
        jPanel21.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHostGraphicProblem = jBLabel10 = new JBLabel();
        jBLabel10.setText("Acceleration requires API > 15");
        jPanel21.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myStoragePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myMemoryAndStorageLabel = jBLabel9 = new JBLabel();
        jBLabel9.setEnabled(true);
        jBLabel9.setText("<html>Memory<br>and<br>Storage</html>");
        jBLabel9.setHorizontalTextPosition(10);
        jPanel5.add((Component)jBLabel9, new GridConstraints(1, 0, 1, 1, 9, 0, 2, 0, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel22, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRamLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("RAM:");
        jPanel22.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVmHeapLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("VM heap:");
        jPanel22.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInternalStorageLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Internal Storage:");
        jPanel22.add((Component)jBLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySdCardLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("SD card:");
        jPanel22.add((Component)jBLabel5, new GridConstraints(3, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myRamStorage = storageField4 = new StorageField();
        storageField4.setToolTipText("<html>The amount of physical RAM on the device.<br>1 MB = 1024 KB<br>1 GB = 1024 MB</html>");
        jPanel22.add((Component)storageField4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myVmHeapStorage = storageField3 = new StorageField();
        storageField3.setToolTipText("<html>The amount of RAM available to Java virtual machine (VM) to allocate to running apps on the device. A larger VM heap allows application to run longer between garbage collection event.</html>");
        jPanel22.add((Component)storageField3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myInternalStorage = storageField2 = new StorageField();
        storageField2.setToolTipText("<html>The amount of non-removable space available to store data on the device.</html>");
        jPanel22.add((Component)storageField2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel23, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBuiltInRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setToolTipText("<html>The amount of removable space available to store data on the device. We recommend at least 100MB in order to use the camera in the emulator.</html>");
        jRadioButton2.setText("Studio-managed");
        jPanel23.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExternalRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setToolTipText("<html>Choose a file path to an existing SD Card image. Using an external SD Card is useful when sharing SD Card data (pictures, media, files, etc.) between Android Virtual Devices. See <a>http://d.android.com/tools/help/mksdcard.html</a> for more details. </html>");
        jRadioButton.setText("External file");
        jPanel23.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBuiltInSdCardStorage = storageField = new StorageField();
        storageField.setToolTipText("<html>The amount of removable space available to store data on the device. We recommend at least 100MB in order to use the camera in the emulator.</html>");
        jPanel23.add((Component)storageField, new GridConstraints(0, 1, 1, 1, 1, 1, 7, 0, null, null, null));
        this.myExternalSdCard = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText("<html>Choose a file path to an existing SD Card image. Using an external SD Card is useful when sharing SD Card data (pictures, media, files, etc.) between Android Virtual Devices. See http://d.android.com/tools/help/mksdcard.html for more details. </html>");
        textFieldWithBrowseButton.setVisible(true);
        jPanel23.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, null, null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel5.add((Component)jSeparator7, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myFramePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel4, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel25 = new JBLabel();
        jBLabel25.setText("Device Frame");
        jPanel4.add((Component)jBLabel25, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceFrameCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable Device Frame");
        jCheckBox2.setToolTipText("<html>Enable a frame around the Android emulator window that mimics the look of a real Android device. Click on Show Advanced Settings for more options.</html>");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator8 = new JSeparator();
        jPanel4.add((Component)jSeparator8, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myCustomSkinPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySkinDefinitionLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Custom skin definition");
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHardwareSkinHelpLabel;
        hyperlinkLabel.setVisible(true);
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        SkinChooser skinChooser = this.mySkinComboBox;
        ((JComponent)((Object)skinChooser)).setToolTipText("<html>A collection of images and configuration data that indicates how to populate the window. Each skin can have several \"layouts\" (e.g. \"landscape\" and \"portrait\") corresponding to different orientation / physical configurations of the emulated device.</html>");
        ((Component)((Object)skinChooser)).setVisible(true);
        jPanel3.add((Component)((Object)skinChooser), new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myKeyboardPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel2, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myKeyboardLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Keyboard");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableComputerKeyboard = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable keyboard input");
        jCheckBox.setToolTipText("<html>Enables you to enter text input and interact with the AVD with your hardware computer keyboard instead of a of the on on-screen software keyboard.</html>");
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator9 = new JSeparator();
        jPanel2.add((Component)jSeparator9, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myImagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.mySystemImageName = jBLabel2 = new JBLabel();
        jBLabel2.setText("(Image Name)");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        JSeparator jSeparator10 = new JSeparator();
        jPanel.add((Component)jSeparator10, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel24, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySystemImageDetails = jBLabel = new JBLabel();
        jBLabel.setText("No System Image Selected");
        jPanel24.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myChangeSystemImageButton = jButton2 = new JButton();
        jButton2.setText("Change...");
        jPanel24.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel14.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShowAdvancedSettingsButton = jButton = new JButton();
        jButton.setText("");
        jPanel15.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAvdConfigurationOptionHelpPanel = avdConfigurationOptionHelpPanel = new AvdConfigurationOptionHelpPanel();
        JComponent jComponent = avdConfigurationOptionHelpPanel.$$$getRootComponent$$$();
        jPanel15.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, new Dimension(350, -1), null, null));
        jBLabel21.setLabelFor(jTextField);
        jBLabel15.setLabelFor(jComboBox5);
        jBLabel14.setLabelFor(jComboBox6);
        jBLabel12.setLabelFor(jComboBox3);
        jBLabel11.setLabelFor(jComboBox4);
        jBLabel24.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static final class NamedIcon {
        @NotNull
        private final String myName;
        @NotNull
        private final Icon myIcon;

        public NamedIcon(@NotNull String name, @NotNull Icon icon) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$NamedIcon", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$NamedIcon", "<init>"));
            }
            this.myName = name;
            this.myIcon = icon;
        }
    }
}

