/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.ValuedTreeNode;
import com.android.tools.adtui.chart.SunburstChart;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiFileAndLineNavigation;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.ClassNode;
import com.android.tools.idea.editors.allocations.nodes.MainTreeNode;
import com.android.tools.idea.editors.allocations.nodes.PackageNode;
import com.android.tools.idea.editors.allocations.nodes.PackageRootNode;
import com.android.tools.idea.editors.allocations.nodes.StackNode;
import com.android.tools.idea.editors.allocations.nodes.StackTraceNode;
import com.android.tools.idea.editors.allocations.nodes.ThreadNode;
import com.android.utils.HtmlBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllocationsView
implements SunburstChart.SliceSelectionListener {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AllocationInfo[] myAllocations;
    private final DefaultTableModel myInfoTableModel;
    private final SearchTextFieldWithStoredHistory myPackageFilter;
    @NotNull
    private MainTreeNode myTreeNode;
    @NotNull
    private final JTree myTree;
    @NotNull
    private final DefaultTreeModel myTreeModel;
    @NotNull
    private JBSplitter mySplitter;
    @NotNull
    private JComponent myChartPane;
    @NotNull
    private final Component myComponent;
    private GroupBy myGroupBy;
    private final SunburstChart myLayout;
    private String myChartOrientation;
    private String myChartUnit;
    private final JLabel myInfoLabel;
    private Alarm myAlarm;
    private final JBTable myInfoTable;

    public AllocationsView(@NotNull Project project, @NotNull AllocationInfo[] allocations) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/allocations/AllocationsView", "<init>"));
        }
        if (allocations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocations", "com/android/tools/idea/editors/allocations/AllocationsView", "<init>"));
        }
        this.myProject = project;
        this.myAllocations = allocations;
        this.myGroupBy = new GroupByMethod();
        this.myTreeNode = this.generateTree();
        this.myTreeModel = new DefaultTreeModel((TreeNode)((Object)this.myTreeNode));
        this.myAlarm = new Alarm((Disposable)project);
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty("DataProvider", new TreeDataProvider());
        final DefaultActionGroup popupGroup = new DefaultActionGroup();
        popupGroup.add((AnAction)new EditMultipleSourcesAction());
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Method").setPreferredWidth(600).setHeaderAlignment(2).setComparator((Comparator)new Comparator<AbstractTreeNode>(){

            @Override
            public int compare(AbstractTreeNode a, AbstractTreeNode b) {
                if (a instanceof ThreadNode && b instanceof ThreadNode) {
                    return ((ThreadNode)a).getThreadId() - ((ThreadNode)b).getThreadId();
                }
                if (a instanceof StackNode && b instanceof StackNode) {
                    StackTraceElement ea = ((StackNode)a).getStackTraceElement();
                    StackTraceElement eb = ((StackNode)b).getStackTraceElement();
                    int value = ea.getMethodName().compareTo(eb.getMethodName());
                    if (value == 0) {
                        value = ea.getLineNumber() - eb.getLineNumber();
                    }
                    return value;
                }
                return a.getClass().toString().compareTo(b.getClass().toString());
            }
        }).setRenderer((ColoredTreeCellRenderer)new NodeTreeCellRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Count").setPreferredWidth(150).setHeaderAlignment(4).setComparator((Comparator)new Comparator<AbstractTreeNode>(){

            @Override
            public int compare(AbstractTreeNode a, AbstractTreeNode b) {
                return a.getCount() - b.getCount();
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/allocations/AllocationsView$4", "customizeCellRenderer"));
                }
                if (value instanceof ValuedTreeNode) {
                    int v = ((ValuedTreeNode)value).getCount();
                    int total = AllocationsView.this.myTreeNode.getCount();
                    this.setTextAlign(4);
                    this.append(String.valueOf(v));
                    this.append(String.format(" (%.2f%%)", Float.valueOf(100.0f * (float)v / (float)total)), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Size").setPreferredWidth(150).setHeaderAlignment(4).setInitialOrder(SortOrder.DESCENDING).setComparator((Comparator)new Comparator<AbstractTreeNode>(){

            @Override
            public int compare(AbstractTreeNode a, AbstractTreeNode b) {
                return a.getValue() - b.getValue();
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/allocations/AllocationsView$2", "customizeCellRenderer"));
                }
                if (value instanceof ValuedTreeNode) {
                    int v = ((ValuedTreeNode)value).getValue();
                    int total = AllocationsView.this.myTreeNode.getValue();
                    this.setTextAlign(4);
                    this.append(String.valueOf(v));
                    this.append(String.format(" (%.2f%%)", Float.valueOf(100.0f * (float)v / (float)total)), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                }
            }
        }));
        builder.setTreeSorter((ColumnTreeBuilder.TreeSorter)new ColumnTreeBuilder.TreeSorter<AbstractTreeNode>(){

            public void sort(Comparator<AbstractTreeNode> comparator, SortOrder sortOrder) {
                AllocationsView.this.myTreeNode.sort(comparator);
                AllocationsView.this.myTreeModel.nodeStructureChanged((TreeNode)((Object)AllocationsView.this.myTreeNode));
            }
        });
        JComponent columnTree = builder.build();
        this.mySplitter = new JBSplitter(true);
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath e) {
                Object o = e.getLastPathComponent();
                if (o instanceof StackNode) {
                    StackTraceElement ee = ((StackNode)o).getStackTraceElement();
                    return ee.toString();
                }
                return o.toString();
            }
        }, true);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.getMainActions(), true);
        topPanel.add((Component)toolbar.getComponent(), "Center");
        this.myPackageFilter = new SearchTextFieldWithStoredHistory("alloc.package.filter");
        this.myPackageFilter.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                AllocationsView.this.myAlarm.cancelAllRequests();
                AllocationsView.this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        AllocationsView.this.setGroupBy(new GroupByAllocator());
                    }
                }, 1000);
            }
        });
        this.myPackageFilter.setVisible(false);
        topPanel.add((Component)this.myPackageFilter, "East");
        panel.add((Component)topPanel, "North");
        panel.add((Component)columnTree, "Center");
        this.mySplitter.setFirstComponent((JComponent)panel);
        this.myChartPane = new JPanel(new BorderLayout());
        this.myLayout = new SunburstChart((ValuedTreeNode)this.myTreeNode);
        this.myLayout.setAngle(360.0f);
        this.myLayout.setAutoSize(true);
        this.myLayout.setSeparator(1.0f);
        this.myLayout.setGap(20.0f);
        this.myLayout.addSelectionListener((SunburstChart.SliceSelectionListener)this);
        this.myLayout.setBorder(IdeBorderFactory.createBorder());
        this.myLayout.setBackground(UIUtil.getTreeBackground());
        Choreographer.animate((AnimatedComponent)this.myLayout);
        toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.getChartActions(), true);
        this.myChartOrientation = "Sunburst";
        this.myChartUnit = "Size";
        this.myChartPane.add((Component)toolbar.getComponent(), "North");
        JBSplitter chartSplitter = new JBSplitter();
        this.myChartPane.add((Component)chartSplitter, "Center");
        chartSplitter.setFirstComponent((JComponent)this.myLayout);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(IdeBorderFactory.createBorder());
        this.myInfoLabel = new JLabel();
        this.myInfoLabel.setBackground(UIUtil.getTreeBackground());
        this.myInfoLabel.setOpaque(true);
        this.myInfoLabel.setVerticalAlignment(1);
        infoPanel.add((Component)this.myInfoLabel, "North");
        this.myInfoTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int i, int i1) {
                return false;
            }
        };
        this.myInfoTableModel.addColumn("Data");
        this.myInfoTable = new JBTable((TableModel)this.myInfoTableModel);
        this.myInfoTable.putClientProperty((Object)"DataProvider", (Object)new TableDataProvider());
        this.myInfoTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }

            public void mousePressed(MouseEvent e) {
                Object value;
                super.mousePressed(e);
                if (e.getClickCount() == 2 && (value = AllocationsView.this.myInfoTable.getValueAt(AllocationsView.this.myInfoTable.getSelectedRow(), 0)) instanceof TreeNode) {
                    Object[] nodes = AllocationsView.this.myTreeModel.getPathToRoot((TreeNode)value);
                    TreePath path = new TreePath(nodes);
                    AllocationsView.this.myTree.setSelectionPath(path);
                    AllocationsView.this.myTree.scrollPathToVisible(path);
                }
            }
        });
        this.myInfoTable.setTableHeader(null);
        this.myInfoTable.setShowGrid(false);
        this.myInfoTable.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new NodeTableCellRenderer()));
        JBScrollPane scroll = new JBScrollPane((Component)this.myInfoTable);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        infoPanel.add((Component)scroll, "Center");
        chartSplitter.setSecondComponent((JComponent)infoPanel);
        chartSplitter.setProportion(0.7f);
        this.myComponent = this.mySplitter;
    }

    @NotNull
    public Component getComponent() {
        Component component = this.myComponent;
        if (component == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsView", "getComponent"));
        }
        return component;
    }

    private void setGroupBy(@NotNull GroupBy groupBy) {
        if (groupBy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupBy", "com/android/tools/idea/editors/allocations/AllocationsView", "setGroupBy"));
        }
        this.myGroupBy = groupBy;
        this.myTreeNode = this.generateTree();
        this.myTreeModel.setRoot((TreeNode)((Object)this.myTreeNode));
        this.myLayout.setData((ValuedTreeNode)this.myTreeNode);
        this.myLayout.resetZoom();
        this.myTreeModel.nodeStructureChanged((TreeNode)((Object)this.myTreeNode));
        this.myPackageFilter.setVisible(groupBy instanceof GroupByAllocator);
    }

    private ActionGroup getMainActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new ChangeGroupAction(new GroupByMethod()));
                group.add((AnAction)new ChangeGroupAction(new GroupByAllocator()));
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsView$12", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(AllocationsView.this.myGroupBy.getName());
                e.getPresentation().setText(AllocationsView.this.myGroupBy.getName());
            }
        });
        group.add((AnAction)new EditMultipleSourcesAction());
        group.add((AnAction)new ShowChartAction());
        return group;
    }

    @Nullable
    public Object getData(@NonNls String dataId, Object selectionData) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles(selectionData);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private ActionGroup getChartActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(new AnAction("Sunburst"){

                    public void actionPerformed(AnActionEvent e) {
                        AllocationsView.this.myChartOrientation = "Sunburst";
                        AllocationsView.this.myLayout.setAngle(360.0f);
                    }
                });
                group.add(new AnAction("Layout"){

                    public void actionPerformed(AnActionEvent e) {
                        AllocationsView.this.myChartOrientation = "Layout";
                        AllocationsView.this.myLayout.setAngle(0.0f);
                    }
                });
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsView$13", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(AllocationsView.this.myChartOrientation);
                e.getPresentation().setText(AllocationsView.this.myChartOrientation);
            }
        });
        group.add((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(new AnAction("Size"){

                    public void actionPerformed(AnActionEvent e) {
                        AllocationsView.this.myChartUnit = "Size";
                        AllocationsView.this.myLayout.setUseCount(false);
                    }
                });
                group.add(new AnAction("Count"){

                    public void actionPerformed(AnActionEvent e) {
                        AllocationsView.this.myChartUnit = "Count";
                        AllocationsView.this.myLayout.setUseCount(true);
                    }
                });
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsView$14", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(AllocationsView.this.myChartUnit);
                e.getPresentation().setText(AllocationsView.this.myChartUnit);
            }
        });
        return group;
    }

    @NotNull
    private MainTreeNode generateTree() {
        MainTreeNode tree = this.myGroupBy.create();
        for (AllocationInfo alloc : this.myAllocations) {
            tree.insert(alloc);
        }
        MainTreeNode mainTreeNode = tree;
        if (mainTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsView", "generateTree"));
        }
        return mainTreeNode;
    }

    public void valueChanged(SunburstChart.SliceSelectionEvent e) {
        ValuedTreeNode node = e == null ? null : e.getNode();
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        if (node == null) {
            node = this.myTreeNode;
        }
        builder.add("Total allocations:").addNbsp().addBold(Integer.toString(node.getCount())).newline().add("Total size:").addNbsp().addBold(StringUtil.formatFileSize((long)node.getValue())).newline().newline();
        if (node instanceof AbstractTreeNode) {
            TreeNode[] path = this.myTreeModel.getPathToRoot((TreeNode)node);
            this.myInfoTableModel.setRowCount(path.length);
            for (int i = 1; i < path.length; ++i) {
                this.myInfoTableModel.setValueAt(path[i], i - 1, 0);
            }
            this.myInfoTableModel.fireTableDataChanged();
        }
        builder.closeHtmlBody();
        this.myInfoLabel.setText(builder.getHtml());
    }

    private static void customizeColoredRenderer(SimpleColoredComponent renderer, Object value) {
        renderer.setTransparentIconBackground(true);
        if (value instanceof ThreadNode) {
            renderer.setIcon(AllIcons.Debugger.ThreadSuspended);
            renderer.append("< Thread " + ((ThreadNode)value).getThreadId() + " >");
        } else if (value instanceof StackNode) {
            StackTraceElement element = ((StackNode)value).getStackTraceElement();
            String name = element.getClassName();
            String pkg = null;
            int ix = name.lastIndexOf(".");
            if (ix != -1) {
                pkg = name.substring(0, ix);
                name = name.substring(ix + 1);
            }
            renderer.setIcon(PlatformIcons.METHOD_ICON);
            renderer.append(element.getMethodName() + "()");
            renderer.append(":" + element.getLineNumber() + ", ");
            renderer.append(name);
            if (pkg != null) {
                renderer.append(" (" + pkg + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
        } else if (value instanceof AllocNode) {
            AllocationInfo allocation = ((AllocNode)value).getAllocation();
            renderer.setIcon(AllIcons.FileTypes.JavaClass);
            renderer.append(allocation.getAllocatedClass());
        } else if (value instanceof ClassNode) {
            renderer.setIcon(PlatformIcons.CLASS_ICON);
            renderer.append(((PackageNode)value).getName());
        } else if (value instanceof PackageNode) {
            String name = ((PackageNode)value).getName();
            if (!name.isEmpty()) {
                renderer.setIcon(AllIcons.Modules.SourceFolder);
                renderer.append(name);
            }
        } else if (!(value instanceof StackTraceNode) && value != null) {
            renderer.append(value.toString());
        }
    }

    @Nullable
    private PsiFileAndLineNavigation[] getTargetFiles(Object node) {
        if (node == null) {
            return null;
        }
        String className = null;
        int lineNumber = 0;
        if (node instanceof ClassNode) {
            className = ((ClassNode)node).getQualifiedName();
        } else {
            StackTraceElement[] stack;
            StackTraceElement element = null;
            if (node instanceof StackNode) {
                element = ((StackNode)node).getStackTraceElement();
            } else if (node instanceof AllocNode && (stack = ((AllocNode)node).getAllocation().getStackTrace()).length > 0) {
                element = stack[0];
            }
            if (element != null) {
                lineNumber = element.getLineNumber();
                className = element.getClassName();
                int ix = className.indexOf("$");
                if (ix >= 0) {
                    className = className.substring(0, ix);
                }
            }
        }
        return PsiFileAndLineNavigation.wrappersForClassName(this.myProject, className, lineNumber);
    }

    private class TableDataProvider
    implements DataProvider {
        private TableDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            int selectedRow = AllocationsView.this.myInfoTable.getSelectedRow();
            if (selectedRow < 0) {
                return null;
            }
            return AllocationsView.this.getData(dataId, AllocationsView.this.myInfoTable.getValueAt(selectedRow, 0));
        }
    }

    private class TreeDataProvider
    implements DataProvider {
        private TreeDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return AllocationsView.this.getData(dataId, AllocationsView.this.myTree.getLastSelectedPathComponent());
        }
    }

    class ShowChartAction
    extends ToggleAction {
        public ShowChartAction() {
            super("", "", AndroidIcons.Sunburst);
        }

        public boolean isSelected(AnActionEvent e) {
            return AllocationsView.this.mySplitter.getSecondComponent() != null;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                AllocationsView.this.mySplitter.setSecondComponent(AllocationsView.this.myChartPane);
            } else {
                AllocationsView.this.mySplitter.setSecondComponent(null);
            }
            AllocationsView.this.valueChanged(null);
        }
    }

    class ChangeGroupAction
    extends AnAction {
        private GroupBy myGroupBy;

        public ChangeGroupAction(GroupBy groupBy) {
            super(groupBy.getName());
            this.myGroupBy = groupBy;
        }

        public void actionPerformed(AnActionEvent e) {
            AllocationsView.this.setGroupBy(this.myGroupBy);
        }
    }

    class GroupByAllocator
    implements GroupBy {
        GroupByAllocator() {
        }

        @Override
        public String getName() {
            return "Group by Allocator";
        }

        @Override
        public MainTreeNode create() {
            return new PackageRootNode("", AllocationsView.this.myPackageFilter.getText());
        }
    }

    static class GroupByMethod
    implements GroupBy {
        GroupByMethod() {
        }

        @Override
        public String getName() {
            return "Group by Method";
        }

        @Override
        public MainTreeNode create() {
            return new StackTraceNode();
        }
    }

    static interface GroupBy {
        public String getName();

        public MainTreeNode create();
    }

    private static class NodeTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private NodeTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/allocations/AllocationsView$NodeTreeCellRenderer", "customizeCellRenderer"));
            }
            AllocationsView.customizeColoredRenderer((SimpleColoredComponent)this, value);
        }

        protected boolean shouldDrawBackground() {
            return false;
        }
    }

    public static class NodeTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            AllocationsView.customizeColoredRenderer((SimpleColoredComponent)this, value);
        }
    }
}

