/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview.model;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ViewProperty
implements Comparable<ViewProperty> {
    private static final Comparator<String> CATEGORY_COMPARATOR = Ordering.natural().nullsFirst();
    @NotNull
    public final String fullName;
    @NotNull
    public final String name;
    public final String category;
    private String myValue;

    ViewProperty(@NotNull String fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullName", "com/android/tools/idea/editors/hierarchyview/model/ViewProperty", "<init>"));
        }
        this.fullName = fullName;
        int colonIndex = fullName.indexOf(58);
        if (colonIndex != -1) {
            this.category = fullName.substring(0, colonIndex);
            this.name = fullName.substring(colonIndex + 1);
        } else {
            this.category = null;
            this.name = fullName;
        }
    }

    public String toString() {
        return this.fullName + '=' + this.myValue;
    }

    @Override
    public int compareTo(@NotNull ViewProperty other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/editors/hierarchyview/model/ViewProperty", "compareTo"));
        }
        return ComparisonChain.start().compare((Object)this.category, (Object)other.category, CATEGORY_COMPARATOR).compare((Comparable)((Object)this.name), (Comparable)((Object)this.name)).result();
    }

    public void setValue(String value) {
        this.myValue = value;
    }

    public String getValue() {
        return this.myValue;
    }
}

