/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layeredimage;

import com.android.tools.idea.editors.layeredimage.LayeredImageEditorPanel;
import com.android.tools.idea.editors.layeredimage.LayeredImageEditorProvider;
import com.android.tools.idea.editors.layeredimage.LayersManager;
import com.android.tools.idea.editors.layeredimage.Utilities;
import com.android.tools.pixelprobe.Image;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.ZoomOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredImageEditor
extends UserDataHolderBase
implements FileEditor {
    private final FileEditor myEditor;
    private final DumbService myDumbService;
    private final LayersManager myLayersManager;
    private final ImageEditor myImageEditor;
    private Image myImage;
    private LayeredImageEditorPanel myEditorPanel;

    LayeredImageEditor(Project project, VirtualFile file, FileEditor editor) {
        this.myEditor = editor;
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myLayersManager = LayersManager.get(project);
        this.myImageEditor = ((ImageFileEditor)editor).getImageEditor();
        try {
            this.myImage = Utilities.loadImage(file);
            this.setImage(this.myImage);
        }
        catch (IOException e) {
            Logger.getInstance(LayeredImageEditorProvider.class).error("Unexpected exception while reading image " + file.getCanonicalPath(), (Throwable)e);
        }
    }

    private void setImage(Image image) throws IOException {
        ImageDocument document = this.myImageEditor.getDocument();
        BufferedImage previousImage = document.getValue();
        document.setValue(Utilities.getDisplayableImage(image));
        String format = image.getFormat() + "/" + image.getColorMode();
        String description = image.getColorProfileDescription();
        if (!description.isEmpty()) {
            format = format + ", " + description;
        }
        document.setFormat(format);
        ImageZoomModel zoomModel = this.myImageEditor.getZoomModel();
        if (previousImage == null || !zoomModel.isZoomLevelChanged()) {
            Options options = OptionsManager.getInstance().getOptions();
            ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
            zoomModel.setZoomFactor(1.0);
            if (zoomOptions.isSmartZooming()) {
                Dimension preferred = zoomOptions.getPrefferedSize();
                if (preferred.width > image.getWidth() && preferred.height > image.getHeight()) {
                    double factor = (preferred.getWidth() / (double)image.getWidth() + preferred.getHeight() / (double)image.getHeight()) / 2.0;
                    zoomModel.setZoomFactor(Math.ceil(factor));
                }
            }
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
        this.getComponent().dispose();
    }

    @NotNull
    public LayeredImageEditorPanel getComponent() {
        if (this.myEditorPanel == null) {
            this.myEditorPanel = new LayeredImageEditorPanel(this.myImageEditor, this.myImage);
            this.myDumbService.smartInvokeLater(() -> this.myLayersManager.bind(this.myEditorPanel));
        }
        LayeredImageEditorPanel layeredImageEditorPanel = this.myEditorPanel;
        if (layeredImageEditorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "getComponent"));
        }
        return layeredImageEditorPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getComponent().getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        if ("LayeredImageEditor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "getName"));
        }
        return "LayeredImageEditor";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "getState"));
        }
        FileEditorState fileEditorState = this.myEditor.getState(level);
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "setState"));
        }
        this.myEditor.setState(state);
    }

    public boolean isModified() {
        return this.myEditor.isModified();
    }

    public boolean isValid() {
        return this.myEditor.isValid();
    }

    public void selectNotify() {
        this.myEditor.selectNotify();
    }

    public void deselectNotify() {
        this.myEditor.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "addPropertyChangeListener"));
        }
        this.myEditor.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/layeredimage/LayeredImageEditor", "removePropertyChangeListener"));
        }
        this.myEditor.removePropertyChangeListener(listener);
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myEditor.getStructureViewBuilder();
    }
}

