/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.LibraryAttachments;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.project.PreSyncChecks;
import com.android.tools.idea.gradle.project.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.SdkSync;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.project.NewProjects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.newProject.AndroidModuleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectImporter {
    private static final Logger LOG = Logger.getInstance(GradleProjectImporter.class);
    private static final boolean SYNC_WITH_CACHED_MODEL_ONLY = SystemProperties.getBooleanProperty((String)"studio.sync.with.cached.model.only", (boolean)false);
    private final ImporterDelegate myDelegate;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        GradleProjectImporter gradleProjectImporter = (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
        if (gradleProjectImporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getInstance"));
        }
        return gradleProjectImporter;
    }

    public GradleProjectImporter() {
        this.myDelegate = new ImporterDelegate();
    }

    @VisibleForTesting
    GradleProjectImporter(ImporterDelegate delegate) {
        this.myDelegate = delegate;
    }

    public void importProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        VirtualFile projectDir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        File projectDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir);
        try {
            LocalProperties localProperties = new LocalProperties(projectDirPath);
            if (AndroidStudioInitializer.isAndroidStudio()) {
                SdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            LOG.info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            return;
        }
        this.createProjectFileForGradleProject(selectedFile, null);
    }

    private void createProjectFileForGradleProject(@NotNull VirtualFile selectedFile, @Nullable Project project) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProjectFileForGradleProject"));
        }
        final VirtualFile projectDir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        File projectDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir);
        try {
            this.importProject(projectDir.getName(), projectDirPath, true, new NewProjectImportGradleSyncListener(){

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter$1", "syncSucceeded"));
                    }
                    FileChooserUtil.setLastOpenedFile((Project)project, (VirtualFile)projectDir);
                    NewProjects.activateProjectView(project);
                }
            }, project, null);
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            LOG.error((Throwable)e);
        }
    }

    public void requestProjectSync(@NotNull Project project, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        this.requestProjectSync(project, true, listener);
    }

    public void requestProjectSync(@NotNull Project project, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        this.requestProjectSync(project, false, generateSourcesOnSuccess, false, listener);
    }

    public void requestProjectSync(@NotNull Project project, boolean useCachedProjectData, boolean generateSourcesOnSuccess, boolean cleanProject, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        Runnable syncRequest = this.createSyncRequest(project, ProgressExecutionMode.IN_BACKGROUND_ASYNC, generateSourcesOnSuccess, cleanProject, useCachedProjectData, listener);
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)syncRequest);
    }

    public void syncProjectSynchronously(@NotNull Project project, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "syncProjectSynchronously"));
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        Runnable syncRequest = this.createSyncRequest(project, ProgressExecutionMode.MODAL_SYNC, generateSourcesOnSuccess, false, false, listener);
        UIUtil.invokeAndWaitIfNeeded((Runnable)syncRequest);
    }

    @NotNull
    private Runnable createSyncRequest(@NotNull Project project, @NotNull ProgressExecutionMode executionMode, boolean generateSourcesOnSuccess, boolean cleanProject, boolean useCachedProjectData, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createSyncRequest"));
        }
        if (executionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createSyncRequest"));
        }
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$createSyncRequest$0"));
            }
            if (executionMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$createSyncRequest$0"));
            }
            if (GradleProjectImporter.isBuildInProgress(project)) {
                Projects.setSyncRequestedDuringBuild(project, true);
                return;
            }
            try {
                ImportOptions options = new ImportOptions(generateSourcesOnSuccess, cleanProject, false, useCachedProjectData);
                this.doRequestSync(project, executionMode, options, listener);
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createSyncRequest"));
        }
        return runnable;
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        StatusBarEx statusBar;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "isBuildInProgress"));
        }
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task = (TaskInfo)backgroundProcess.getFirst();
            if (!(task instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private void doRequestSync(@NotNull Project project, @NotNull ProgressExecutionMode progressExecutionMode, @NotNull ImportOptions options, @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (Projects.requiresAndroidModel(project) || GradleProjectImporter.hasTopLevelGradleBuildFile(project)) {
            FileDocumentManager.getInstance().saveAllDocuments();
            GradleProjectImporter.setUpGradleSettings(project);
            GradleProjectImporter.resetProject(project);
            Projects.setGradleVersionUsed(project, null);
            this.doImport(project, progressExecutionMode, options, false, listener);
        } else {
            Runnable notificationTask = () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$doRequestSync$1"));
                }
                String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
                AndroidGradleNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
                if (listener != null) {
                    listener.syncFailed(project, msg);
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                notificationTask.run();
            } else {
                application.invokeLater(notificationTask);
            }
        }
    }

    private static boolean hasTopLevelGradleBuildFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "hasTopLevelGradleBuildFile"));
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile gradleBuildFile = baseDir.findChild("build.gradle");
        return gradleBuildFile != null && gradleBuildFile.exists() && !gradleBuildFile.isDirectory();
    }

    private static void resetProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "resetProject"));
        }
        Projects.executeProjectChanges(project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$resetProject$2"));
            }
            LibraryAttachments.removeLibrariesAndStoreAttachments(project);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) continue;
                facet.setAndroidModel(null);
            }
        });
    }

    public void importNewlyCreatedProject(@NotNull String projectName, @NotNull File projectRootDirPath, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importNewlyCreatedProject"));
        }
        if (projectRootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDirPath", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importNewlyCreatedProject"));
        }
        this.doImport(projectName, projectRootDirPath, new ImportOptions(true, false, false, false), listener, project, initialLanguageLevel);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectRootDirPath, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        if (projectRootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDirPath", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        ImportOptions options = new ImportOptions(generateSourcesOnSuccess, false, true, false);
        this.doImport(projectName, projectRootDirPath, options, listener, project, initialLanguageLevel);
    }

    private void doImport(@NotNull String projectName, @NotNull File projectRootDirPath, @NotNull ImportOptions options, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        Project newProject;
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (projectRootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDirPath", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        GradleProjectImporter.createTopLevelBuildFileIfNotExisting(projectRootDirPath);
        NewProjects.createIdeaProjectDir(projectRootDirPath);
        Project project2 = newProject = project == null ? NewProjects.createProject(projectName, projectRootDirPath.getPath()) : project;
        if (project == null) {
            GradleSettings settings = GradleSettings.getInstance((Project)newProject);
            settings.setGradleVmOptions("");
        }
        GradleProjectImporter.setUpProject(newProject, initialLanguageLevel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        this.doImport(newProject, ProgressExecutionMode.MODAL_SYNC, options, true, listener);
    }

    private static void createTopLevelBuildFileIfNotExisting(@NotNull File projectRootDirPath) throws IOException {
        if (projectRootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDirPath", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createTopLevelBuildFileIfNotExisting"));
        }
        File projectFile = GradleUtil.getGradleBuildFilePath(projectRootDirPath);
        if (projectFile.isFile()) {
            return;
        }
        FileUtilRt.createIfNotExists((File)projectFile);
        String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + SystemProperties.getLineSeparator();
        FileUtil.writeToFile((File)projectFile, (String)contents);
    }

    private static void setUpProject(@NotNull Project newProject, @Nullable LanguageLevel initialLanguageLevel) {
        if (newProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProject", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpProject"));
        }
        CommandProcessor.getInstance().executeCommand(newProject, () -> {
            if (newProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProject", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$setUpProject$4"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                LanguageLevelProjectExtension extension;
                if (newProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProject", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$null$3"));
                }
                if (initialLanguageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)newProject)) != null) {
                    extension.setLanguageLevel(initialLanguageLevel);
                }
                File compilerOutputDirPath = new File(Projects.getBaseDirPath(newProject), FileUtil.join((String[])new String[]{"build", "classes"}));
                String compilerOutputDirUrl = FilePaths.pathToIdeaUrl(compilerOutputDirPath);
                CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)newProject);
                assert (compilerProjectExt != null);
                compilerProjectExt.setCompilerOutputUrl(compilerOutputDirUrl);
                GradleProjectImporter.setUpGradleSettings(newProject);
                ProjectTypeService.setProjectType((Project)newProject, (ProjectType)AndroidModuleBuilder.ANDROID_PROJECT_TYPE);
            });
        }, null, null);
    }

    private static void setUpGradleSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            projectSettings = new GradleProjectSettings();
        }
        GradleProjectImporter.setUpGradleProjectSettings(project, projectSettings);
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
        gradleSettings.setLinkedProjectsSettings((Collection)ImmutableList.of((Object)projectSettings));
    }

    private static void setUpGradleProjectSettings(@NotNull Project project, @NotNull GradleProjectSettings settings) {
        String basePath;
        Sdk jdk;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleProjectSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleProjectSettings"));
        }
        settings.setUseAutoImport(false);
        if (ApplicationManager.getApplication().isUnitTestMode() && (jdk = IdeSdks.getJdk()) != null) {
            settings.setGradleJvm(jdk.getName());
        }
        if ((basePath = project.getBasePath()) != null) {
            settings.setExternalProjectPath(basePath);
        }
    }

    private void doImport(@NotNull Project project, @NotNull ProgressExecutionMode progressExecutionMode, @NotNull ImportOptions options, boolean newProject, @Nullable GradleSyncListener listener) throws ConfigurationException {
        DataNode<ProjectData> cache;
        GradleProjectSyncData syncData;
        PreSyncChecks.PreSyncCheckResult preSyncCheckResult;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "lambda$doImport$5"));
            }
            return ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
        });
        if (AndroidStudioInitializer.isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(project);
        }
        if (!(preSyncCheckResult = PreSyncChecks.canSync(project)).isSuccess()) {
            GradleSyncState syncState = GradleSyncState.getInstance(project);
            if (syncState.syncStarted(true)) {
                NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
                String cause = Strings.nullToEmpty((String)preSyncCheckResult.getFailureCause());
                syncState.syncFailed(cause);
                if (listener != null) {
                    listener.syncFailed(project, cause);
                }
            }
            return;
        }
        if (AndroidStudioInitializer.isAndroidStudio() && Projects.isDirectGradleInvocationEnabled(project)) {
            GradleInvoker.getInstance(project).clearConsoleAndBuildMessages();
        }
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
        Projects.setHasSyncErrors(project, false);
        Projects.setHasWrongJdk(project, false);
        if ((GradleProjectImporter.forceSyncWithCachedModel() || options.useCachedProjectData) && (syncData = GradleProjectSyncData.getInstance(project)) != null && syncData.canUseCachedProjectData() && (cache = GradleUtil.getCachedProjectData(project)) != null && !GradleProjectImporter.isCacheMissingModels(cache, project)) {
            PostProjectSetupTasksExecutor executor = PostProjectSetupTasksExecutor.getInstance(project);
            executor.setGenerateSourcesAfterSync(false, false);
            executor.setUsingCachedProjectData(true);
            executor.setLastSyncTimestamp(syncData.getLastGradleSyncTimestamp());
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(project, newProject, options.importingExistingProject, true, listener);
            setUpTask.onSuccess(cache);
            return;
        }
        boolean started = GradleSyncState.getInstance(project).syncStarted(!newProject);
        if (!started) {
            return;
        }
        PostProjectSetupTasksExecutor.getInstance(project).setGenerateSourcesAfterSync(options.generateSourcesOnSuccess, options.cleanProject);
        ProjectSetUpTask setUpTask = new ProjectSetUpTask(project, newProject, options.importingExistingProject, false, listener);
        this.myDelegate.importProject(project, setUpTask, progressExecutionMode);
    }

    private static boolean forceSyncWithCachedModel() {
        if (SYNC_WITH_CACHED_MODEL_ONLY) {
            return true;
        }
        if (AndroidPlugin.isGuiTestingMode()) {
            AndroidPlugin.GuiTestSuiteState state = AndroidPlugin.getGuiTestSuiteState();
            return state.syncWithCachedModelOnly();
        }
        return false;
    }

    @VisibleForTesting
    static boolean isCacheMissingModels(@NotNull DataNode<ProjectData> cache, @NotNull Project project) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/android/tools/idea/gradle/project/GradleProjectImporter", "isCacheMissingModels"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "isCacheMissingModels"));
        }
        Collection moduleDataNodes = ExternalSystemApiUtil.findAll(cache, (Key)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            Map<String, DataNode<ModuleData>> moduleDataNodesByName = GradleProjectImporter.indexByModuleName(moduleDataNodes);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                AndroidGradleFacet gradleFacet;
                DataNode<ModuleData> moduleDataNode = moduleDataNodesByName.get(module.getName());
                if (!(moduleDataNode == null ? (gradleFacet = AndroidGradleFacet.getInstance(module)) != null : GradleProjectImporter.isCacheMissingModels(moduleDataNode, module))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, DataNode<ModuleData>> indexByModuleName(@NotNull Collection<DataNode<ModuleData>> moduleDataNodes) {
        if (moduleDataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataNodes", "com/android/tools/idea/gradle/project/GradleProjectImporter", "indexByModuleName"));
        }
        HashMap mapping = Maps.newHashMap();
        for (DataNode<ModuleData> moduleDataNode : moduleDataNodes) {
            ModuleData data = (ModuleData)moduleDataNode.getData();
            mapping.put(data.getExternalName(), moduleDataNode);
        }
        HashMap hashMap = mapping;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "indexByModuleName"));
        }
        return hashMap;
    }

    private static boolean isCacheMissingModels(@NotNull DataNode<ModuleData> cache, @NotNull Module module) {
        DataNode nativeAndroidGradleDataNode;
        NativeAndroidGradleFacet nativeAndroidFacet;
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/android/tools/idea/gradle/project/GradleProjectImporter", "isCacheMissingModels"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/GradleProjectImporter", "isCacheMissingModels"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null) {
            DataNode javaProjectDataNode;
            JavaGradleFacet javaFacet;
            DataNode androidDataNode;
            DataNode gradleDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.GRADLE_MODEL);
            if (gradleDataNode == null) {
                return true;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null ? (androidDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.ANDROID_MODEL)) == null || !ProxyUtil.isValidProxyObject(((AndroidGradleModel)androidDataNode.getData()).getAndroidProject()) : (javaFacet = JavaGradleFacet.getInstance(module)) != null && (javaProjectDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.JAVA_PROJECT)) == null) {
                return true;
            }
        }
        return (nativeAndroidFacet = NativeAndroidGradleFacet.getInstance(module)) != null && ((nativeAndroidGradleDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.NATIVE_ANDROID_MODEL)) == null || !ProxyUtil.isValidProxyObject(((NativeAndroidGradleModel)nativeAndroidGradleDataNode.getData()).getNativeAndroidProject()));
    }

    private static class ImportOptions {
        final boolean generateSourcesOnSuccess;
        final boolean cleanProject;
        final boolean importingExistingProject;
        final boolean useCachedProjectData;

        ImportOptions(boolean generateSourcesOnSuccess, boolean cleanProject, boolean importingExistingProject, boolean useCachedProjectData) {
            this.generateSourcesOnSuccess = generateSourcesOnSuccess;
            this.cleanProject = cleanProject;
            this.importingExistingProject = importingExistingProject;
            this.useCachedProjectData = useCachedProjectData;
        }
    }

    static class ImporterDelegate {
        ImporterDelegate() {
        }

        void importProject(@NotNull Project project, @NotNull ExternalProjectRefreshCallback callback, @NotNull ProgressExecutionMode progressExecutionMode) throws ConfigurationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            if (progressExecutionMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            try {
                String externalProjectPath = Projects.getBaseDirPath(project).getPath();
                ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (String)externalProjectPath, (ExternalProjectRefreshCallback)callback, (boolean)false, (ProgressExecutionMode)progressExecutionMode, (boolean)true);
            }
            catch (RuntimeException e) {
                String externalSystemName = GradleUtil.GRADLE_SYSTEM_ID.getReadableName();
                throw new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName}));
            }
        }
    }
}

