/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NdkIntegrationDeprecatedErrorHandler
extends AbstractSyncErrorHandler {
    private static final String NDK_INTEGRATION_DEPRECATED = "NDK integration is deprecated in the current plugin.";

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/NdkIntegrationDeprecatedErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/NdkIntegrationDeprecatedErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/NdkIntegrationDeprecatedErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/NdkIntegrationDeprecatedErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        if (firstLine.contains(NDK_INTEGRATION_DEPRECATED)) {
            ArrayList hyperlinks = Lists.newArrayList();
            hyperlinks.add(new OpenUrlHyperlink("http://tools.android.com/tech-docs/new-build-system/gradle-experimental", "Consider trying the new experimental plugin"));
            hyperlinks.add(new SetUseDeprecatedNdkHyperlink());
            NdkIntegrationDeprecatedErrorHandler.updateNotification(notification, project, NDK_INTEGRATION_DEPRECATED, hyperlinks);
            return true;
        }
        return false;
    }

    private static class SetUseDeprecatedNdkHyperlink
    extends NotificationHyperlink {
        public SetUseDeprecatedNdkHyperlink() {
            super("useDeprecatedNdk", "Set \"android.useDeprecatedNdk=true\" in gradle.properties to continue using the current NDK integration");
        }

        @Override
        protected void execute(@NotNull Project project) {
            GradleProperties gradleProperties;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/NdkIntegrationDeprecatedErrorHandler$SetUseDeprecatedNdkHyperlink", "execute"));
            }
            try {
                gradleProperties = new GradleProperties(project);
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Failed to read gradle.properties: " + e.getMessage()), (String)"Quick Fix");
                return;
            }
            gradleProperties.getProperties().setProperty("android.useDeprecatedNdk", "true");
            try {
                gradleProperties.save();
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Failed to update gradle.properties: " + e.getMessage()), (String)"Quick Fix");
                return;
            }
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

