/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.testing;

import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedModules
implements Iterable<Module> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<Module> myExcludedModules;

    ExcludedModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/testing/ExcludedModules", "<init>"));
        }
        this.myExcludedModules = new HashSet();
        this.myProject = module.getProject();
    }

    void add(@NotNull DependencySet dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/testing/ExcludedModules", "add"));
        }
        for (ModuleDependency dependency : dependencies.onModules()) {
            Module dependencyModule = dependency.getModule(this.myProject);
            if (dependencyModule == null) continue;
            this.myExcludedModules.add(dependencyModule);
        }
    }

    void remove(@NotNull DependencySet dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/testing/ExcludedModules", "remove"));
        }
        for (ModuleDependency dependency : dependencies.onModules()) {
            Module dependencyModule = dependency.getModule(this.myProject);
            if (dependencyModule == null) continue;
            this.myExcludedModules.remove(dependencyModule);
        }
    }

    boolean contains(@Nullable Module module) {
        return this.myExcludedModules.contains(module);
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/ExcludedModules", "getProject"));
        }
        return project;
    }

    @Override
    public Iterator<Module> iterator() {
        return this.myExcludedModules.iterator();
    }
}

