/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFileNode
extends PsiFileNode {
    @NotNull
    private final String myModuleName;

    public ExternalBuildFileNode(@NotNull Project project, @NotNull PsiFile value, @NotNull ViewSettings viewSettings, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode", "<init>"));
        }
        super(project, value, viewSettings);
        this.myModuleName = moduleName;
    }

    public void update(PresentationData data) {
        super.update(data);
        String fileName = this.getPsiFileName();
        data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(fileName);
        data.addText(" (" + this.myModuleName + ", " + this.getPsiFilePath() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myModuleName + "-" + this.getPsiFileName() + "-" + this.getPsiFilePath();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getPsiFileName() + " (" + this.myModuleName + ", " + this.getPsiFilePath() + ")";
    }

    @NotNull
    private PsiFile getPsiFile() {
        PsiFile value = (PsiFile)this.getValue();
        assert (value != null);
        PsiFile psiFile = value;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode", "getPsiFile"));
        }
        return psiFile;
    }

    private String getPsiFileName() {
        return this.getPsiFile().getName();
    }

    private String getPsiFilePath() {
        return FileUtil.getLocationRelativeToUserHome((String)this.getPsiFile().getVirtualFile().getPresentableUrl());
    }
}

