/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingInfo
implements ModificationTracker {
    private final Map<DataBindingResourceType, List<PsiDataBindingResourceItem>> myItems = Maps.newEnumMap(DataBindingResourceType.class);
    private String myClassName;
    private String myPackageName;
    private final PsiResourceFile myPsiResourceFile;
    private PsiClass myPsiClass;
    private long myModificationCount;
    private final AndroidFacet myFacet;

    public DataBindingInfo(AndroidFacet facet, PsiResourceFile psiResourceFile, String className, String packageName) {
        this.myFacet = facet;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myPsiResourceFile = psiResourceFile;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    void update(String className, String packageName, long modificationCount) {
        if (StringUtil.equals((CharSequence)this.myClassName, (CharSequence)className) && StringUtil.equals((CharSequence)this.myPackageName, (CharSequence)packageName)) {
            return;
        }
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myModificationCount = modificationCount;
    }

    private boolean addItem(PsiDataBindingResourceItem item) {
        boolean newItem;
        ArrayList items = this.myItems.get(item.getType());
        if (items == null) {
            items = Lists.newArrayList();
            this.myItems.put(item.getType(), items);
        }
        boolean bl = newItem = !items.contains((Object)item);
        if (newItem) {
            items.add(item);
        }
        return newItem;
    }

    public void replaceItems(Iterable<PsiDataBindingResourceItem> items, long modificationCount) {
        boolean changed;
        boolean bl = changed = this.myItems == null;
        if (this.myItems == null) {
            changed = true;
        } else {
            ArrayList removed = Lists.newArrayList();
            for (Map.Entry<DataBindingResourceType, List<PsiDataBindingResourceItem>> entry : this.myItems.entrySet()) {
                for (PsiDataBindingResourceItem item : entry.getValue()) {
                    if (Iterables.contains(items, (Object)((Object)item))) continue;
                    removed.add(item);
                }
                changed |= removed.size() > 0;
                for (PsiDataBindingResourceItem item : removed) {
                    entry.getValue().remove((Object)item);
                }
            }
            for (PsiDataBindingResourceItem item : items) {
                changed = this.addItem(item) | changed;
            }
        }
        if (changed) {
            this.myModificationCount = modificationCount;
        }
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getPackageName() {
        return this.myPackageName;
    }

    public Project getProject() {
        return this.myPsiResourceFile.getPsiFile().getProject();
    }

    public String getQualifiedName() {
        return this.myPackageName + "." + this.myClassName;
    }

    public PsiElement getNavigationElement() {
        return this.myPsiResourceFile.getPsiFile();
    }

    public PsiFile getPsiFile() {
        return this.myPsiResourceFile.getPsiFile();
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @NotNull
    public List<PsiDataBindingResourceItem> getItems(DataBindingResourceType type) {
        List<PsiDataBindingResourceItem> items = this.myItems.get(type);
        List<PsiDataBindingResourceItem> list = items != null ? items : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/DataBindingInfo", "getItems"));
        }
        return list;
    }

    public List<ViewWithId> getViewsWithIds() {
        Collection resourceItems = this.myPsiResourceFile.getItems();
        ArrayList result = Lists.newArrayList();
        for (ResourceItem item : resourceItems) {
            PsiResourceItem psiResourceItem;
            if (!ResourceType.ID.equals((Object)item.getType()) || !(item instanceof PsiResourceItem) || (psiResourceItem = (PsiResourceItem)item).getTag() == null) continue;
            result.add(new ViewWithId(DataBindingUtil.convertToJavaFieldName(item.getName()), psiResourceItem.getTag()));
        }
        return result;
    }

    @Nullable
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiResourceFile.getPsiFile());
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    public static class ViewWithId {
        public final String name;
        public final XmlTag tag;

        public ViewWithId(String name, XmlTag tag) {
            this.name = name;
            this.tag = tag;
        }
    }
}

