/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidLaunchTasksProviderFactory;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.NonGradleApplicationIdProvider;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.tasks.InstantRunNotificationTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.MultiUserUtils;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements RunnerIconProvider {
    private static final Logger LOG = Logger.getInstance(AndroidRunConfigurationBase.class);
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    private static final DialogWrapper.DoNotAskOption ourKillLaunchOption = new MyDoNotPromptOption();
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    public String PREFERRED_AVD = "";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;
    private final ProfilerState myProfilerState = new ProfilerState();
    private final List<DeployTargetProvider> myDeployTargetProviders = DeployTargetProvider.getProviders();
    private final Map<String, DeployTargetState> myDeployTargetStates;
    private final boolean myAndroidTests;
    public String DEBUGGER_TYPE;
    private final Map<String, AndroidDebuggerState> myAndroidDebuggerStates;

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myAndroidTests = androidTests;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider provider : this.myDeployTargetProviders) {
            builder.put((Object)provider.getId(), provider.createState());
        }
        this.myDeployTargetStates = builder.build();
        this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        ImmutableSortedMap.Builder androidDebuggerStateBuilder = ImmutableSortedMap.naturalOrder();
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            androidDebuggerStateBuilder.put((Object)androidDebugger.getId(), androidDebugger.createState());
        }
        this.myAndroidDebuggerStates = androidDebuggerStateBuilder.build();
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        if (topError.isFatal()) {
            throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
        }
        throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
    }

    private List<ValidationError> validate(@Nullable Executor executor) {
        Pair<Boolean, String> result;
        AndroidFacet facet;
        ArrayList errors = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        Project project = module.getProject();
        if (Projects.requiredAndroidModelMissing(project)) {
            errors.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        if (facet.isLibraryProject() && !((Boolean)(result = this.supportsRunningLibraryProjects(facet)).getFirst()).booleanValue()) {
            errors.add(ValidationError.fatal((String)result.getSecond()));
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (facet.getManifest() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors.addAll(this.getCurrentDeployTargetState().validate(facet));
        errors.addAll(this.getApkProvider(facet, this.getApplicationIdProvider(facet)).validate());
        errors.addAll(this.checkConfiguration(facet));
        Object androidDebuggerState = this.getAndroidDebuggerState(this.DEBUGGER_TYPE);
        if (androidDebuggerState != null) {
            errors.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet, executor));
        }
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder = LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getLaunchOptions"));
        }
        return builder;
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            result.add(module);
        }
        return result;
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        TargetSelectionMode targetSelectionMode;
        try {
            targetSelectionMode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            TargetSelectionMode targetSelectionMode2 = TargetSelectionMode.EMULATOR;
            if (targetSelectionMode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getTargetSelectionMode"));
            }
            return targetSelectionMode2;
        }
        if (targetSelectionMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getTargetSelectionMode"));
        }
        return targetSelectionMode;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        ArrayList targets = Lists.newArrayList();
        for (DeployTargetProvider target : this.myDeployTargetProviders) {
            if (!target.isApplicable(this.myAndroidTests)) continue;
            targets.add(target);
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getApplicableDeployTargetProviders"));
        }
        return arrayList;
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        DeployTargetProvider target = this.getDeployTargetProvider(this.TARGET_SELECTION_MODE);
        if (target == null) {
            target = this.getDeployTargetProvider(TargetSelectionMode.SHOW_DIALOG.name());
        }
        assert (target != null);
        DeployTargetProvider deployTargetProvider = target;
        if (deployTargetProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getCurrentDeployTargetProvider"));
        }
        return deployTargetProvider;
    }

    @Nullable
    private DeployTargetProvider getDeployTargetProvider(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeployTargetProvider"));
        }
        for (DeployTargetProvider target : this.myDeployTargetProviders) {
            if (!target.getId().equals(id)) continue;
            return target;
        }
        return null;
    }

    @NotNull
    protected DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(currentTarget.getId());
        if (deployTargetState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getCurrentDeployTargetState"));
        }
        return deployTargetState;
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeployTargetState"));
        }
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(target.getId());
        if (deployTargetState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeployTargetState"));
        }
        return deployTargetState;
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/run/AndroidRunConfigurationBase", "setTargetSelectionMode"));
        }
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/AndroidRunConfigurationBase", "setTargetSelectionMode"));
        }
        this.TARGET_SELECTION_MODE = target.getId();
    }

    @Nullable
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getExecutorIcon"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getExecutorIcon"));
        }
        if (!InstantRunSettings.isInstantRunEnabled() || !this.supportsInstantRun()) {
            return null;
        }
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            return null;
        }
        AndroidSessionInfo info = AndroidSessionInfo.findOldSession(this.getProject(), null, this.getUniqueID());
        if (info == null || !info.isInstantRun() || !info.getExecutorId().equals(executor.getId())) {
            return null;
        }
        AndroidVersion androidVersion = InstantRunManager.getMinDeviceApiLevel(info.getProcessHandler());
        if (InstantRunManager.isInstantRunCapableDeviceVersion(androidVersion) && InstantRunGradleUtils.getIrSupportStatus(InstantRunGradleUtils.getAppModel(module), androidVersion) == InstantRunGradleSupport.SUPPORTED) {
            return executor instanceof DefaultRunExecutor ? AndroidIcons.RunIcons.Replay : AndroidIcons.RunIcons.DebugReattach;
        }
        return null;
    }

    protected void validateBeforeRun(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfigurationBase", "validateBeforeRun"));
        }
        List<ValidationError> errors = this.validate(executor);
        if (errors.isEmpty()) {
            return;
        }
        for (ValidationError error : errors) {
            if (error.getQuickfix() != null && Messages.showYesNoDialog((Project)this.getProject(), (String)(error.getMessage() + " - do you want to fix it?"), (String)"Quick fix", null) == 0) {
                error.getQuickfix().run();
                continue;
            }
            throw new ExecutionException(error.getMessage());
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        String error;
        boolean continueLaunch;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getState"));
        }
        this.validateBeforeRun(executor);
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
        Project project = env.getProject();
        boolean debug = false;
        if (executor instanceof DefaultDebugExecutor) {
            if (!AndroidSdkUtils.activateDdmsIfNecessary(facet.getModule().getProject())) {
                throw new ExecutionException("Unable to obtain debug bridge. Please check if there is a different tool using adb that is active.");
            }
            debug = true;
        }
        DeviceFutures deviceFutures = null;
        AndroidSessionInfo info = AndroidSessionInfo.findOldSession(project, null, this.getUniqueID());
        if (info != null && this.supportsInstantRun()) {
            deviceFutures = AndroidRunConfigurationBase.getFastDeployDevices(executor, facet, info);
            if (InstantRunUtils.isReRun(env)) {
                info.getProcessHandler().destroyProcess();
                info = null;
            }
        }
        if (info != null && deviceFutures == null && !(continueLaunch = this.promptAndKillSession(executor, project, info))) {
            return null;
        }
        if (deviceFutures == null) {
            DeployTarget deployTarget = this.getDeployTarget(executor, env, debug, facet);
            if (deployTarget == null) {
                return null;
            }
            DeployTargetState deployTargetState = this.getCurrentDeployTargetState();
            if (deployTarget.hasCustomRunProfileState(executor)) {
                return deployTarget.getRunProfileState(executor, env, deployTargetState);
            }
            deviceFutures = deployTarget.getDevices(deployTargetState, facet, this.getDeviceCount(debug), debug, this.getUniqueID());
            if (deviceFutures == null) {
                return null;
            }
        }
        if (deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider(facet);
        InstantRunContext instantRunContext = null;
        if (this.supportsInstantRun() && InstantRunSettings.isInstantRunEnabled()) {
            AndroidVersion version;
            String message;
            int result;
            InstantRunGradleSupport gradleSupport = this.canInstantRun(module, deviceFutures.getDevices());
            if (gradleSupport == InstantRunGradleSupport.TARGET_PLATFORM_NOT_INSTALLED && (result = Messages.showYesNoDialog((Project)project, (String)(message = AndroidBundle.message("instant.run.quickfix.missing.platform", SdkVersionInfo.getVersionWithCodename((AndroidVersion)(version = deviceFutures.getDevices().get(0).getVersion())))), (String)"Instant Run", (String)"Install and Continue", (String)"Proceed without Instant Run", (Icon)Messages.getQuestionIcon())) == 0) {
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)DetailsTypes.getPlatformPath((AndroidVersion)version)));
                if (dialog == null) {
                    LOG.warn("Unable to get quick fix wizard to install missing platform required for instant run.");
                } else if (dialog.showAndGet()) {
                    gradleSupport = InstantRunGradleSupport.SUPPORTED;
                }
            }
            if (gradleSupport == InstantRunGradleSupport.SUPPORTED) {
                if (!AndroidEnableAdbServiceAction.isAdbServiceEnabled()) {
                    throw new ExecutionException("Instant Run requires 'Tools | Android | Enable ADB integration' to be enabled.");
                }
                InstantRunUtils.setInstantRunEnabled(env, true);
                instantRunContext = InstantRunGradleUtils.createGradleProjectContext(facet);
            } else {
                InstantRunManager.LOG.warn("Instant Run enabled, but not doing an instant run build since: " + (Object)((Object)gradleSupport));
                String notificationText = gradleSupport.getUserNotification();
                if (notificationText != null) {
                    InstantRunNotificationTask.showNotification(env.getProject(), null, notificationText);
                }
            }
        } else {
            String msg = "Not using instant run for this launch: ";
            msg = InstantRunSettings.isInstantRunEnabled() ? msg + this.getType().getDisplayName() + " does not support instant run" : msg + "instant run is disabled";
            InstantRunManager.LOG.info(msg);
        }
        AndroidRunConfigContext runConfigContext = new AndroidRunConfigContext();
        env.putCopyableUserData(AndroidRunConfigContext.KEY, (Object)runConfigContext);
        runConfigContext.setTargetDevices(deviceFutures);
        runConfigContext.setSameExecutorAsPreviousSession(info != null && executor.getId().equals(info.getExecutorId()));
        runConfigContext.setCleanRerun(InstantRunUtils.isCleanReRun(env));
        env.putCopyableUserData(InstantRunContext.KEY, (Object)instantRunContext);
        if (debug && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet, module.getName())) != null) {
            throw new ExecutionException(error);
        }
        LaunchOptions launchOptions = this.getLaunchOptions().setDebug(debug).build();
        ProcessHandler processHandler = null;
        if (info != null && info.getExecutorId().equals(executor.getId())) {
            processHandler = info.getProcessHandler();
        }
        ApkProvider apkProvider = this.getApkProvider(facet, applicationIdProvider);
        AndroidLaunchTasksProviderFactory providerFactory = new AndroidLaunchTasksProviderFactory(this, env, facet, applicationIdProvider, apkProvider, deviceFutures, launchOptions, processHandler, instantRunContext);
        InstantRunStatsService.get(project).notifyBuildStarted();
        return new AndroidRunState(env, this.getName(), module, applicationIdProvider, this.getConsoleProvider(), deviceFutures, providerFactory, processHandler);
    }

    @Nullable
    private static DeviceFutures getFastDeployDevices(@NotNull Executor executor, @NotNull AndroidFacet facet, @NotNull AndroidSessionInfo info) {
        AndroidVersion version;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getFastDeployDevices"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getFastDeployDevices"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getFastDeployDevices"));
        }
        if (!InstantRunSettings.isInstantRunEnabled()) {
            InstantRunManager.LOG.info("Instant run not enabled in settings");
            return null;
        }
        if (!info.getExecutorId().equals(executor.getId())) {
            String msg = String.format("Cannot Instant Run since old executor (%1$s) doesn't match current executor (%2$s)", info.getExecutorId(), executor.getId());
            InstantRunManager.LOG.info(msg);
            return null;
        }
        List<IDevice> devices = info.getDevices();
        if (devices == null || devices.isEmpty()) {
            InstantRunManager.LOG.info("Cannot Instant Run since we could not locate the devices from the existing launch session");
            return null;
        }
        if (devices.size() > 1) {
            InstantRunManager.LOG.info("Last run was on > 1 device, not reusing devices and prompting again");
            return null;
        }
        AndroidGradleModel model = AndroidGradleModel.get(facet);
        InstantRunGradleSupport status = InstantRunGradleUtils.getIrSupportStatus(model, version = devices.get(0).getVersion());
        if (status != InstantRunGradleSupport.SUPPORTED) {
            InstantRunManager.LOG.info("Cannot Instant Run: " + (Object)((Object)status));
            return null;
        }
        return DeviceFutures.forDevices(devices);
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet, @NotNull String moduleName) {
        if (deviceFutures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFutures", "com/android/tools/idea/run/AndroidRunConfigurationBase", "canDebug"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfigurationBase", "canDebug"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/run/AndroidRunConfigurationBase", "canDebug"));
        }
        for (ListenableFuture<IDevice> future : deviceFutures.get()) {
            IDevice device;
            if (!future.isDone() || LaunchUtils.canDebugAppOnDevice(facet, device = (IDevice)Futures.getUnchecked(future))) continue;
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName, device.getName());
        }
        return null;
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull Executor executor, @NotNull ExecutionEnvironment env, boolean debug, @NotNull AndroidFacet facet) throws ExecutionException {
        DeployTarget deployTarget;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeployTarget"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeployTarget"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeployTarget"));
        }
        DeployTargetProvider currentTargetProvider = this.getCurrentDeployTargetProvider();
        if (currentTargetProvider.requiresRuntimePrompt()) {
            deployTarget = currentTargetProvider.showPrompt(executor, env, facet, this.getDeviceCount(debug), this.myAndroidTests, this.myDeployTargetStates, this.getUniqueID(), LaunchCompatibilityCheckerImpl.create(facet));
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget();
        }
        return deployTarget;
    }

    private boolean promptAndKillSession(@NotNull Executor executor, Project project, AndroidSessionInfo info) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfigurationBase", "promptAndKillSession"));
        }
        String previousExecutor = info.getExecutorId();
        String currentExecutor = executor.getId();
        if (ourKillLaunchOption.isToBeShown()) {
            String noText;
            String msg;
            if (previousExecutor.equals(currentExecutor)) {
                msg = String.format("Restart App?\nThe app is already running. Would you like to kill it and restart the session?", new Object[0]);
                noText = "Cancel";
            } else {
                msg = String.format("To switch from %1$s to %2$s, the app has to restart. Continue?", previousExecutor, currentExecutor);
                noText = "Cancel " + currentExecutor;
            }
            String title = "Launching " + this.getName();
            String yesText = "Restart " + this.getName();
            if (1 == Messages.showYesNoDialog((Project)project, (String)msg, (String)title, (String)yesText, (String)noText, (Icon)AllIcons.General.QuestionDialog, (DialogWrapper.DoNotAskOption)ourKillLaunchOption)) {
                return false;
            }
        }
        LOG.info("Disconnecting existing session of the same launch configuration");
        info.getProcessHandler().detachProcess();
        return true;
    }

    @NotNull
    protected ApplicationIdProvider getApplicationIdProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getApplicationIdProvider"));
        }
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidGradleModel) {
            GradleApplicationIdProvider gradleApplicationIdProvider = new GradleApplicationIdProvider(facet);
            if (gradleApplicationIdProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getApplicationIdProvider"));
            }
            return gradleApplicationIdProvider;
        }
        NonGradleApplicationIdProvider nonGradleApplicationIdProvider = new NonGradleApplicationIdProvider(facet);
        if (nonGradleApplicationIdProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getApplicationIdProvider"));
        }
        return nonGradleApplicationIdProvider;
    }

    @NotNull
    protected abstract ApkProvider getApkProvider(@NotNull AndroidFacet var1, @NotNull ApplicationIdProvider var2);

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider();

    @Nullable
    protected abstract LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, boolean var3, @NotNull LaunchStatus var4);

    public boolean monitorRemoteProcess() {
        return true;
    }

    @NotNull
    public final DeviceCount getDeviceCount(boolean debug) {
        DeviceCount deviceCount = DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
        if (deviceCount == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDeviceCount"));
        }
        return deviceCount;
    }

    protected abstract boolean supportMultipleDevices();

    public boolean supportsInstantRun() {
        return false;
    }

    public int getUserIdFromAmParameters() {
        return 0;
    }

    private InstantRunGradleSupport canInstantRun(@NotNull Module module, @NotNull List<AndroidDevice> targetDevices) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/run/AndroidRunConfigurationBase", "canInstantRun"));
        }
        if (targetDevices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDevices", "com/android/tools/idea/run/AndroidRunConfigurationBase", "canInstantRun"));
        }
        if (targetDevices.size() != 1) {
            return InstantRunGradleSupport.CANNOT_BUILD_FOR_MULTIPLE_DEVICES;
        }
        AndroidDevice device = targetDevices.get(0);
        IDevice targetDevice = MakeBeforeRunTaskProvider.getLaunchedDevice(device);
        if (targetDevice != null && MultiUserUtils.hasMultipleUsers(targetDevice, 200L, TimeUnit.MILLISECONDS, false) && (this.getUserIdFromAmParameters() != 0 || !MultiUserUtils.isCurrentUserThePrimaryUser(targetDevice, 200L, TimeUnit.MILLISECONDS, true))) {
            return InstantRunGradleSupport.CANNOT_DEPLOY_FOR_SECONDARY_USER;
        }
        AndroidVersion version = device.getVersion();
        InstantRunGradleSupport irSupportStatus = InstantRunGradleUtils.getIrSupportStatus(InstantRunGradleUtils.getAppModel(module), version);
        if (irSupportStatus != InstantRunGradleSupport.SUPPORTED) {
            return irSupportStatus;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return InstantRunGradleSupport.SUPPORTED;
        }
        IAndroidTarget[] targets = platform.getSdkData().getTargets();
        for (int i = targets.length - 1; i >= 0; --i) {
            if (!targets[i].isPlatform() || !targets[i].getVersion().equals((Object)version)) continue;
            return InstantRunGradleSupport.SUPPORTED;
        }
        return InstantRunGradleSupport.TARGET_PLATFORM_NOT_INSTALLED;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        for (DeployTargetState deployTargetState : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)deployTargetState, (Element)element);
        }
        for (Map.Entry entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = element.getChild((String)entry.getKey());
            if (optionElement == null) continue;
            ((AndroidDebuggerState)entry.getValue()).readExternal(optionElement);
        }
        Element profilersElement = element.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        for (DeployTargetState deployTargetState : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)deployTargetState, (Element)element);
        }
        for (Map.Entry entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = new Element((String)entry.getKey());
            element.addContent(optionElement);
            ((AndroidDebuggerState)entry.getValue()).writeExternal(optionElement);
        }
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    protected String getDefaultAndroidDebuggerType() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.shouldBeDefault()) continue;
            String string = androidDebugger.getId();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDefaultAndroidDebuggerType"));
            }
            return string;
        }
        if ("Java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getDefaultAndroidDebuggerType"));
        }
        return "Java";
    }

    @NotNull
    public List<AndroidDebugger> getAndroidDebuggers() {
        ArrayList arrayList = Lists.newArrayList((Object[])AndroidDebugger.EP_NAME.getExtensions());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getAndroidDebuggers"));
        }
        return arrayList;
    }

    @Nullable
    public AndroidDebugger getAndroidDebugger() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.getId().equals(this.DEBUGGER_TYPE)) continue;
            return androidDebugger;
        }
        return null;
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState(@NotNull String androidDebuggerId) {
        if (androidDebuggerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidDebuggerId", "com/android/tools/idea/run/AndroidRunConfigurationBase", "getAndroidDebuggerState"));
        }
        AndroidDebuggerState state = this.myAndroidDebuggerStates.get(androidDebuggerId);
        return (T)(state != null ? state : null);
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState() {
        return this.getAndroidDebuggerState(this.DEBUGGER_TYPE);
    }

    public ProfilerState getProfilerState() {
        return this.myProfilerState;
    }

    private static class MyDoNotPromptOption
    implements DialogWrapper.DoNotAskOption {
        public static final String PROMPT_KEY = "android.show.prompt.kill.session";
        private boolean myShow = PropertiesComponent.getInstance().getBoolean("android.show.prompt.kill.session", false);

        private MyDoNotPromptOption() {
        }

        public boolean isToBeShown() {
            return !this.myShow;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            this.myShow = !toBeShown;
            PropertiesComponent.getInstance().setValue(PROMPT_KEY, this.myShow);
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Do not ask again" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase$MyDoNotPromptOption", "getDoNotShowMessage"));
            }
            return "Do not ask again";
        }
    }
}

