/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class SpecificActivityLocator
extends ActivityLocator {
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final String myActivityName;

    public SpecificActivityLocator(@NotNull AndroidFacet facet, @Nullable String activityName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/SpecificActivityLocator", "<init>"));
        }
        this.myFacet = facet;
        this.myActivityName = activityName;
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/SpecificActivityLocator", "getQualifiedActivityName"));
        }
        assert (this.myActivityName != null);
        String string = this.myActivityName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/SpecificActivityLocator", "getQualifiedActivityName"));
        }
        return string;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        DefaultActivityLocator.ActivityWrapper activity;
        Boolean exported;
        Element element;
        if (this.myActivityName == null || this.myActivityName.length() == 0) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.class.not.specified.error", new Object[0]));
        }
        if (SpecificActivityLocator.doesPackageContainMavenProperty(this.myFacet)) {
            return;
        }
        Module module = this.myFacet.getModule();
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass c = JavaExecutionUtil.findMainClass((Project)project, (String)this.myActivityName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        if (c == null || !c.isInheritor(activityClass, true)) {
            element = MergedManifest.get(module).findActivityAlias(this.myActivityName);
            if (element == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("not.activity.subclass.error", this.myActivityName));
            }
        } else {
            element = MergedManifest.get(module).findActivity(ActivityLocatorUtils.getQualifiedActivityName(c));
            if (element == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.not.declared.in.manifest", c.getName()));
            }
        }
        if (!Boolean.TRUE.equals(exported = (activity = DefaultActivityLocator.ActivityWrapper.get(element)).getExported()) && !activity.hasIntentFilter()) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("specific.activity.not.launchable.error", new Object[0]));
        }
    }

    private static boolean doesPackageContainMavenProperty(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/SpecificActivityLocator", "doesPackageContainMavenProperty"));
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        String aPackage = manifest.getPackage().getStringValue();
        return aPackage != null && aPackage.contains("${");
    }
}

