/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.InstantRunConfigurable;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunNotificationProvider;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.actions.RestartActivityAction;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunNotificationTask
implements LaunchTask {
    private static Set<String> ourBrokenForSecondaryUserMessageDisplayed = new HashSet();
    private static final Object LOCK = new Object();
    private final Project myProject;
    private final InstantRunContext myContext;
    private final InstantRunNotificationProvider myNotificationsProvider;
    private final boolean myShowBrokenForSecondaryUserMessage;

    public InstantRunNotificationTask(@NotNull Project project, @NotNull InstantRunContext context, @NotNull InstantRunNotificationProvider provider, boolean showBrokenForSecondaryUserMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "<init>"));
        }
        this.myProject = project;
        this.myContext = context;
        this.myNotificationsProvider = provider;
        this.myShowBrokenForSecondaryUserMessage = showBrokenForSecondaryUserMessage;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Display Instant Run notification" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "getDescription"));
        }
        return "Display Instant Run notification";
    }

    @Override
    public int getDuration() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "perform"));
        }
        if (!InstantRunSettings.isShowNotificationsEnabled()) {
            return true;
        }
        String notificationText = this.myNotificationsProvider.getNotificationText();
        if (notificationText != null) {
            InstantRunNotificationTask.showNotification(this.myProject, this.myContext, notificationText);
        }
        if (this.myShowBrokenForSecondaryUserMessage) {
            boolean show = false;
            Object object = LOCK;
            synchronized (object) {
                if (!ourBrokenForSecondaryUserMessageDisplayed.contains(this.myProject.getLocationHash())) {
                    ourBrokenForSecondaryUserMessageDisplayed.add(this.myProject.getLocationHash());
                    show = true;
                }
            }
            if (show) {
                InstantRunNotificationTask.showIrBrokenForSecondaryUsersNotification(this.myProject);
            }
        }
        return true;
    }

    private static void showIrBrokenForSecondaryUsersNotification(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "showIrBrokenForSecondaryUsersNotification"));
        }
        NotificationListener l = (notification, event) -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "lambda$showIrBrokenForSecondaryUsersNotification$0"));
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = event.getDescription();
            if ("learnmore".equals(description)) {
                BrowserUtil.browse((String)"http://developers.android.com/r/studio-ui/run-with-work-profile.html", (Project)project);
            }
        };
        InstantRunManager.NOTIFICATION_GROUP.createNotification("", AndroidBundle.message("instant.run.notification.ir.broken.for.secondary.user", new Object[0]), NotificationType.INFORMATION, l).notify(project);
    }

    public static void showNotification(@NotNull Project project, @Nullable InstantRunContext context, @NotNull String notificationText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "showNotification"));
        }
        if (notificationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationText", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "showNotification"));
        }
        if (!InstantRunSettings.isShowNotificationsEnabled()) {
            return;
        }
        String message = AndroidBundle.message("instant.run.notification.template", notificationText);
        NotificationListener l = (notification, event) -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/InstantRunNotificationTask", "lambda$showNotification$1"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if (description != null && description.startsWith("http")) {
                    BrowserUtil.browse((String)description, (Project)project);
                } else if ("mute".equals(description)) {
                    InstantRunSettings.setShowStatusNotifications(false);
                } else if ("configure".equals(description)) {
                    InstantRunConfigurable configurable = new InstantRunConfigurable();
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                } else if ("restart".equals(description)) {
                    assert (context != null) : "Notifications that include a restart activity option need to have a valid instant run context";
                    RestartActivityAction.restartActivity(project, context);
                } else if ("learnmore".equals(description)) {
                    BrowserUtil.browse((String)"http://developer.android.com/r/studio-ui/instant-run.html", (Project)project);
                } else if ("updategradle".equals(description)) {
                    InstantRunConfigurable.updateProjectToInstantRunTools(project, null);
                }
            }
        };
        InstantRunManager.NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, l).notify(project);
    }
}

