/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.editor.NlPaletteManager;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.designer.LightToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.AndroidIcons;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewManager
implements ProjectComponent {
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private NlPreviewForm myToolWindowForm;
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady = false;
    private boolean myToolWindowDisposed = false;
    private boolean mySeenEditor;
    private JComponent myPendingShowComponent;
    private HierarchyListener myHierarchyListener;
    private boolean myRenderImmediately;

    public NlPreviewManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.layout.preview", 100, true, null, (Disposable)project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                NlPreviewManager.this.myToolWindowReady = true;
                NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor());
            }
        });
    }

    protected boolean isUseInteractiveSelector() {
        return true;
    }

    protected String getToolWindowId() {
        return AndroidBundle.message("android.layout.preview.tool.window.title", new Object[0]);
    }

    protected void initToolWindow() {
        this.myToolWindowForm = new NlPreviewForm(this);
        final String toolWindowId = this.getToolWindowId();
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(toolWindowId, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AndroidIcons.AndroidPreview);
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){

            public void stateChanged() {
                if (NlPreviewManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)NlPreviewManager.this.myProject).getToolWindow(toolWindowId);
                if (window != null && window.isAvailable()) {
                    boolean visible = window.isVisible();
                    AndroidEditorSettings.getInstance().getGlobalState().setVisible(visible);
                    if (NlPreviewManager.this.myToolWindowForm != null) {
                        if (visible) {
                            NlPreviewManager.this.myToolWindowForm.activate();
                        } else {
                            NlPreviewManager.this.myToolWindowForm.deactivate();
                        }
                    }
                }
            }
        });
        JPanel contentPanel = this.myToolWindowForm.getContentPanel();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)contentPanel, null, false);
        content.setDisposer((Disposable)this.myToolWindowForm);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)contentPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindowForm.setUseInteractiveSelector(this.isUseInteractiveSelector());
    }

    public void projectClosed() {
        if (this.myToolWindowForm != null) {
            Disposer.dispose((Disposable)this.myToolWindowForm);
            NlPaletteManager paletteManager = NlPaletteManager.get(this.myProject);
            String paletteKey = paletteManager.getComponentName();
            LightToolWindow toolWindow = (LightToolWindow)this.myToolWindowForm.getClientProperty(paletteKey);
            if (toolWindow != null) {
                this.myToolWindowForm.putClientProperty(paletteKey, null);
                toolWindow.dispose();
            }
            this.myToolWindowForm = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        NlPaletteManager paletteManager;
        LightToolWindow toolWindow;
        if (this.myToolWindow != null && (toolWindow = (LightToolWindow)this.myToolWindowForm.getClientProperty((paletteManager = NlPaletteManager.get(this.myProject)).getComponentName())) != null && toolWindow.isVisible()) {
            paletteManager.setDesignSurface(toolWindow, designSurface);
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("NlPreviewManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPreviewManager", "getComponentName"));
        }
        return "NlPreviewManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void processFileEditorChange(final @Nullable TextEditor newEditor) {
        if (this.myPendingShowComponent != null) {
            this.myPendingShowComponent.removeHierarchyListener(this.myHierarchyListener);
            this.myPendingShowComponent = null;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        this.myToolWindowUpdateQueue.queue(new Update("update"){

            public void run() {
                Editor activeEditor;
                if (!NlPreviewManager.this.myToolWindowReady || NlPreviewManager.this.myToolWindowDisposed) {
                    return;
                }
                boolean renderImmediately = NlPreviewManager.this.myRenderImmediately;
                NlPreviewManager.this.myRenderImmediately = false;
                Editor editor = activeEditor = newEditor != null ? newEditor.getEditor() : null;
                if (NlPreviewManager.this.myToolWindow == null) {
                    if (activeEditor == null) {
                        return;
                    }
                    if (!activeEditor.getComponent().isShowing()) {
                        if (!NlPreviewManager.this.mySeenEditor) {
                            NlPreviewManager.this.myPendingShowComponent = activeEditor.getComponent();
                            if (NlPreviewManager.this.myHierarchyListener == null) {
                                NlPreviewManager.this.myHierarchyListener = new HierarchyListener(){

                                    @Override
                                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent() == NlPreviewManager.this.myPendingShowComponent && NlPreviewManager.this.myPendingShowComponent.isShowing()) {
                                            NlPreviewManager.this.myPendingShowComponent.removeHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                                            NlPreviewManager.this.mySeenEditor = true;
                                            NlPreviewManager.this.myPendingShowComponent = null;
                                            NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor());
                                        }
                                    }
                                };
                            }
                            NlPreviewManager.this.myPendingShowComponent.addHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                        }
                        return;
                    }
                    NlPreviewManager.this.mySeenEditor = true;
                    NlPreviewManager.this.initToolWindow();
                }
                AndroidEditorSettings settings = AndroidEditorSettings.getInstance();
                boolean hideForNonLayoutFiles = settings.getGlobalState().isHideForNonLayoutFiles();
                if (activeEditor == null) {
                    NlPreviewManager.this.myToolWindowForm.setFile(null);
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)NlPreviewManager.this.myProject).getPsiFile(activeEditor.getDocument());
                NlPreviewManager.this.myToolWindowForm.setFile(psiFile);
                if (psiFile == null) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                NlPreviewManager.this.myToolWindow.setAvailable(true, null);
                boolean visible = AndroidEditorSettings.getInstance().getGlobalState().isVisible();
                if (visible) {
                    RenderResult renderResult;
                    if (!NlPreviewManager.this.myToolWindow.isVisible() && (renderResult = NlPreviewManager.this.myToolWindowForm.getRenderResult()) != null && renderResult.getFile() != psiFile) {
                        NlPreviewManager.this.myToolWindowForm.setRenderResult(RenderResult.createBlank(psiFile, null));
                    }
                    NlPreviewManager.this.myToolWindow.show(null);
                }
            }
        });
    }

    @Nullable
    TextEditor getActiveLayoutXmlEditor() {
        TextEditor textEditor;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (TextEditor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TextEditor>(){

                public TextEditor compute() {
                    return NlPreviewManager.this.getActiveLayoutXmlEditor();
                }
            });
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileEditor[] fileEditors = this.myFileEditorManager.getSelectedEditors();
        if (fileEditors.length > 0 && fileEditors[0] instanceof TextEditor && this.isApplicableEditor(textEditor = (TextEditor)fileEditors[0])) {
            return textEditor;
        }
        return null;
    }

    protected boolean isApplicableEditor(TextEditor textEditor) {
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet == null) {
            return false;
        }
        if (!Projects.isBuildWithGradle(facet.getModule()) && !Projects.isLegacyIdeaAndroidModule(facet.getModule())) {
            return false;
        }
        return NlPreviewManager.isInResourceFolder(psiFile);
    }

    @NotNull
    public NlPreviewForm getPreviewForm() {
        if (this.myToolWindow == null) {
            this.initToolWindow();
        }
        NlPreviewForm nlPreviewForm = this.myToolWindowForm;
        if (nlPreviewForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPreviewManager", "getPreviewForm"));
        }
        return nlPreviewForm;
    }

    private static boolean isInResourceFolder(@Nullable PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            return RenderService.canRender(psiFile);
        }
        return false;
    }

    public static NlPreviewManager getInstance(Project project) {
        return (NlPreviewManager)project.getComponent(NlPreviewManager.class);
    }

    public void notifyFileShown(@NotNull TextEditor editor, boolean renderImmediately) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlPreviewManager", "notifyFileShown"));
        }
        if (renderImmediately) {
            this.myRenderImmediately = true;
        }
        this.processFileEditorChange(editor);
        if (renderImmediately) {
            this.myToolWindowUpdateQueue.sendFlush();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPreviewManager", "getProject"));
        }
        return project;
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener", "fileOpened"));
            }
            NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor());
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener", "fileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener", "fileClosed"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor());
                }
            }, NlPreviewManager.this.myProject.getDisposed());
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            TextEditor textEditor;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener", "selectionChanged"));
            }
            FileEditor newEditor = event.getNewEditor();
            TextEditor layoutXmlEditor = null;
            if (newEditor instanceof TextEditor && NlPreviewManager.this.isApplicableEditor(textEditor = (TextEditor)newEditor)) {
                layoutXmlEditor = textEditor;
            }
            NlPreviewManager.this.processFileEditorChange(layoutXmlEditor);
        }
    }
}

