/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ZoomType;
import com.android.util.PropertiesMap;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(NlModel.class);
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;
    private static final boolean CHECK_MODEL_INTEGRITY = false;
    private static final int RENDER_DELAY_MS = 10;
    private final Set<String> myPendingIds;
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ProjectResourceRepository myProjectResourceRepository;
    private final XmlFile myFile;
    private final ReentrantReadWriteLock myRenderResultLock;
    private final ConfigurationListener myConfigurationListener;
    @GuardedBy(value="myRenderResultLock")
    private RenderResult myRenderResult;
    private Configuration myConfiguration;
    private final List<ModelListener> myListeners;
    private List<NlComponent> myComponents;
    private final SelectionModel mySelectionModel;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Disposable myParent;
    private boolean myActive;
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ModelVersion myModelVersion;
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private static final Object PROGRESS_LOCK = new Object();
    private RenderTask myRenderTask;
    private final NlLayoutType myType;
    private long myConfigurationModificationCount;
    private final Object myRenderingQueueLock;
    private MergingUpdateQueue myRenderingQueue;
    private static final Object RENDERING_LOCK = new Object();
    private static boolean ourRenderViewPort;

    @NotNull
    public static NlModel create(@NotNull DesignSurface surface, @Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull XmlFile file) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/model/NlModel", "create"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/model/NlModel", "create"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlModel", "create"));
        }
        NlModel nlModel = new NlModel(surface, parent, facet, file);
        if (nlModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "create"));
        }
        return nlModel;
    }

    protected NlModel(@NotNull DesignSurface surface, @Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull XmlFile file) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/model/NlModel", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/model/NlModel", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlModel", "<init>"));
        }
        this.myPendingIds = Sets.newHashSet();
        this.myRenderResultLock = new ReentrantReadWriteLock();
        this.myConfigurationListener = new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 6) != 0 && !NlModel.this.mySurface.isCanvasResizing()) {
                    NlModel.this.mySurface.zoom(ZoomType.FIT_INTO);
                }
                return true;
            }
        };
        this.myListeners = Lists.newArrayList();
        this.myComponents = Lists.newArrayList();
        this.myModelVersion = new ModelVersion();
        this.myRenderingQueueLock = new Object();
        this.mySurface = surface;
        this.myParent = parent;
        this.myFacet = facet;
        this.myFile = file;
        this.myConfiguration = facet.getConfigurationManager().getConfiguration(this.myFile.getVirtualFile());
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.mySelectionModel = new SelectionModel();
        this.myId = System.nanoTime() ^ (long)file.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = NlLayoutType.typeOf(file);
        this.myProjectResourceRepository = ProjectResourceRepository.getProjectResources(this.myFacet, true);
    }

    public void activate() {
        if (!this.myActive) {
            this.myActive = true;
            this.myConfiguration.addListener(this.myConfigurationListener);
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myFile.getProject());
            ResourceNotificationManager.ResourceVersion version = manager.addListener(this, this.myFacet, (PsiFile)this.myFile, this.myConfiguration);
            if (!version.equals(this.myRenderedVersion) || this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                String theme = this.myConfiguration.getTheme();
                if (theme != null && !theme.startsWith("@android:style/") && !this.myProjectResourceRepository.hasResourceItem(theme)) {
                    this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
                }
                this.requestModelUpdate();
                this.myModelVersion.myResourceVersion.incrementAndGet();
            }
        }
    }

    public void deactivate() {
        if (this.myActive) {
            this.getRenderingQueue().cancelAllUpdates();
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myFile.getProject());
            manager.removeListener(this, this.myFacet, (PsiFile)this.myFile, this.myConfiguration);
            this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
            this.myConfiguration.removeListener(this.myConfigurationListener);
            this.myActive = false;
        }
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getFile"));
        }
        return xmlFile;
    }

    @NotNull
    public NlLayoutType getType() {
        NlLayoutType nlLayoutType = this.myType;
        if (nlLayoutType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getType"));
        }
        return nlLayoutType;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getSelectionModel"));
        }
        return selectionModel;
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model) {
        this.myLintAnnotationsModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestModelUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            if (this.myCurrentIndicator == null) {
                this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
                this.myCurrentIndicator.start();
            }
        }
        this.getRenderingQueue().queue(new Update("model.update", 10){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DumbService.getInstance((Project)NlModel.this.myFacet.getModule().getProject()).waitForSmartMode();
                if (!NlModel.this.myFacet.getModule().getProject().isDisposed()) {
                    try {
                        if (NlModel.this.myFacet.requiresAndroidModel() && NlModel.this.myFacet.getAndroidModel() == null) {
                            ApplicationManager.getApplication().invokeLater(() -> NlModel.this.requestModelUpdate());
                            return;
                        }
                        NlModel.this.updateModel();
                    }
                    catch (Throwable e) {
                        Logger.getInstance(NlModel.class).error(e);
                    }
                }
                Object object = PROGRESS_LOCK;
                synchronized (object) {
                    if (NlModel.this.myCurrentIndicator != null) {
                        NlModel.this.myCurrentIndicator.stop();
                        NlModel.this.myCurrentIndicator = null;
                    }
                }
            }

            public boolean canEat(Update update) {
                return this.equals(update);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private MergingUpdateQueue getRenderingQueue() {
        Object object = this.myRenderingQueueLock;
        // MONITORENTER : object
        if (this.myRenderingQueue == null) {
            this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 10, true, null, (Disposable)this, null, Alarm.ThreadToUse.OWN_THREAD);
            this.myRenderingQueue.setRestartTimerOnAdd(true);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myRenderingQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getRenderingQueue"));
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inflate(boolean force) {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            return false;
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance(this.myFile.getProject());
        LayoutPullParserFactory.saveFileIfNecessary((PsiFile)this.myFile);
        RenderResult result = null;
        Object object = RENDERING_LOCK;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                return false;
            }
            this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(this.myFacet, (PsiFile)this.myFile, this.myConfiguration);
            RenderService renderService = RenderService.get(this.myFacet);
            RenderLogger logger = renderService.createLogger();
            if (this.myRenderTask != null) {
                this.myRenderTask.dispose();
            }
            this.myRenderTask = renderService.createTask((PsiFile)this.myFile, configuration, logger, this.mySurface);
            if (this.myRenderTask != null) {
                if (!NlModel.isRenderViewPort()) {
                    this.myRenderTask.useDesignMode((PsiFile)this.myFile);
                }
                if ((result = this.myRenderTask.inflate()) == null || !result.getRenderResult().isSuccess()) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                    if (result == null) {
                        result = RenderResult.createBlank((PsiFile)this.myFile, logger);
                    }
                }
            }
            this.myRenderResultLock.writeLock().lock();
            try {
                this.myRenderResult = result;
                this.updateHierarchy(result);
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
            return this.myRenderTask != null;
        }
    }

    @NotNull
    Set<String> getPendingIds() {
        Set<String> set = this.myPendingIds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getPendingIds"));
        }
        return set;
    }

    private void updateHierarchy(@Nullable RenderResult result) {
        if (result == null || !result.getRenderResult().isSuccess()) {
            this.myComponents = Collections.emptyList();
        } else {
            XmlTag rootTag = AndroidPsiUtils.getRootTagSafely(this.myFile);
            List<ViewInfo> rootViews = this.myType == NlLayoutType.MENU ? result.getSystemRootViews() : result.getRootViews();
            this.updateHierarchy(rootTag, rootViews);
        }
        this.myModelVersion.increase(ChangeType.UPDATE_HIERARCHY);
    }

    public void updateHierarchy(@Nullable XmlTag rootTag, @Nullable Iterable<ViewInfo> rootViews) {
        ModelUpdater updater = new ModelUpdater(this);
        updater.update(rootTag, rootViews);
    }

    protected void updateModel() {
        this.inflate(true);
        this.notifyListenersModelUpdateComplete();
    }

    private void checkStructure() {
    }

    private void checkUnique(NlComponent component, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        boolean inflated = this.inflate(false);
        Object object = RENDERING_LOCK;
        synchronized (object) {
            if (this.myRenderTask != null) {
                RenderResult result = this.myRenderTask.render();
                this.myRenderResultLock.writeLock().lock();
                try {
                    this.myRenderResult = result;
                    if (!inflated) {
                        this.updateHierarchy(this.myRenderResult);
                    }
                }
                finally {
                    this.myRenderResultLock.writeLock().unlock();
                }
            }
        }
        this.notifyListenersRenderComplete();
    }

    public void requestRender() {
        this.getRenderingQueue().queue(new Update("model.render", 999){

            public void run() {
                if (NlModel.this.myFacet.getModule().getProject().isDisposed()) {
                    return;
                }
                NlModel.this.render();
            }

            public boolean canEat(Update update) {
                return this.equals(update);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/model/NlModel", "paint"));
        }
        Object object = RENDERING_LOCK;
        synchronized (object) {
            if (this.myRenderTask != null) {
                this.myRenderTask.render(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull ModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/model/NlModel", "addListener"));
        }
        List<ModelListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull ModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/model/NlModel", "removeListener"));
        }
        List<ModelListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersModelUpdateComplete() {
        ImmutableList listeners;
        List<ModelListener> list = this.myListeners;
        synchronized (list) {
            listeners = ImmutableList.copyOf(this.myListeners);
        }
        listeners.forEach(listener -> listener.modelChanged(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersRenderComplete() {
        ImmutableList listeners;
        List<ModelListener> list = this.myListeners;
        synchronized (list) {
            listeners = ImmutableList.copyOf(this.myListeners);
        }
        listeners.forEach(listener -> listener.modelRendered(this));
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, PropertiesMap> map = Collections.emptyMap();
            Map<Object, PropertiesMap> map2 = map;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getDefaultProperties"));
            }
            return map2;
        }
        Map<Object, PropertiesMap> map = this.myRenderResult.getDefaultProperties();
        Map<Object, PropertiesMap> map3 = map;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getDefaultProperties"));
        }
        return map3;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getFacet"));
        }
        return androidFacet;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getModule"));
        }
        return module;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getProject"));
        }
        return project;
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getConfiguration"));
        }
        return configuration;
    }

    public boolean isModuleDependency(@NotNull String artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/uibuilder/model/NlModel", "isModuleDependency"));
        }
        AndroidGradleModel gradleModel = AndroidGradleModel.get(this.myFacet);
        return gradleModel != null && GradleUtil.dependsOn(gradleModel, artifact);
    }

    @Nullable
    public GradleVersion getModuleDependencyVersion(@NotNull String artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/uibuilder/model/NlModel", "getModuleDependencyVersion"));
        }
        AndroidGradleModel gradleModel = AndroidGradleModel.get(this.myFacet);
        return gradleModel != null ? GradleUtil.getModuleDependencyVersion(gradleModel, artifact) : null;
    }

    public void overrideConfigurationScreenSize(int xDimension, int yDimension) {
        State newState;
        VirtualFile better;
        Device original = this.myConfiguration.getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device = deviceBuilder.build();
        for (State state : device.getAllStates()) {
            Screen screen = state.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi = screen.getPixelDensity().getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(AvdScreenData.getScreenSize(diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            screen.setScreenRound(device.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device.getDefaultHardware().getScreen().getChin());
        }
        List<Device> devices = this.myConfiguration.getConfigurationManager().getDevices();
        boolean customDeviceReplaced = false;
        for (int i = 0; i < devices.size(); ++i) {
            if (!"Custom".equals(devices.get(i).getId())) continue;
            devices.set(i, device);
            customDeviceReplaced = true;
            break;
        }
        if (!customDeviceReplaced) {
            devices.add(device);
        }
        if (xDimension > yDimension) {
            better = ConfigurationMatcher.getBetterMatch(this.myConfiguration, device, "Landscape", null, null);
            newState = device.getState("Landscape");
        } else {
            better = ConfigurationMatcher.getBetterMatch(this.myConfiguration, device, "Portrait", null, null);
            newState = device.getState("Portrait");
        }
        if (better != null) {
            VirtualFile old = this.myConfiguration.getFile();
            assert (old != null);
            Project project = this.mySurface.getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, better, -1);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor selectedEditor = manager.getSelectedEditor(old);
            manager.openEditor(descriptor, true);
            if (selectedEditor instanceof NlEditor) {
                manager.setSelectedEditor(better, "android-designer2");
            } else if (selectedEditor != null) {
                manager.setSelectedEditor(better, TextEditorProvider.getInstance().getEditorTypeId());
            }
            AndroidFacet facet = AndroidFacet.getInstance(this.myConfiguration.getModule());
            assert (facet != null);
            Configuration configuration = facet.getConfigurationManager().getConfiguration(better);
            configuration.setEffectiveDevice(device, newState);
        } else {
            this.myConfiguration.setEffectiveDevice(device, newState);
        }
    }

    @NotNull
    public List<NlComponent> getComponents() {
        List<NlComponent> list = this.myComponents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getComponents"));
        }
        return list;
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        Stream<NlComponent> stream = this.myComponents.stream().flatMap(NlComponent::flatten);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "flattenComponents"));
        }
        return stream;
    }

    @Nullable
    public List<NlComponent> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, XmlTag.class, (boolean)false);
        return tag != null ? this.findViewsByTag(tag) : null;
    }

    @Nullable
    public NlComponent findLeafAt(int x, int y, boolean useRootOutsideBounds) {
        for (int i = this.myComponents.size() - 1; i >= 0; --i) {
            NlComponent component = this.myComponents.get(i);
            NlComponent leaf = component.findLeafAt(x, y);
            if (leaf == null) continue;
            return leaf;
        }
        if (useRootOutsideBounds) {
            List<NlComponent> components = this.myComponents;
            if (components.size() == 1) {
                return components.get(0);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlModel", "findViewByTag"));
        }
        for (NlComponent component : this.myComponents) {
            NlComponent match = component.findViewByTag(tag);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    @Nullable
    private List<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlModel", "findViewsByTag"));
        }
        List<NlComponent> result = null;
        for (NlComponent view : this.myComponents) {
            List<NlComponent> matches = view.findViewsByTag(tag);
            if (matches == null) continue;
            if (result != null) {
                result.addAll(matches);
                continue;
            }
            result = matches;
        }
        return result;
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element != null) {
            if (element instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public List<NlComponent> findWithin(int x, int y, int width, int height) {
        ArrayList within = Lists.newArrayList();
        for (NlComponent component : this.myComponents) {
            NlModel.addWithin(within, component, x, y, width, height);
        }
        return within;
    }

    private static boolean addWithin(@NotNull List<NlComponent> result, @NotNull NlComponent component, int x, int y, int width, int height) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/model/NlModel", "addWithin"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlModel", "addWithin"));
        }
        if (component.x + component.w <= x || x + width <= component.x || component.y + component.h <= y || y + height <= component.y) {
            return false;
        }
        boolean found = false;
        for (NlComponent child : component.getChildren()) {
            found |= NlModel.addWithin(result, child, x, y, width, height);
        }
        if (!found) {
            result.add(component);
        }
        return true;
    }

    public void delete(final Collection<NlComponent> components) {
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(this.myFacet.getModule().getProject(), "Delete Component", new PsiFile[]{this.myFile}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/model/NlModel$4", "run"));
                }
                NlModel.this.handleDeletion(components);
            }
        };
        action.execute();
        ArrayList remaining = Lists.newArrayList(this.mySelectionModel.getSelection());
        remaining.removeAll(components);
        this.mySelectionModel.setSelection(remaining);
        this.notifyModified(ChangeType.DELETE);
    }

    private void handleDeletion(@NotNull Collection<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/model/NlModel", "handleDeletion"));
        }
        Map<NlComponent, List<NlComponent>> siblingLists = NlModel.groupSiblings(components);
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(this.myFacet);
        for (Map.Entry<NlComponent, List<NlComponent>> entry : siblingLists.entrySet()) {
            NlComponent parent = entry.getKey();
            if (parent == null) continue;
            List<NlComponent> children = entry.getValue();
            boolean finished = false;
            ViewHandler handler = viewHandlerManager.getHandler(parent);
            if (handler instanceof ViewGroupHandler) {
                finished = ((ViewGroupHandler)handler).deleteChildren(parent, children);
            }
            if (finished) continue;
            for (NlComponent component : children) {
                NlComponent p = component.getParent();
                if (p != null) {
                    p.removeChild(component);
                }
                component.getTag().delete();
            }
        }
    }

    @NotNull
    public static Map<NlComponent, List<NlComponent>> groupSiblings(@NotNull Collection<? extends NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/model/NlModel", "groupSiblings"));
        }
        HashMap<NlComponent, List<NlComponent>> siblingLists = new HashMap<NlComponent, List<NlComponent>>();
        if (components.isEmpty()) {
            HashMap<NlComponent, List<NlComponent>> hashMap = siblingLists;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "groupSiblings"));
            }
            return hashMap;
        }
        if (components.size() == 1) {
            NlComponent component = components.iterator().next();
            siblingLists.put(component.getParent(), Collections.singletonList(component));
            HashMap<NlComponent, List<NlComponent>> hashMap = siblingLists;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "groupSiblings"));
            }
            return hashMap;
        }
        for (NlComponent nlComponent : components) {
            NlComponent parent = nlComponent.getParent();
            ArrayList<NlComponent> children = (ArrayList<NlComponent>)siblingLists.get(parent);
            if (children == null) {
                children = new ArrayList<NlComponent>();
                siblingLists.put(parent, children);
            }
            children.add(nlComponent);
        }
        HashMap<NlComponent, List<NlComponent>> hashMap = siblingLists;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "groupSiblings"));
        }
        return hashMap;
    }

    public NlComponent createComponent(@Nullable ScreenView screenView, @NotNull String fqcn, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        XmlTag tag;
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/uibuilder/model/NlModel", "createComponent"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/model/NlModel", "createComponent"));
        }
        String tagName = NlComponent.viewClassToTag(fqcn);
        if (parent != null) {
            tag = parent.getTag().createChildTag(tagName, null, null, false);
        } else {
            XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)this.getProject());
            String text = "<" + fqcn + " xmlns:android=\"http://schemas.android.com/apk/res/android\"/>";
            tag = elementFactory.createTagFromText((CharSequence)text);
        }
        return this.createComponent(screenView, tag, parent, before, insertType);
    }

    public NlComponent createComponent(@Nullable ScreenView screenView, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        ViewHandler parentHandler;
        ViewEditorImpl editor;
        boolean ok;
        ViewHandlerManager viewHandlerManager;
        ViewHandler childHandler;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlModel", "createComponent"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/model/NlModel", "createComponent"));
        }
        if (parent != null) {
            XmlTag parentTag = parent.getTag();
            tag = before != null ? (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTag()) : parentTag.addSubTag(tag, false);
            if (tag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android") == null) {
                tag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
            if (tag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android") == null) {
                tag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
        } else {
            if (tag.getAttribute("android:layout_width") == null) {
                tag.setAttribute("android:layout_width", "wrap_content");
            }
            if (tag.getAttribute("android:layout_height") == null) {
                tag.setAttribute("android:layout_height", "wrap_content");
            }
        }
        NlComponent child = new NlComponent(this, tag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        if ((childHandler = (viewHandlerManager = ViewHandlerManager.get(this.getProject())).getHandler(child)) != null && screenView != null && !(ok = childHandler.onCreate(editor = new ViewEditorImpl(screenView), parent, child, insertType))) {
            if (parent != null) {
                parent.removeChild(child);
            }
            tag.delete();
            return null;
        }
        if (parent != null && (parentHandler = viewHandlerManager.getHandler(parent)) instanceof ViewGroupHandler) {
            ((ViewGroupHandler)parentHandler).onChildInserted(parent, child, insertType);
        }
        return child;
    }

    @NotNull
    public Transferable getSelectionAsTransferable() {
        Transferable transferable = this.mySelectionModel.getTransferable(this.myId);
        if (transferable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "getSelectionAsTransferable"));
        }
        return transferable;
    }

    public boolean canAddComponents(@Nullable List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/android/tools/idea/uibuilder/model/NlModel", "canAddComponents"));
        }
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        ViewHandler parentHandler = receiver.getViewHandler();
        if (!(parentHandler instanceof ViewGroupHandler)) {
            return false;
        }
        ViewGroupHandler groupHandler = (ViewGroupHandler)parentHandler;
        if (toAdd == null || toAdd.isEmpty()) {
            return false;
        }
        for (NlComponent component : toAdd) {
            if (!groupHandler.acceptsChild(receiver, component)) {
                return false;
            }
            ViewHandler handler = ViewHandlerManager.get(this.getProject()).getHandler(component);
            if (handler != null && !handler.acceptsParent(receiver, component)) {
                return false;
            }
            for (NlComponent same = receiver; same != null; same = same.getParent()) {
                if (same != component) continue;
                return false;
            }
        }
        return true;
    }

    public void addComponents(final @Nullable List<NlComponent> toAdd, final @NotNull NlComponent receiver, final @Nullable NlComponent before, final @NotNull InsertType insertType) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/android/tools/idea/uibuilder/model/NlModel", "addComponents"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/model/NlModel", "addComponents"));
        }
        if (!this.canAddComponents(toAdd, receiver, before)) {
            return;
        }
        assert (toAdd != null);
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(this.getProject(), insertType.getDragType().getDescription(), new PsiFile[]{this.myFile}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/model/NlModel$5", "run"));
                }
                NlModel.this.handleAddition(toAdd, receiver, before, insertType);
            }
        };
        action.execute();
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (added == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "com/android/tools/idea/uibuilder/model/NlModel", "handleAddition"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/android/tools/idea/uibuilder/model/NlModel", "handleAddition"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/model/NlModel", "handleAddition"));
        }
        HashSet ids = Sets.newHashSet(NlComponent.getIds(this));
        ViewGroupHandler groupHandler = (ViewGroupHandler)receiver.getViewHandler();
        assert (groupHandler != null);
        for (NlComponent component : added) {
            if (insertType.isMove()) {
                InsertType insertType2 = insertType = component.getParent() == receiver ? InsertType.MOVE_WITHIN : InsertType.MOVE_INTO;
            }
            if (component.needsDefaultId() && (StringUtil.isEmpty((String)component.getId()) || !insertType.isMove())) {
                ids.add(NlComponent.assignId(component, ids));
            }
            groupHandler.onChildInserted(receiver, component, insertType);
            NlComponent parent = component.getParent();
            if (parent != null) {
                parent.removeChild(component);
            }
            receiver.addChild(component, before);
            if (receiver.getTag() != component.getTag()) {
                XmlTag prev = component.getTag();
                this.transferNamespaces(prev);
                if (before != null) {
                    component.setTag((XmlTag)receiver.getTag().addBefore((PsiElement)component.getTag(), (PsiElement)before.getTag()));
                } else {
                    component.setTag(receiver.getTag().addSubTag(component.getTag(), false));
                }
                if (insertType.isMove()) {
                    prev.delete();
                }
            }
            NlModel.removeNamespaceAttributes(component);
        }
    }

    private void transferNamespaces(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlModel", "transferNamespaces"));
        }
        XmlDocument xmlDocument = this.myFile.getDocument();
        assert (xmlDocument != null);
        XmlTag rootTag = xmlDocument.getRootTag();
        assert (rootTag != null);
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put(entry.getValue(), entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                String newPrefix = AndroidResourceUtil.ensureNamespaceImported(this.myFile, namespace, prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlModel.updatePrefixes(tag, oldPrefixToPrefix);
        }
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlModel", "updatePrefixes"));
        }
        if (oldPrefixToPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPrefixToPrefix", "com/android/tools/idea/uibuilder/model/NlModel", "updatePrefixes"));
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ':' + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlModel.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private static void removeNamespaceAttributes(NlComponent component) {
        for (XmlAttribute attribute : component.getTag().getAttributes()) {
            if (!attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
    }

    @Nullable
    public static DnDTransferItem getTransferItem(@NotNull Transferable transferable, boolean allowPlaceholder) {
        if (transferable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferable", "com/android/tools/idea/uibuilder/model/NlModel", "getTransferItem"));
        }
        DnDTransferItem item = null;
        try {
            String xml;
            if (transferable.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
                item = (DnDTransferItem)transferable.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && !StringUtil.isEmpty((String)(xml = (String)transferable.getTransferData(DataFlavor.stringFlavor)))) {
                item = new DnDTransferItem(new DnDTransferComponent("", xml, 200, 100));
            }
        }
        catch (InvalidDnDOperationException ex) {
            if (!allowPlaceholder) {
                return null;
            }
            String defaultXml = "<placeholder xmlns:android=\"http://schemas.android.com/apk/res/android\"/>";
            item = new DnDTransferItem(new DnDTransferComponent("", defaultXml, 200, 100));
        }
        catch (UnsupportedFlavorException | IOException ex) {
            LOG.warn((Throwable)ex);
        }
        return item;
    }

    @Nullable
    public List<NlComponent> createComponents(@NotNull ScreenView screenView, @NotNull DnDTransferItem item, @NotNull InsertType insertType) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/model/NlModel", "createComponents"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/model/NlModel", "createComponents"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/model/NlModel", "createComponents"));
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            XmlTag tag = NlModel.createTagFromTransferItem(screenView, dndComponent.getRepresentation());
            NlComponent component = this.createComponent(screenView, tag, null, null, insertType);
            if (component == null) {
                return null;
            }
            component.w = dndComponent.getWidth();
            component.h = dndComponent.getHeight();
            components.add(component);
        }
        return components;
    }

    @NotNull
    private static XmlTag createTagFromTransferItem(@NotNull ScreenView screenView, @NotNull String text) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/model/NlModel", "createTagFromTransferItem"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/uibuilder/model/NlModel", "createTagFromTransferItem"));
        }
        NlModel model = screenView.getModel();
        Project project = model.getFacet().getModule().getProject();
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        XmlTag tag = null;
        if (XmlUtils.parseDocumentSilently((String)text, (boolean)false) != null) {
            try {
                String xml = NlModel.addAndroidNamespaceIfMissing(text);
                tag = elementFactory.createTagFromText((CharSequence)xml);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (tag == null) {
            tag = elementFactory.createTagFromText((CharSequence)("<TextView xmlns:android=\"http://schemas.android.com/apk/res/android\"  android:text=\"" + XmlUtils.toXmlAttributeValue((String)text) + "\" android:layout_width=\"wrap_content\" android:layout_height=\"wrap_content\"/>"));
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "createTagFromTransferItem"));
        }
        return xmlTag;
    }

    private static String addAndroidNamespaceIfMissing(@NotNull String xml) {
        int index;
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/uibuilder/model/NlModel", "addAndroidNamespaceIfMissing"));
        }
        if (!xml.contains("http://schemas.android.com/apk/res/android") && (index = xml.indexOf(60)) != -1) {
            if ((index = xml.indexOf(32, index)) == -1 && (index = xml.indexOf("/>")) == -1) {
                index = xml.indexOf(62);
            }
            if (index != -1) {
                xml = xml.substring(0, index) + " xmlns:android=\"http://schemas.android.com/apk/res/android\"" + xml.substring(index);
            }
        }
        return xml;
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (dragType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragType", "com/android/tools/idea/uibuilder/model/NlModel", "determineInsertType"));
        }
        if (item != null && item.isFromPalette()) {
            InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            if (insertType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "determineInsertType"));
            }
            return insertType;
        }
        switch (dragType) {
            case CREATE: {
                InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
                if (insertType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "determineInsertType"));
                }
                return insertType;
            }
            case MOVE: {
                InsertType insertType = item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
                if (insertType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "determineInsertType"));
                }
                return insertType;
            }
            case COPY: {
                InsertType insertType = InsertType.COPY;
                if (insertType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "determineInsertType"));
                }
                return insertType;
            }
        }
        InsertType insertType = InsertType.PASTE;
        if (insertType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel", "determineInsertType"));
        }
        return insertType;
    }

    public void dispose() {
        this.deactivate();
        ApplicationManager.getApplication().invokeLater(() -> {
            Object object = RENDERING_LOCK;
            synchronized (object) {
                if (this.myRenderTask != null) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                }
                this.myRenderResult = null;
            }
        });
    }

    public String toString() {
        return NlModel.class.getSimpleName() + " for " + this.myFile;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/uibuilder/model/NlModel", "resourcesChanged"));
        }
        block4: for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModified(ChangeType.RESOURCE_EDIT);
                    continue block4;
                }
                case EDIT: {
                    this.notifyModified(ChangeType.EDIT);
                    continue block4;
                }
            }
            this.notifyModified(ChangeType.RESOURCE_CHANGED);
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getResourceVersion() {
        return this.myModelVersion.getResourceVersion();
    }

    public void notifyModified(ChangeType reason) {
        String theme = this.myConfiguration.getTheme();
        if (theme != null && !theme.startsWith("@android:style/") && !this.myProjectResourceRepository.hasResourceItem(theme)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
        this.myModelVersion.increase(reason);
        this.requestModelUpdate();
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/uibuilder/model/NlModel", "setConfiguration"));
        }
        this.myConfiguration = configuration;
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myFile.getProject());
        ResourceNotificationManager.ResourceVersion version = manager.addListener(this, this.myFacet, (PsiFile)this.myFile, this.myConfiguration);
        if (!version.equals(this.myRenderedVersion)) {
            this.requestModelUpdate();
            this.myModelVersion.myResourceVersion.incrementAndGet();
        }
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
    }

    private /* synthetic */ void lambda$checkStructure$0() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.myFile.getRootTag(), uniqueTags);
        uniqueTags.clear();
        for (NlComponent component : this.myComponents) {
            this.checkUnique(component.getTag(), uniqueTags);
            this.checkUnique(component, unique);
        }
        for (NlComponent component : this.myComponents) {
            this.checkStructure(component);
        }
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer = UIUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            NlModel.this.mySurface.registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> NlModel.this.mySurface.unregisterIndicator((ProgressIndicator)this));
            }
        }
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        private final AtomicLong myResourceVersion = new AtomicLong();
        private final AtomicLong myHierarchyVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
            switch (reason) {
                case RESOURCE_EDIT: 
                case EDIT: 
                case RESOURCE_CHANGED: 
                case DELETE: 
                case RESIZE_END: 
                case RESIZE_COMMIT: 
                case ADD_COMPONENTS: {
                    this.myResourceVersion.incrementAndGet();
                    break;
                }
                default: {
                    this.myHierarchyVersion.incrementAndGet();
                }
            }
        }

        public long getVersion() {
            return this.myVersion.get();
        }

        public long getResourceVersion() {
            return this.myResourceVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        REQUEST_RENDER,
        UPDATE_HIERARCHY;

    }

    private static class ModelUpdater {
        private final NlModel myModel;
        private final Map<XmlTag, NlComponent> myTagToComponentMap;
        private final Map<NlComponent, XmlTag> myComponentToTagMap;
        private final Map<TagSnapshot, NlComponent> mySnapshotToComponent;
        private final Map<XmlTag, TagSnapshot> myTagToSnapshot;

        public ModelUpdater(@NotNull NlModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/model/NlModel$ModelUpdater", "<init>"));
            }
            this.myTagToComponentMap = Maps.newIdentityHashMap();
            this.myComponentToTagMap = Maps.newIdentityHashMap();
            this.mySnapshotToComponent = Maps.newIdentityHashMap();
            this.myTagToSnapshot = Maps.newHashMap();
            this.myModel = model;
        }

        private void recordComponentMapping(@NotNull XmlTag tag, @NotNull NlComponent component) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlModel$ModelUpdater", "recordComponentMapping"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlModel$ModelUpdater", "recordComponentMapping"));
            }
            XmlTag prevTag = this.myComponentToTagMap.get(component);
            if (prevTag != null) {
                this.myTagToComponentMap.remove(prevTag);
            }
            this.myComponentToTagMap.put(component, tag);
            this.myTagToComponentMap.put(tag, component);
        }

        public void update(@Nullable XmlTag newRoot, @Nullable Iterable<ViewInfo> rootViews) {
            if (newRoot == null) {
                this.myModel.myComponents = Collections.emptyList();
                return;
            }
            if (rootViews != null) {
                for (ViewInfo rootView : rootViews) {
                    ModelUpdater.gatherTagsAndSnapshots(rootView, this.myTagToSnapshot);
                }
            }
            NlComponent root = (NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
                this.mapOldToNew(newRoot);
                for (Map.Entry<XmlTag, NlComponent> entry : this.myTagToComponentMap.entrySet()) {
                    XmlTag tag = entry.getKey();
                    NlComponent component = entry.getValue();
                    if (component.getTagName().equals(tag.getName())) continue;
                    this.myTagToComponentMap.clear();
                    this.myComponentToTagMap.clear();
                    break;
                }
                return this.createTree(newRoot);
            });
            this.myModel.myComponents = Collections.singletonList(root);
            for (NlComponent component : this.myTagToComponentMap.values()) {
                component.setBounds(0, 0, -1, -1);
                component.viewInfo = null;
                component.setSnapshot(null);
            }
            if (rootViews != null) {
                for (ViewInfo view : rootViews) {
                    this.updateHierarchy(view, 0, 0);
                }
            }
            ModelUpdater.fixBounds(root);
        }

        private static void fixBounds(NlComponent root) {
            List<NlComponent> children;
            boolean computeBounds = false;
            if (root.w == -1 && root.h == -1) {
                computeBounds = true;
                NlComponent parent = root.getParent();
                if (parent != null && parent.w >= 0) {
                    root.setBounds(parent.x, parent.y, 0, 0);
                }
            }
            if ((children = root.children) != null && !children.isEmpty()) {
                for (NlComponent child : children) {
                    ModelUpdater.fixBounds(child);
                }
                if (computeBounds) {
                    Rectangle rectangle = new Rectangle(root.x, root.y, root.w, root.h);
                    for (NlComponent child : children) {
                        rectangle = rectangle.union(new Rectangle(child.x, child.y, child.w, child.h));
                    }
                    root.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    root.setBoundsComputed(true);
                }
            }
        }

        private void mapOldToNew(@NotNull XmlTag newRootTag) {
            XmlTag oldTag;
            TagSnapshot snapshot;
            NlComponent component;
            if (newRootTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRootTag", "com/android/tools/idea/uibuilder/model/NlModel$ModelUpdater", "mapOldToNew"));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (NlComponent component2 : this.myModel.myComponents) {
                this.gatherTagsAndSnapshots(component2);
            }
            ArrayList missing = Lists.newArrayList();
            Set remaining = Sets.newIdentityHashSet();
            remaining.addAll(this.myTagToComponentMap.keySet());
            ModelUpdater.checkMissing(newRootTag, remaining, missing);
            if (missing.isEmpty()) {
                return;
            }
            if (remaining.isEmpty()) {
                return;
            }
            HashMap oldIds = Maps.newHashMap();
            for (Map.Entry<TagSnapshot, NlComponent> entry : this.mySnapshotToComponent.entrySet()) {
                String id;
                TagSnapshot snapshot2 = entry.getKey();
                if (snapshot2 == null || (id = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
                oldIds.put(id, entry.getValue());
            }
            ListIterator missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                XmlTag tag = (XmlTag)missingIterator.next();
                String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                if (id == null || (component = (NlComponent)oldIds.get(id)) == null) continue;
                this.recordComponentMapping(tag, component);
                remaining.remove(component.getTag());
                missingIterator.remove();
            }
            if (missing.isEmpty() || remaining.isEmpty()) {
                return;
            }
            ArrayListMultimap snapshotIds = ArrayListMultimap.create();
            for (XmlTag old : remaining) {
                NlComponent component3 = this.myTagToComponentMap.get(old);
                if (component3 == null || (snapshot = component3.getSnapshot()) == null) continue;
                snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
            }
            missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                TagSnapshot first;
                NlComponent component4;
                long signature;
                Collection snapshots;
                XmlTag tag = (XmlTag)missingIterator.next();
                TagSnapshot snapshot3 = this.myTagToSnapshot.get(tag);
                if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component4 = this.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
                this.recordComponentMapping(tag, component4);
                remaining.remove(component4.getTag());
                snapshotIds.remove((Object)tag, (Object)first);
                missingIterator.remove();
            }
            if (missing.size() == 1 && remaining.size() == 1 && (component = this.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
                XmlTag newTag = (XmlTag)missing.get(0);
                snapshot = component.getSnapshot();
                if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                    this.recordComponentMapping(newTag, component);
                }
            }
        }

        private static void checkMissing(XmlTag tag, Set<XmlTag> remaining, List<XmlTag> missing) {
            boolean found = remaining.remove(tag);
            if (!found) {
                missing.add(tag);
            }
            for (XmlTag child : tag.getSubTags()) {
                ModelUpdater.checkMissing(child, remaining, missing);
            }
        }

        private void gatherTagsAndSnapshots(@NotNull NlComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlModel$ModelUpdater", "gatherTagsAndSnapshots"));
            }
            XmlTag tag = component.getTag();
            this.recordComponentMapping(tag, component);
            this.mySnapshotToComponent.put(component.getSnapshot(), component);
            for (NlComponent child : component.getChildren()) {
                this.gatherTagsAndSnapshots(child);
            }
        }

        private static void gatherTagsAndSnapshots(ViewInfo view, Map<XmlTag, TagSnapshot> map) {
            Object cookie = view.getCookie();
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                map.put(snapshot.tag, snapshot);
            }
            for (ViewInfo child : view.getChildren()) {
                ModelUpdater.gatherTagsAndSnapshots(child, map);
            }
        }

        @NotNull
        private NlComponent createTree(XmlTag tag) {
            XmlTag[] subTags;
            NlComponent component = this.myTagToComponentMap.get(tag);
            if (component == null) {
                component = new NlComponent(this.myModel, tag);
                this.recordComponentMapping(tag, component);
            }
            if ((subTags = tag.getSubTags()).length > 0) {
                ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
                for (XmlTag subtag : subTags) {
                    NlComponent child = this.createTree(subtag);
                    children.add(child);
                }
                component.setChildren(children);
            } else {
                component.setChildren(null);
            }
            NlComponent nlComponent = component;
            if (nlComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlModel$ModelUpdater", "createTree"));
            }
            return nlComponent;
        }

        private void updateHierarchy(ViewInfo view, int parentX, int parentY) {
            ViewInfo bounds = RenderService.getSafeBounds(view);
            Object cookie = view.getCookie();
            NlComponent component = null;
            if (cookie != null) {
                if (cookie instanceof MergeCookie) {
                    cookie = ((MergeCookie)cookie).getCookie();
                }
                if (cookie instanceof TagSnapshot) {
                    TagSnapshot snapshot = (TagSnapshot)cookie;
                    component = this.mySnapshotToComponent.get(snapshot);
                    if (component == null) {
                        component = this.myTagToComponentMap.get(snapshot.tag);
                        if (component != null) {
                            component.setSnapshot(snapshot);
                            assert (snapshot.tag != null);
                            component.setTag(snapshot.tag);
                        }
                    } else {
                        component.setSnapshot(snapshot);
                        assert (snapshot.tag != null);
                        component.setTag(snapshot.tag);
                    }
                }
            }
            if (component != null) {
                component.viewInfo = view;
                int left = parentX + bounds.getLeft();
                int top = parentY + bounds.getTop();
                int width = bounds.getRight() - bounds.getLeft();
                int height = bounds.getBottom() - bounds.getTop();
                component.setBounds(left, top, Math.max(width, 1), Math.max(height, 1));
            }
            parentX += bounds.getLeft();
            parentY += bounds.getTop();
            for (ViewInfo child : view.getChildren()) {
                this.updateHierarchy(child, parentX, parentY);
            }
        }
    }
}

