/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.google.common.collect.Lists;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String DEBUGGABLE_PROCESS_PROPERTY = "DEBUGGABLE_PROCESS";
    @NonNls
    private static final String SHOW_ALL_PROCESSES_PROPERTY = "SHOW_ALL_PROCESSES";
    @NonNls
    private static final String DEBUGGABLE_DEVICE_PROPERTY = "DEBUGGABLE_DEVICE";
    @NonNls
    private static final String DEBUGGER_ID_PROPERTY = "DEBUGGER_ID";
    private final Project myProject;
    private final boolean myShowDebuggerSelection;
    private JPanel myContentPanel;
    private Tree myProcessTree;
    private JBCheckBox myShowAllProcessesCheckBox;
    private JComboBox myDebuggerTypeCombo;
    private JLabel myDebuggerLabel;
    private String myLastSelectedDevice;
    private String myLastSelectedProcess;
    private final MergingUpdateQueue myUpdatesQueue;
    private final AndroidDebugBridge.IClientChangeListener myClientChangeListener;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceChangeListener;
    private Client mySelectedClient;
    private AndroidDebugger myAndroidDebugger;

    public AndroidProcessChooserDialog(@NotNull Project project, boolean showDebuggerSelection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Choose Process");
        this.myShowDebuggerSelection = showDebuggerSelection;
        this.myProject = project;
        this.myUpdatesQueue = new MergingUpdateQueue("AndroidProcessChooserDialogUpdatingQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, this.getDisposable());
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        this.myLastSelectedProcess = properties.getValue(DEBUGGABLE_PROCESS_PROPERTY);
        this.myLastSelectedDevice = properties.getValue(DEBUGGABLE_DEVICE_PROPERTY);
        String lastSelectedDebuggerId = properties.getValue(DEBUGGER_ID_PROPERTY);
        boolean showAllProcesses = Boolean.parseBoolean(properties.getValue(SHOW_ALL_PROCESSES_PROPERTY));
        this.myShowAllProcessesCheckBox.setSelected(showAllProcesses);
        this.doUpdateTree(showAllProcesses);
        this.myClientChangeListener = (client, changeMask) -> this.updateTree();
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
        this.myDeviceChangeListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(@NotNull IDevice device) {
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/actions/AndroidProcessChooserDialog$1", "deviceConnected"));
                }
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceDisconnected(@NotNull IDevice device) {
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/actions/AndroidProcessChooserDialog$1", "deviceDisconnected"));
                }
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceChanged(@NotNull IDevice device, int changeMask) {
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/actions/AndroidProcessChooserDialog$1", "deviceChanged"));
                }
                AndroidProcessChooserDialog.this.updateTree();
            }
        };
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        this.myShowAllProcessesCheckBox.addActionListener(e -> this.updateTree());
        this.setupDebuggerSelection(showDebuggerSelection, lastSelectedDebuggerId);
        this.myProcessTree.addTreeSelectionListener(e -> {
            IDevice selectedDevice = this.getSelectedDevice();
            Client selectedClient = this.getSelectedClient();
            this.myLastSelectedDevice = AndroidProcessChooserDialog.getPersistableName(selectedDevice);
            this.myLastSelectedProcess = AndroidProcessChooserDialog.getPersistableName(selectedClient);
            this.getOKAction().setEnabled(selectedDevice != null && selectedClient != null);
        });
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch((JTree)this.myProcessTree){

            protected boolean isMatchingElement(Object element, String pattern) {
                Object userObject;
                Object lastComponent;
                if (element instanceof TreePath && (lastComponent = ((TreePath)element).getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)lastComponent).getUserObject()) instanceof Client) {
                    String pkg = ((Client)userObject).getClientData().getClientDescription();
                    return pkg != null && pkg.contains(pattern);
                }
                return false;
            }
        };
        this.myProcessTree.setCellRenderer((TreeCellRenderer)((Object)new MyProcessTreeCellRenderer(treeSpeedSearch)));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myProcessTree);
        this.myProcessTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                }
            }
        });
        this.init();
    }

    private void setupDebuggerSelection(boolean showDebuggerSelection, @Nullable String lastSelectedDebuggerId) {
        if (!showDebuggerSelection) {
            this.myDebuggerLabel.setVisible(false);
            this.myDebuggerTypeCombo.setVisible(false);
            return;
        }
        AndroidDebugger selectedDebugger = null;
        AndroidDebugger defaultDebugger = null;
        LinkedList androidDebuggers = Lists.newLinkedList();
        for (AndroidDebugger androidDebugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            if (!androidDebugger.supportsProject(this.myProject)) continue;
            androidDebuggers.add(androidDebugger);
            if (selectedDebugger == null && lastSelectedDebuggerId != null && androidDebugger.getId().equals(lastSelectedDebuggerId)) {
                selectedDebugger = androidDebugger;
                continue;
            }
            if (!androidDebugger.shouldBeDefault()) continue;
            defaultDebugger = androidDebugger;
        }
        if (selectedDebugger == null) {
            selectedDebugger = defaultDebugger;
        }
        androidDebuggers.sort((left, right) -> left.getId().compareTo(right.getId()));
        this.myDebuggerTypeCombo.setModel(new CollectionComboBoxModel((List)androidDebuggers));
        this.myDebuggerTypeCombo.setRenderer(new AndroidDebugger.Renderer());
        if (selectedDebugger != null) {
            this.myDebuggerTypeCombo.setSelectedItem(selectedDebugger);
        }
    }

    @NotNull
    private static String getPersistableName(@Nullable Client client) {
        String string = client == null ? "" : client.getClientData().getClientDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "getPersistableName"));
        }
        return string;
    }

    @NotNull
    private static String getPersistableName(@Nullable IDevice device) {
        String string = device == null ? "" : device.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "getPersistableName"));
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProcessTree;
    }

    protected void dispose() {
        super.dispose();
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
    }

    private void updateTree() {
        final boolean showAllProcesses = this.myShowAllProcessesCheckBox.isSelected();
        this.myUpdatesQueue.queue(new Update((Object)this){

            public void run() {
                AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(AndroidProcessChooserDialog.this.myProject);
                if (debugBridge != null && AdbService.isDdmsCorrupted(debugBridge)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Messages.showErrorDialog((Component)AndroidProcessChooserDialog.this.myContentPanel, (String)AndroidBundle.message("ddms.corrupted.error", new Object[0]));
                        AndroidProcessChooserDialog.this.close(1);
                    });
                    return;
                }
                AndroidProcessChooserDialog.this.doUpdateTree(showAllProcesses);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private void doUpdateTree(boolean showAllProcesses) {
        IDevice[] devices;
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        if (debugBridge == null) {
            this.myProcessTree.setModel((TreeModel)model);
            return;
        }
        Set<String> processNames = AndroidProcessChooserDialog.collectAllProcessNames(this.myProject);
        DefaultMutableTreeNode selectedDeviceNode = null;
        DefaultMutableTreeNode selectedClientNode = null;
        Object[] firstTreePath = null;
        for (IDevice device : devices = debugBridge.getDevices()) {
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(device);
            root.add(deviceNode);
            String deviceName = device.getName();
            if (deviceName.equals(this.myLastSelectedDevice)) {
                selectedDeviceNode = deviceNode;
            }
            ArrayList clients = Lists.newArrayList((Object[])device.getClients());
            Collections.sort(clients, (c1, c2) -> {
                String n1 = StringUtil.notNullize((String)c1.getClientData().getClientDescription());
                String n2 = StringUtil.notNullize((String)c2.getClientData().getClientDescription());
                return n1.compareTo(n2);
            });
            for (Client client : clients) {
                String clientDescription = client.getClientData().getClientDescription();
                if (clientDescription == null || !showAllProcesses && !AndroidProcessChooserDialog.isRelatedProcess(processNames, clientDescription)) continue;
                DefaultMutableTreeNode clientNode = new DefaultMutableTreeNode(client);
                deviceNode.add(clientNode);
                if (clientDescription.equals(this.myLastSelectedProcess) && (selectedDeviceNode == null || deviceName.equals(this.myLastSelectedDevice))) {
                    selectedClientNode = clientNode;
                    selectedDeviceNode = deviceNode;
                }
                if (firstTreePath != null) continue;
                firstTreePath = new Object[]{root, deviceNode, clientNode};
            }
        }
        Object[] pathToSelect = selectedDeviceNode != null && selectedClientNode != null ? new Object[]{root, selectedDeviceNode, selectedClientNode} : (selectedDeviceNode != null ? new Object[]{root, selectedDeviceNode} : firstTreePath);
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myProcessTree.setModel((TreeModel)model);
            if (pathToSelect != null) {
                this.myProcessTree.getSelectionModel().setSelectionPath(new TreePath(pathToSelect));
            } else {
                this.getOKAction().setEnabled(false);
            }
            TreeUtil.expandAll((JTree)this.myProcessTree);
        });
    }

    private static boolean isRelatedProcess(Set<String> processNames, String clientDescription) {
        String lc = clientDescription.toLowerCase();
        for (String processName : processNames) {
            if (!lc.startsWith(processName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<String> collectAllProcessNames(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        HashSet result = new HashSet();
        for (AndroidFacet facet : facets) {
            AndroidModel androidModel;
            XmlElement xmlElement;
            Manifest manifest;
            String packageName = AndroidCompileUtil.getAaptManifestPackage(facet);
            if (packageName != null) {
                result.add(packageName.toLowerCase());
            }
            if ((manifest = facet.getManifest()) != null && (xmlElement = manifest.getXmlElement()) != null) {
                AndroidProcessChooserDialog.collectProcessNames(xmlElement, (Set<String>)result);
            }
            if ((androidModel = facet.getAndroidModel()) == null) continue;
            result.addAll(androidModel.getAllApplicationIds());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "collectAllProcessNames"));
        }
        return hashSet;
    }

    private static void collectProcessNames(XmlElement xmlElement, final Set<String> result) {
        xmlElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                String value;
                if ("process".equals(attribute.getLocalName()) && (value = attribute.getValue()) != null) {
                    result.add(value.toLowerCase());
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    protected void doOKAction() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice == null) {
            return;
        }
        this.mySelectedClient = this.getSelectedClient();
        if (this.mySelectedClient == null) {
            return;
        }
        this.myAndroidDebugger = (AndroidDebugger)this.myDebuggerTypeCombo.getSelectedItem();
        properties.setValue(DEBUGGABLE_DEVICE_PROPERTY, AndroidProcessChooserDialog.getPersistableName(selectedDevice));
        properties.setValue(DEBUGGABLE_PROCESS_PROPERTY, AndroidProcessChooserDialog.getPersistableName(this.mySelectedClient));
        properties.setValue(SHOW_ALL_PROCESSES_PROPERTY, Boolean.toString(this.myShowAllProcessesCheckBox.isSelected()));
        if (this.myAndroidDebugger != null) {
            properties.setValue(DEBUGGER_ID_PROPERTY, this.myAndroidDebugger.getId());
        }
        super.doOKAction();
    }

    @Nullable
    public Client getClient() {
        return this.mySelectedClient;
    }

    @NotNull
    public AndroidDebugger getAndroidDebugger() {
        assert (this.myShowDebuggerSelection) : "Cannot obtain debugger after constructing dialog w/o debugger selection combo";
        AndroidDebugger androidDebugger = this.myAndroidDebugger;
        if (androidDebugger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "getAndroidDebugger"));
        }
        return androidDebugger;
    }

    protected String getDimensionServiceKey() {
        return "AndroidProcessChooserDialog";
    }

    @Nullable
    private IDevice getSelectedDevice() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
        Object obj = selectedNode.getUserObject();
        return obj instanceof IDevice ? (IDevice)obj : null;
    }

    @Nullable
    private Client getSelectedClient() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 3) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(2);
        Object obj = selectedNode.getUserObject();
        return obj instanceof Client ? (Client)obj : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JBCheckBox jBCheckBox;
        Tree tree;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Select a process to attach to:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(250, 300), null));
        this.myProcessTree = tree = new Tree();
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        jBScrollPane.setViewportView((Component)tree);
        this.myShowAllProcessesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show all processes");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myDebuggerLabel = jLabel = new JLabel();
        jLabel.setText("Debugger:");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebuggerTypeCombo = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(true);
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel.setLabelFor((Component)jBScrollPane);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class MyProcessTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        public MyProcessTreeCellRenderer(@NotNull TreeSpeedSearch treeSpeedSearch) {
            if (treeSpeedSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeSpeedSearch", "org/jetbrains/android/actions/AndroidProcessChooserDialog$MyProcessTreeCellRenderer", "<init>"));
            }
            this.mySpeedSearch = treeSpeedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/android/actions/AndroidProcessChooserDialog$MyProcessTreeCellRenderer", "customizeCellRenderer"));
            }
            if (!(value instanceof DefaultMutableTreeNode)) {
                return;
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof IDevice) {
                DeviceRenderer.renderDeviceName((IDevice)userObject, (ColoredTextContainer)this);
            } else if (userObject instanceof Client) {
                ClientData clientData = ((Client)userObject).getClientData();
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)clientData.getClientDescription(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
                if (clientData.isValidUserId() && clientData.getUserId() != 0) {
                    this.append(" (user " + Integer.toString(clientData.getUserId()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

