/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.annotations.NotNull;

public abstract class CreateResourceActionBase
extends AnAction {
    protected CreateResourceActionBase() {
    }

    protected CreateResourceActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected abstract PsiElement[] invokeDialog(@NotNull Project var1, @NotNull DataContext var2);

    @NotNull
    protected abstract PsiElement[] create(String var1, PsiDirectory var2) throws Exception;

    protected abstract String getErrorTitle();

    protected abstract String getCommandName();

    protected abstract String getActionName(PsiDirectory var1, String var2);

    public final void actionPerformed(AnActionEvent e) {
        PsiElement[] createdElements;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        for (PsiElement createdElement : createdElements = this.invokeDialog(project, dataContext)) {
            view.selectElement(createdElement);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    public boolean isDumbAware() {
        return false;
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb() && !this.isDumbAware()) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return view != null && view.getDirectories().length != 0;
    }

    protected class MyInputValidator
    extends ElementCreator
    implements ElementCreatingValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            super(project, CreateResourceActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        public PsiElement[] create(String newName) throws Exception {
            return CreateResourceActionBase.this.create(newName, this.myDirectory);
        }

        public String getActionName(String newName) {
            return CreateResourceActionBase.this.getActionName(this.myDirectory, newName);
        }

        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        @Override
        @NotNull
        public final PsiElement[] getCreatedElements() {
            if (this.myCreatedElements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceActionBase$MyInputValidator", "getCreatedElements"));
            }
            return this.myCreatedElements;
        }
    }
}

