/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddBroadcastReceiverToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        if ("Add broadcast receiver to manifest" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AddBroadcastReceiverToManifest", "getText"));
        }
        return "Add broadcast receiver to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/intentions/AddBroadcastReceiverToManifest", "isAvailable"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/intentions/AddBroadcastReceiverToManifest", "isAvailable"));
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.content.BroadcastReceiver")) {
            return false;
        }
        return !AddBroadcastReceiverToManifest.isRegisteredBroadcastReceiver(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/intentions/AddBroadcastReceiverToManifest", "invoke"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/intentions/AddBroadcastReceiverToManifest", "invoke"));
        }
        Application application = manifest.getApplication();
        application.addReceiver().getReceiverClass().setValue(psiClass);
    }

    private static boolean isRegisteredBroadcastReceiver(PsiClass psiClass, Application application) {
        for (Receiver receiver : application.getReceivers()) {
            if (!psiClass.isEquivalentTo((PsiElement)receiver.getReceiverClass().getValue())) continue;
            return true;
        }
        return false;
    }
}

