/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.IAbstractResource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.android.uipreview.VirtualFileWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFolderWrapper
implements IAbstractFolder {
    private final Project myProject;
    private final VirtualFile myFolder;

    public VirtualFolderWrapper(@NotNull Project project, @NotNull VirtualFile folder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/uipreview/VirtualFolderWrapper", "<init>"));
        }
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "org/jetbrains/android/uipreview/VirtualFolderWrapper", "<init>"));
        }
        this.myProject = project;
        this.myFolder = folder;
    }

    public boolean hasFile(String name) {
        return this.myFolder.findChild(name) != null;
    }

    @Nullable
    public IAbstractFile getFile(String name) {
        VirtualFile child = this.myFolder.findChild(name);
        return child != null && !child.isDirectory() ? new VirtualFileWrapper(this.myProject, child) : null;
    }

    @Nullable
    public IAbstractFolder getFolder(String name) {
        VirtualFile child = this.myFolder.findChild(name);
        return child != null && child.isDirectory() ? new VirtualFolderWrapper(this.myProject, child) : null;
    }

    public IAbstractResource[] listMembers() {
        VirtualFile[] children = this.myFolder.getChildren();
        IAbstractResource[] result = new IAbstractResource[children.length];
        for (int i = 0; i < result.length; ++i) {
            VirtualFile child = children[i];
            result[i] = child.isDirectory() ? new VirtualFolderWrapper(this.myProject, child) : new VirtualFileWrapper(this.myProject, child);
        }
        return result;
    }

    public String[] list(IAbstractFolder.FilenameFilter filter) {
        VirtualFile[] children = this.myFolder.getChildren();
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualFile child : children) {
            String name = child.getName();
            if (filter != null && !filter.accept((IAbstractFolder)this, name)) continue;
            result.add(name);
        }
        return ArrayUtil.toStringArray(result);
    }

    public String getName() {
        return this.myFolder.getName();
    }

    public String getOsLocation() {
        return FileUtil.toSystemDependentName((String)this.myFolder.getPath());
    }

    public String getPath() {
        return this.myFolder.getPath();
    }

    public boolean exists() {
        return this.myFolder.exists();
    }

    @Nullable
    public IAbstractFolder getParentFolder() {
        VirtualFile parent = this.myFolder.getParent();
        return parent != null ? new VirtualFolderWrapper(this.myProject, parent) : null;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFolderWrapper wrapper = (VirtualFolderWrapper)o;
        if (!this.myFolder.equals(wrapper.myFolder)) {
            return false;
        }
        return this.myProject.equals(wrapper.myProject);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myFolder.hashCode();
        return result;
    }
}

