/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerComponent;
import com.intellij.byteCodeViewer.ClassSearcher;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.content.Content;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ByteCodeViewerManager
extends DockablePopupManager<ByteCodeViewerComponent> {
    private static final ExtensionPointName<ClassSearcher> CLASS_SEARCHER_EP = ExtensionPointName.create((String)"ByteCodeViewer.classSearcher");
    private static final Logger LOG = Logger.getInstance((String)("#" + ByteCodeViewerManager.class.getName()));
    private static final String TOOLWINDOW_ID = "Byte Code Viewer";
    private static final String SHOW_BYTECODE_IN_TOOL_WINDOW = "BYTE_CODE_TOOL_WINDOW";
    private static final String BYTECODE_AUTO_UPDATE_ENABLED = "BYTE_CODE_AUTO_UPDATE_ENABLED";

    public static ByteCodeViewerManager getInstance(Project project) {
        return (ByteCodeViewerManager)((Object)ServiceManager.getService((Project)project, ByteCodeViewerManager.class));
    }

    public ByteCodeViewerManager(Project project) {
        super(project);
    }

    public String getShowInToolWindowProperty() {
        return SHOW_BYTECODE_IN_TOOL_WINDOW;
    }

    public String getAutoUpdateEnabledProperty() {
        return BYTECODE_AUTO_UPDATE_ENABLED;
    }

    protected String getToolwindowId() {
        return TOOLWINDOW_ID;
    }

    protected String getAutoUpdateTitle() {
        return "Auto Show Bytecode for Selected Element";
    }

    protected String getAutoUpdateDescription() {
        return "Show bytecode for current element automatically";
    }

    protected String getRestorePopupDescription() {
        return "Restore bytecode popup behavior";
    }

    protected ByteCodeViewerComponent createComponent() {
        return new ByteCodeViewerComponent(this.myProject, this.createActions());
    }

    @Nullable
    protected String getTitle(PsiElement element) {
        PsiClass aClass = ByteCodeViewerManager.getContainingClass(element);
        if (aClass == null) {
            return null;
        }
        return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)aClass);
    }

    private void updateByteCode(PsiElement element, ByteCodeViewerComponent component, Content content) {
        this.updateByteCode(element, component, content, ByteCodeViewerManager.getByteCode(element));
    }

    public void updateByteCode(PsiElement element, ByteCodeViewerComponent component, Content content, String byteCode) {
        if (!StringUtil.isEmpty((String)byteCode)) {
            component.setText(byteCode, element);
        } else {
            PsiClass presentableElement = ByteCodeViewerManager.getContainingClass(element);
            if (presentableElement == null) {
                presentableElement = element.getContainingFile();
                if (presentableElement == null && element instanceof PsiNamedElement) {
                    presentableElement = element;
                }
                if (presentableElement == null) {
                    component.setText("No bytecode found");
                    return;
                }
            }
            component.setText("No bytecode found for " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)presentableElement));
        }
        content.setDisplayName(this.getTitle(element));
    }

    protected void doUpdateComponent(PsiElement element, PsiElement originalElement, ByteCodeViewerComponent component) {
        Content content = this.myToolWindow.getContentManager().getSelectedContent();
        if (content != null && element != null) {
            this.updateByteCode(element, component, content);
        }
    }

    protected void doUpdateComponent(Editor editor, PsiFile psiFile) {
        Content content = this.myToolWindow.getContentManager().getSelectedContent();
        if (content != null) {
            ByteCodeViewerComponent component = (ByteCodeViewerComponent)content.getComponent();
            PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
            if (element != null) {
                this.updateByteCode(element, component, content);
            }
        }
    }

    protected void doUpdateComponent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/byteCodeViewer/ByteCodeViewerManager", "doUpdateComponent"));
        }
        this.doUpdateComponent(element, ByteCodeViewerManager.getByteCode(element));
    }

    protected void doUpdateComponent(@NotNull PsiElement element, String newText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/byteCodeViewer/ByteCodeViewerManager", "doUpdateComponent"));
        }
        Content content = this.myToolWindow.getContentManager().getSelectedContent();
        if (content != null) {
            this.updateByteCode(element, (ByteCodeViewerComponent)content.getComponent(), content, newText);
        }
    }

    @Nullable
    public static String getByteCode(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/byteCodeViewer/ByteCodeViewerManager", "getByteCode"));
        }
        PsiClass containingClass = ByteCodeViewerManager.getContainingClass(psiElement);
        if (containingClass == null) {
            return null;
        }
        CompilerPathsEx.ClassFileDescriptor file = CompilerPathsEx.findClassFileInOutput((PsiClass)containingClass);
        if (file != null) {
            try {
                return ByteCodeViewerManager.processClassFile(file.loadFileBytes());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processClassFile(byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        StringWriter writer = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(writer);){
            classReader.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), printWriter), 0);
        }
        return writer.toString();
    }

    public static PsiClass getContainingClass(PsiElement psiElement) {
        for (ClassSearcher searcher : (ClassSearcher[])CLASS_SEARCHER_EP.getExtensions()) {
            PsiClass aClass = searcher.findClass(psiElement);
            if (aClass == null) continue;
            return aClass;
        }
        return ByteCodeViewerManager.findClass(psiElement);
    }

    public static PsiClass findClass(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/byteCodeViewer/ByteCodeViewerManager", "findClass"));
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (containingClass instanceof PsiTypeParameter) {
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
        }
        if (containingClass == null) {
            return null;
        }
        return containingClass;
    }
}

