/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt;

import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavascriptParserDefinition;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.vfs.LocalFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtApplicationComponent
implements ApplicationComponent {
    private LocalFileSystem.WatchRequest myWatchRequest;

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("GwtApplicationComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/GwtApplicationComponent", "getComponentName"));
        }
        return "GwtApplicationComponent";
    }

    public void initComponent() {
        GwtApplicationComponent.initGwtReferencePSI();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(GwtCompilerPaths.getOutputRoot().getAbsolutePath(), true);
    }

    public static void initGwtReferencePSI() {
        JavascriptParserDefinition.setGwtReferenceExpressionCreator(astNode -> new JSGwtReferenceExpressionImpl((ASTNode)astNode));
    }

    public void disposeComponent() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
        }
    }
}

