/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.gwt.facet.GwtFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtBuildProperties {
    private GwtBuildProperties() {
    }

    @NotNull
    @NonNls
    public static String getGwtSdkHomeProperty() {
        if ("gwt.sdk.home" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getGwtSdkHomeProperty"));
        }
        return "gwt.sdk.home";
    }

    @NotNull
    @NonNls
    public static String getGwtSdkHomeProperty(@NotNull GwtFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/ant/GwtBuildProperties", "getGwtSdkHomeProperty"));
        }
        String string = "gwt.sdk.home." + GwtBuildProperties.getConvertedName(facet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getGwtSdkHomeProperty"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getSystemDependentGwtSdkDevJarNameProperty() {
        if ("gwt.sdk.dev.jar.name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getSystemDependentGwtSdkDevJarNameProperty"));
        }
        return "gwt.sdk.dev.jar.name";
    }

    public static String getGwtCleanTargetName() {
        return "clean.gwt.compiler.output";
    }

    private static String getConvertedName(GwtFacet facet) {
        return BuildProperties.convertName((String)facet.getModule().getName());
    }

    @NotNull
    @NonNls
    public static String getCompileGwtTargetName(@NotNull GwtFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/ant/GwtBuildProperties", "getCompileGwtTargetName"));
        }
        String string = "compile.gwt." + GwtBuildProperties.getConvertedName(facet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getCompileGwtTargetName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getRunGwtCompilerTargetName(@NotNull GwtFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/ant/GwtBuildProperties", "getRunGwtCompilerTargetName"));
        }
        String string = "run.gwt.compiler." + GwtBuildProperties.getConvertedName(facet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getRunGwtCompilerTargetName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getGwtCompilerOutputPropertyName(@NotNull GwtFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/ant/GwtBuildProperties", "getGwtCompilerOutputPropertyName"));
        }
        String string = "gwt.compiler.output." + GwtBuildProperties.getConvertedName(facet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getGwtCompilerOutputPropertyName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getGwtModuleParameter() {
        if ("gwt.module.name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildProperties", "getGwtModuleParameter"));
        }
        return "gwt.module.name";
    }
}

