/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.gwt.jsinject.GwtClassMemberReference;
import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.gwt.jsinject.JsPsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JsGwtReadWriteAccessDetector
extends ReadWriteAccessDetector {
    private static JSReadWriteAccessDetector getJSReadWriteAccessDetector() {
        return JSReadWriteAccessDetector.ourInstance;
    }

    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "isReadWriteAccessible"));
        }
        return element instanceof JSGwtReferenceExpressionImpl;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "isDeclarationWriteAccess"));
        }
        return JsGwtReadWriteAccessDetector.getJSReadWriteAccessDetector().isDeclarationWriteAccess(element);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedElement", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "getReferenceAccess"));
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "getReferenceAccess"));
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "getExpressionAccess"));
        }
        if (expression instanceof JSGwtReferenceExpressionImpl) {
            JSGwtReferenceExpressionImpl gwtExpr = (JSGwtReferenceExpressionImpl)expression;
            GwtClassMemberReference classMemberReference = (GwtClassMemberReference)((Object)ContainerUtil.findInstance((Object[])expression.getReferences(), GwtClassMemberReference.class));
            if (classMemberReference != null) {
                PsiElement resolvedReference = classMemberReference.resolve();
                PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectionHost(expression);
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)host, PsiClass.class);
                if (resolvedReference instanceof PsiField && psiClass != null && psiClass.isEquivalentTo((PsiElement)((PsiField)resolvedReference).getContainingClass())) {
                    ReadWriteAccessDetector.Access usage;
                    ReadWriteAccessDetector.Access access = usage = JsPsiUtil.isAccessedForReading(gwtExpr) ? (JsPsiUtil.isAccessedForWriting(gwtExpr) ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read) : ReadWriteAccessDetector.Access.Write;
                    if (access == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "getExpressionAccess"));
                    }
                    return access;
                }
            }
        }
        ReadWriteAccessDetector.Access access = JsGwtReadWriteAccessDetector.getJSReadWriteAccessDetector().getExpressionAccess(expression);
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JsGwtReadWriteAccessDetector", "getExpressionAccess"));
        }
        return access;
    }
}

